#include <xvinclude.h>

/*
 *  This example creates a display with three different animations
 *  which are run simulaneously.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager, rowcol, animate;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* 
	 * using a rowcol object as the backplane allows us to lay out the
         * animation objects without using relative positioning.
	 */
	manager = xvw_create_manager(NULL, "parent");
	rowcol = xvw_create_rowcol(manager, "rowcol");
	xvw_set_attributes(rowcol,
		           XVW_WIDTH,  600,
		           XVW_HEIGHT, 400,
		           XVW_ROWCOL_NUMBER_ACROSS, 2,
		           NULL);

	/*
	 *  Create the first animation object, using the baby sequence.
	 *  Set the update time, and the animation control in autoreverse.
         *  Setting the XVW_ANIMATE_DIRECTION attribute to 
         *  KANIMATE_DIRECTION_FORWARD has the effect of starting the animation
         *  in a forward progression.
	 */
	animate = xvw_create_animate(rowcol, "animate");
	xvw_set_attributes(animate,
		XVW_IMAGE_IMAGEFILE,   "sequence:baby",
		XVW_ANIMATE_UPDATETIME, 0.05,
                XVW_ANIMATE_CONTROL,    KANIMATE_CONTROL_AUTOREVERSE,
		XVW_ANIMATE_DIRECTION,  KANIMATE_DIRECTION_FORWARD,
		NULL);

	/*
	 *  Similarly to the first animation object, create the second
         *  animation object using the bushes sequence & start the animation.
	 */
	animate = xvw_create_animate(rowcol, "animate");
	xvw_set_attributes(animate,
		XVW_IMAGE_IMAGEFILE,   "sequence:bushes",
		XVW_ANIMATE_UPDATETIME, 0.05,
                XVW_ANIMATE_CONTROL,    KANIMATE_CONTROL_AUTOREVERSE,
		XVW_ANIMATE_DIRECTION,  KANIMATE_DIRECTION_FORWARD,
		NULL);

	/*
	 *  Similarly to the first two animation objects, create the third
         *  animation object using the heart sequence & start the animation.
	 */
	animate = xvw_create_animate(rowcol, "animate");
	xvw_set_attributes(animate,
		XVW_IMAGE_IMAGEFILE,   "sequence:hheart",
		XVW_ANIMATE_UPDATETIME, 0.05,
                XVW_ANIMATE_CONTROL,    KANIMATE_CONTROL_AUTOREVERSE,
		XVW_ANIMATE_DIRECTION,  KANIMATE_DIRECTION_FORWARD,
		NULL);

	/* display & run */
	xvf_run_form();
}
