 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for xvrun
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xvrun.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - GUI display & process execution tool
|
|       Purpose: main program for xvrun
|
|         Input:
|		char *clui_info->oname_string; {program to execute}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		char *clui_info->tb_string; {toolbox in which to find program}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->args_string; {command line arguments}
|		int   clui_info->args_flag; {TRUE if -args specified}
|
|        Output:
|       Returns:
|
|    Written By: Danielle Argiro
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kform      *form;
	char       **toolbox_names;
	char	   command[KLENGTH];
	kobject    toolbox       = NULL;
	kobject    program       = NULL;
	kobject    file_object   = NULL;
	kselection *selection   = NULL;
	char       *uis_filename = NULL;
	int        i = 0, toolbox_num;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DESIGN");
	kexit_handler(xvrun_free_args, NULL);

/* -main_get_args_call */
	/*
	 *  deliberately leave out call to kclui_check_args,
         *  as xvrun will be called with extra arguments that are
         *  meant for the program that xvrun is to execute.
	 */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DESIGN", "xvrun",
                               xvrun_usage_additions);
	xvrun_get_args(pane);
	kvf_destroy_form(pane);

	/*
	 *  see?  here is the command line of additional arguments
         *  whose destination is the program to be executed.
	 */
	(void) kclui_arguments(command);
	if (clui_info->args_string != NULL)
	   kstrcat(command, clui_info->args_string);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

/* -main_before_lib_call */
	/*
	 *  this is a hybrid xvroutine, so we need to set the pop-up
         *  message handlers deliberately if the display is not NULL 
         *  (ie, we are on an X Windows display).
	 */
	if (xvw_display(NULL) != NULL)
        {
            kset_errorhandler(xvu_error);
            kset_prompthandler(xvu_prompt);
            kset_infohandler(xvu_info);
            kset_choosehandler(xvu_choose);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	if (clui_info->tb_string != NULL)
	{
	    toolbox_names = (char **) kcalloc(1, sizeof(char *));
	    toolbox_num = 1;
	    toolbox_names[0] = kstrdup(clui_info->tb_string);
	}
	else if ((toolbox_names = kcms_query_toolboxes(&toolbox_num)) == NULL)
        {
            kerror(NULL, "main"
	          "No toolboxes found in which to search for program '%s'", 
	  	   clui_info->oname_string);
            kexit(KEXIT_FAILURE);
        }

	/*
	 *  ok, here's the long process of *finding* the program for which the
         *  user is requesting execution.  the process is sped up significantly
         *  if they provide a toolbox with the [-tb] string, as that one
         *  was provided as first in the list, above.
	 */
	while ((i < toolbox_num) && (uis_filename == NULL))
        {
	    if ((toolbox = kcms_open_toolbox(toolbox_names[i])) == NULL)
            {
                kinfo(KSTANDARD, "Warning: Unable to open toolbox '%s'\n",
                      toolbox_names[i++]);
                continue;
            }

	    /*
	     *  found the program. now, need to retrieve the *.pane (or *.cmd)
             *  associated with it,  so that we can create and display the 
             *  pane associated with the program in the code below.
	     */
            program = kcms_open_cmobj(toolbox, clui_info->oname_string);
	    if (program != NULL)
	    {
		if (!kcms_get_attribute(program, KCMS_CMOBJ_UIS_PANE,
					&file_object)
			|| file_object == NULL
			|| !kcms_get_attribute(file_object, KCMS_PATH,
					       &uis_filename))
		{
		    kerror(NULL, "main", "No *.pane file found for "
			   "program %s from which to define GUI;  "
			   "unable to continue; exiting.",
			   clui_info->oname_string);
		    kexit(KEXIT_FAILURE);
		}
	    }
	    i++;
	}

	/*
	 *  create the GUI from the *.pane file, modify GUI with any args
         *  provided on cmd line, and display
	 */
	if (uis_filename != NULL)
	{
	    /* create the GUI as specified by *.pane file */
	    form = xvf_create_form(uis_filename, NONE, NULL, NULL, 
				   XVF_NO_EDIT, -1, -1);

	    /* GUI has to be a single pane on a single subform */
	    if (!(kvf_check_for_single_pane(form, "main")))
                 kexit(KEXIT_FAILURE);

	    /* set icon name of displayed pane to object name */
            if (form->subform->toplevel != NULL)
                xvw_set_attribute(form->subform->toplevel, XVW_SHELL_ICON_NAME, 
                                  clui_info->oname_string);
	 
	    /* modify GUI according to cmd line args */
	    if ((clui_info->args_flag) && (clui_info->args_string != NULL))
                xvf_modify_form_from_cmd(form, clui_info->args_string);
	 
	
	    /* find routine button & add extra call to print out cmd line */
	    selection =
		 kvf_gui_named_item_exists(form->subform->guide->pane->sel_list,
                                           KUIS_ROUTINE, -1);
	    if (selection != NULL)
		xvf_add_extra_call(selection->back_kformstruct, xvrun_print_cmd,
			           (kaddr) selection, XVF_CALL_FIRST);
	    /* display & run */
	    xvf_run_form();
	}

	/*
	 *  found the program, but can't get the definition of its pane
	 */
	else
	{
	    if (clui_info->tb_string == NULL)
	        kerror(NULL, "main", 
		      "Sorry, unable to find *.pane for the program '%s' in any of the current toolboxes; you may have to run it from the command line.", clui_info->oname_string);
	    else kerror(NULL, "main", 
		      "Sorry, unable to find *.pane for the program '%s' in the toolbox '%s'; you may have to run it from the command line, or look for it in a different toolbox.",  clui_info->oname_string, clui_info->tb_string);
	}

	/*
	 *  cleanup
	 */
	for (i = 0; i < toolbox_num; i++)
	    kfree(toolbox_names[i]);
	kfree(toolbox_names);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: xvrun_usage_additions
| 
|       Purpose: Prints usage additions in xvrun_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname xvrun
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void xvrun_usage_additions(void)
{
	kfprintf(kstderr, "\tGUI display & process execution tool\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: xvrun_free_args
| 
|       Purpose: Frees CLUI struct allocated in xvrun_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname xvrun
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
xvrun_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->oname_string);
	kfree(clui_info->tb_string);
	kfree(clui_info->args_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
