 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_preview
   >>>> 	_xvf_free_preview
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_preview_warning
   >>>> 	_xvf_init_preview_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "preview.h"

static void _xvf_init_preview_warning PROTO((char *));
static void _xvf_init_preview_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_preview
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_preview_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_preview(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	/*
	 * initializing 'preview' Form Info structure
	 */

	forminfo->show_struct =
	    kvf_create_struct_from_subformname(form, "preview.show");
	if (forminfo->show_struct == NULL)
	{
	    _xvf_init_preview_error("subform 'show' on form 'preview'", 
			    "preview_show");
	    return(FALSE);
	}

	/*
	 * initializing 'preview->show' Subform Info structure
	 */

	forminfo->show = (preview_show *)
				kcalloc(1, sizeof(preview_show));
	subform = forminfo->show_struct->Subformptr;

	/*
	 * initializing 'preview->show->view' Pane Info structure
	 */

	forminfo->show->view = (show_view *)
				kcalloc(1, sizeof(show_view));
	forminfo->show->view_struct =
	    kvf_create_struct_from_panename(subform, "preview.show.view");
	if (forminfo->show->view_struct == NULL)
	{
	    _xvf_init_preview_error("pane 'view' on subform 'show'", "show_view");
	    return(FALSE);
	}
	pane = forminfo->show->view_struct->Controlptr;
	forminfo->show->view->license_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "preview.show.view.license");
	if (forminfo->show->view->license_struct == NULL)
		    _xvf_init_preview_warning("unknown selection 'license' on pane 'view' of subform 'show'");

	forminfo->show->view->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "preview.show.view.help");
	if (forminfo->show->view->help_struct == NULL)
		    _xvf_init_preview_warning("unknown selection 'help' on pane 'view' of subform 'show'");

	forminfo->show->view->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "preview.show.view.quit");
	if (forminfo->show->view->quit_struct == NULL)
		    _xvf_init_preview_warning("quit button 'quit' on pane 'view' of subform 'show'");
	forminfo->show->view->quit = FALSE;

	forminfo->show->view->i_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "preview.show.view.i");
	if (forminfo->show->view->i_struct != NULL)
	{
	    selection = forminfo->show->view->i_struct->Selptr;
	    kvf_get_attribute(forminfo->show->view->i_struct, KVF_FILE_DEF,
	                    &(forminfo->show->view->i));
	}
	else
	    _xvf_init_preview_warning("input selection 'i' on pane 'view' of subform 'show'");

	forminfo->show->view->i_selected = FALSE;

	forminfo->show->view->revisit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "preview.show.view.revisit");
	if (forminfo->show->view->revisit_struct == NULL)
	    _xvf_init_preview_warning("pane action button 'revisit' on pane 'view' of subform 'show'");
	forminfo->show->view->revisit = FALSE;
	selection = forminfo->show->view->revisit_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->show->view->edit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "preview.show.view.edit");
	if (forminfo->show->view->edit_struct == NULL)
	    _xvf_init_preview_warning("pane action button 'edit' on pane 'view' of subform 'show'");
	forminfo->show->view->edit = FALSE;
	selection = forminfo->show->view->edit_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->show->view->print_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "preview.show.view.print");
	if (forminfo->show->view->print_struct != NULL)
	{
	    selection = forminfo->show->view->print_struct->Selptr;
	    kvf_get_attribute(forminfo->show->view->print_struct, KVF_FILE_DEF,
	                    &(forminfo->show->view->print));
	}
	else
	    _xvf_init_preview_warning("output selection 'print' on pane 'view' of subform 'show'");

	forminfo->show->view->print_selected = FALSE;


	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_preview_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_preview_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_preview_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_preview_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_preview
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_preview_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_preview(
    gui_info_struct *forminfo)
{
	if (forminfo->show->view->license_struct != NULL)
	    kfree(forminfo->show->view->license_struct);
	if (forminfo->show->view->help_struct != NULL)
	    kfree(forminfo->show->view->help_struct);
	if (forminfo->show->view->quit_struct != NULL)
	    kfree(forminfo->show->view->quit_struct);
	kfree(forminfo->show->view->i);
	if (forminfo->show->view->i_struct != NULL)
	    kfree(forminfo->show->view->i_struct);
	if (forminfo->show->view->revisit_struct != NULL)
	    kfree(forminfo->show->view->revisit_struct);
	if (forminfo->show->view->edit_struct != NULL)
	    kfree(forminfo->show->view->edit_struct);
	kfree(forminfo->show->view->print);
	if (forminfo->show->view->print_struct != NULL)
	    kfree(forminfo->show->view->print_struct);
	kfree(forminfo->show->view);
	if (forminfo->show->view_struct != NULL)
	    kfree(forminfo->show->view_struct);


	if (forminfo->show_struct != NULL)
	    kfree(forminfo->show_struct);
	kfree(forminfo->show);
	kfree(forminfo);
}
