 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_guise
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_options
   >>>> 	_xvf_get_create
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "guise.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_guise
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name guise -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_guise(
     gui_info_struct *forminfo)
{
	ksubform   *subform;
	if (forminfo->options_struct != NULL)
	{
	    subform = forminfo->options_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->options_selected));
	    _xvf_get_options(forminfo->options);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_options
| 
|       Purpose: Extracts information from options subform
| 
|         Input: subforminfo - pointer to guise_options structure
| 
|        Output: none
|    Written By: conductor -name guise -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_options(
     guise_options *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->create_struct != NULL)
	{
	    pane = subforminfo->create_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->create_selected));
	    _xvf_get_create(subforminfo->create);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_create
| 
|       Purpose: Extracts information from create pane
| 
|         Input: paneinfo - pointer to options_create structure
| 
|        Output: none
|    Written By: conductor -name guise -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_create(
     options_create *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'guise->options->create' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->i_struct != NULL)
	{
	    selection = paneinfo->i_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->i != NULL) kfree(paneinfo->i);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->i));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->i_selected));
	    }
	}

	if (paneinfo->save_struct != NULL)
	{
	    selection = paneinfo->save_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->save));

	}

	if (paneinfo->reload_struct != NULL)
	{
	    selection = paneinfo->reload_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->reload));

	}

	if (paneinfo->edit_struct != NULL)
	{
	    selection = paneinfo->edit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->edit));

	}

	if (paneinfo->new_struct != NULL)
	{
	    selection = paneinfo->new_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->new));

	}

	if (paneinfo->copy_struct != NULL)
	{
	    selection = paneinfo->copy_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->copy));

	}

	if (paneinfo->menuform_struct != NULL)
	{
	    selection = paneinfo->menuform_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->menuform));

	}

	if (paneinfo->delete_struct != NULL)
	{
	    selection = paneinfo->delete_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->delete));

	}

	if (paneinfo->submenu_struct != NULL)
	{
	    selection = paneinfo->submenu_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->submenu));

	}

	if (paneinfo->me_group_req_struct != NULL)
	{
	    selection = paneinfo->me_group_req_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->me_group_req));

	}

	if (paneinfo->me_group_opt_struct != NULL)
	{
	    selection = paneinfo->me_group_opt_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->me_group_opt));

	}

	if (paneinfo->mi_group_struct != NULL)
	{
	    selection = paneinfo->mi_group_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->mi_group));

	}

	if (paneinfo->ls_group_struct != NULL)
	{
	    selection = paneinfo->ls_group_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->ls_group));

	}

	if (paneinfo->o_struct != NULL)
	{
	    selection = paneinfo->o_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->o != NULL) kfree(paneinfo->o);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->o));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->o_selected));
	    }
	}

	if (paneinfo->control_dest_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->control_dest_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->control_dest_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->control_dest_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->control_dest_selected));
	    }

	}

	if (paneinfo->force_struct != NULL)
	{
	   selection = paneinfo->force_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->force));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->force_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->force_selected));
	    }

	}

	if (paneinfo->int_sel_struct != NULL)
	{
	    selection = paneinfo->int_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->int_sel));

	}

	if (paneinfo->float_sel_struct != NULL)
	{
	    selection = paneinfo->float_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->float_sel));

	}

	if (paneinfo->double_sel_struct != NULL)
	{
	    selection = paneinfo->double_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->double_sel));

	}

	if (paneinfo->string_sel_struct != NULL)
	{
	    selection = paneinfo->string_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->string_sel));

	}

	if (paneinfo->flag_sel_struct != NULL)
	{
	    selection = paneinfo->flag_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->flag_sel));

	}

	if (paneinfo->logic_sel_struct != NULL)
	{
	    selection = paneinfo->logic_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->logic_sel));

	}

	if (paneinfo->infile_sel_struct != NULL)
	{
	    selection = paneinfo->infile_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->infile_sel));

	}

	if (paneinfo->outfile_sel_struct != NULL)
	{
	    selection = paneinfo->outfile_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->outfile_sel));

	}

	if (paneinfo->stdin_sel_struct != NULL)
	{
	    selection = paneinfo->stdin_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->stdin_sel));

	}

	if (paneinfo->stdout_sel_struct != NULL)
	{
	    selection = paneinfo->stdout_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->stdout_sel));

	}

	if (paneinfo->action_button_struct != NULL)
	{
	    selection = paneinfo->action_button_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->action_button));

	}

	if (paneinfo->routine_button_struct != NULL)
	{
	    selection = paneinfo->routine_button_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->routine_button));

	}

	if (paneinfo->help_button_struct != NULL)
	{
	    selection = paneinfo->help_button_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->help_button));

	}

	if (paneinfo->quit_button_struct != NULL)
	{
	    selection = paneinfo->quit_button_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit_button));

	}

	if (paneinfo->guide_button_struct != NULL)
	{
	    selection = paneinfo->guide_button_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->guide_button));

	}

	if (paneinfo->cycle_sel_struct != NULL)
	{
	    selection = paneinfo->cycle_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->cycle_sel));

	}

	if (paneinfo->list_sel_struct != NULL)
	{
	    selection = paneinfo->list_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->list_sel));

	}

	if (paneinfo->displaylist_sel_struct != NULL)
	{
	    selection = paneinfo->displaylist_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->displaylist_sel));

	}

	if (paneinfo->strlist_sel_struct != NULL)
	{
	    selection = paneinfo->strlist_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->strlist_sel));

	}

	if (paneinfo->flag_toggle_struct != NULL)
	{
	    selection = paneinfo->flag_toggle_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->flag_toggle));

	}

	if (paneinfo->logical_toggle_struct != NULL)
	{
	    selection = paneinfo->logical_toggle_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->logical_toggle));

	}

	if (paneinfo->int_toggle_struct != NULL)
	{
	    selection = paneinfo->int_toggle_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->int_toggle));

	}

	if (paneinfo->flt_toggle_struct != NULL)
	{
	    selection = paneinfo->flt_toggle_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->flt_toggle));

	}

	if (paneinfo->dbl_toggle_struct != NULL)
	{
	    selection = paneinfo->dbl_toggle_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->dbl_toggle));

	}

	if (paneinfo->str_toggle_struct != NULL)
	{
	    selection = paneinfo->str_toggle_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->str_toggle));

	}

	if (paneinfo->infile_toggle_struct != NULL)
	{
	    selection = paneinfo->infile_toggle_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->infile_toggle));

	}

	if (paneinfo->outfile_toggle_struct != NULL)
	{
	    selection = paneinfo->outfile_toggle_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->outfile_toggle));

	}

	if (paneinfo->wksp_sel_struct != NULL)
	{
	    selection = paneinfo->wksp_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->wksp_sel));

	}

	if (paneinfo->blank_sel_struct != NULL)
	{
	    selection = paneinfo->blank_sel_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->blank_sel));

	}

	if (paneinfo->subform_button_struct != NULL)
	{
	    selection = paneinfo->subform_button_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->subform_button));

	}

}


