 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'guise'
   >>>> 
   >>>>  Private: 
   >>>> 	run_guise
   >>>> 	run_options
   >>>> 	run_create
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "guise.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_guise
| 
|       Purpose: Main GUI Driver for guise
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname guise -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_guise(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_guise(master_info);

	if (form->quit)
	{
	    if ((save_needed) && (display_form != NULL))
            {
                if (kprompt(KSTANDARD, "Yes", "No", 1,
                    "Save changes before destroying displayed form?"))
                    create_save(master_info->options->create);
            }
            xvf_destroy_form(display_form);
            display_form = NULL;

	    xvf_destroy_allforms();
	    _xvf_free_guise(master_info);
	    return;
	}

	/*
	 * action came from the 'options' subform
	 */
	if (master_info->options_selected)
	    run_options(master_info->options);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_options
| 
|       Purpose: GUI Driver for subform 'options'
| 
|         Input: form      - pointer to the form tree
|                options_info - pointer to guise_options struct
| 
|        Output: None
|    Written By: conductor -program_name guise -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_options(
     guise_options *options_info)
{

	/*
	 * action came from the 'create' pane
	 */
	if (options_info->create_selected)
	    run_create(options_info->create);


}   /* end run_options */



/*-----------------------------------------------------------
| 
|  Routine Name: run_create
| 
|       Purpose: GUI Driver for pane 'create'
| 
|         Input: form - pointer to the form tree
|                create_info - pointer to options_create struct
| 
|        Output: None
|    Written By: conductor -program_name guise -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_create(
     options_create *create_info)

{

	/*
	 * user selected 'live' input file selection 'i'
	 */
	if (create_info->i_selected)
	{
	    create_i(create_info);
	    create_info->i_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'save'
	 */
	else if (create_info->save)
	{
	    create_save(create_info);
	    create_info->save = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'reload'
	 */
	else if (create_info->reload)
	{
	    create_reload(create_info);
	    create_info->reload = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'edit'
	 */
	else if (create_info->edit)
	{
	    create_edit(create_info);
	    create_info->edit = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'new'
	 */
	else if (create_info->new)
	{
	    create_new(create_info);
	    create_info->new = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'copy'
	 */
	else if (create_info->copy)
	{
	    create_copy(create_info);
	    create_info->copy = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'menuform'
	 */
	else if (create_info->menuform)
	{
	    create_menuform(create_info);
	    create_info->menuform = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'delete'
	 */
	else if (create_info->delete)
	{
	    create_delete(create_info);
	    create_info->delete = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'submenu'
	 */
	else if (create_info->submenu)
	{
	    create_submenu(create_info);
	    create_info->submenu = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'me_group_req'
	 */
	else if (create_info->me_group_req)
	{
	    create_me_group_req(create_info);
	    create_info->me_group_req = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'me_group_opt'
	 */
	else if (create_info->me_group_opt)
	{
	    create_me_group_opt(create_info);
	    create_info->me_group_opt = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'mi_group'
	 */
	else if (create_info->mi_group)
	{
	    create_mi_group(create_info);
	    create_info->mi_group = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'ls_group'
	 */
	else if (create_info->ls_group)
	{
	    create_ls_group(create_info);
	    create_info->ls_group = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'o'
	 */
	else if (create_info->o_selected)
	{
	    create_o(create_info);
	    create_info->o_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'control_dest'
	 */
	else if (create_info->control_dest_selected)
	{
	    create_control_dest(create_info);
	    create_info->control_dest_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'force'
	 */
	else if (create_info->force_selected)
	{
	    create_force(create_info);
	    create_info->force_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'int_sel'
	 */
	else if (create_info->int_sel)
	{
	    create_int_sel(create_info);
	    create_info->int_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'float_sel'
	 */
	else if (create_info->float_sel)
	{
	    create_float_sel(create_info);
	    create_info->float_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'double_sel'
	 */
	else if (create_info->double_sel)
	{
	    create_double_sel(create_info);
	    create_info->double_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'string_sel'
	 */
	else if (create_info->string_sel)
	{
	    create_string_sel(create_info);
	    create_info->string_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'flag_sel'
	 */
	else if (create_info->flag_sel)
	{
	    create_flag_sel(create_info);
	    create_info->flag_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'logic_sel'
	 */
	else if (create_info->logic_sel)
	{
	    create_logic_sel(create_info);
	    create_info->logic_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'infile_sel'
	 */
	else if (create_info->infile_sel)
	{
	    create_infile_sel(create_info);
	    create_info->infile_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'outfile_sel'
	 */
	else if (create_info->outfile_sel)
	{
	    create_outfile_sel(create_info);
	    create_info->outfile_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'stdin_sel'
	 */
	else if (create_info->stdin_sel)
	{
	    create_stdin_sel(create_info);
	    create_info->stdin_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'stdout_sel'
	 */
	else if (create_info->stdout_sel)
	{
	    create_stdout_sel(create_info);
	    create_info->stdout_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'action_button'
	 */
	else if (create_info->action_button)
	{
	    create_action_button(create_info);
	    create_info->action_button = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'routine_button'
	 */
	else if (create_info->routine_button)
	{
	    create_routine_button(create_info);
	    create_info->routine_button = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'help_button'
	 */
	else if (create_info->help_button)
	{
	    create_help_button(create_info);
	    create_info->help_button = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'quit_button'
	 */
	else if (create_info->quit_button)
	{
	    create_quit_button(create_info);
	    create_info->quit_button = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'guide_button'
	 */
	else if (create_info->guide_button)
	{
	    create_guide_button(create_info);
	    create_info->guide_button = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'cycle_sel'
	 */
	else if (create_info->cycle_sel)
	{
	    create_cycle_sel(create_info);
	    create_info->cycle_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'list_sel'
	 */
	else if (create_info->list_sel)
	{
	    create_list_sel(create_info);
	    create_info->list_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'displaylist_sel'
	 */
	else if (create_info->displaylist_sel)
	{
	    create_displaylist_sel(create_info);
	    create_info->displaylist_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'strlist_sel'
	 */
	else if (create_info->strlist_sel)
	{
	    create_strlist_sel(create_info);
	    create_info->strlist_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'flag_toggle'
	 */
	else if (create_info->flag_toggle)
	{
	    create_flag_toggle(create_info);
	    create_info->flag_toggle = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'logical_toggle'
	 */
	else if (create_info->logical_toggle)
	{
	    create_logical_toggle(create_info);
	    create_info->logical_toggle = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'int_toggle'
	 */
	else if (create_info->int_toggle)
	{
	    create_int_toggle(create_info);
	    create_info->int_toggle = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'flt_toggle'
	 */
	else if (create_info->flt_toggle)
	{
	    create_flt_toggle(create_info);
	    create_info->flt_toggle = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'dbl_toggle'
	 */
	else if (create_info->dbl_toggle)
	{
	    create_dbl_toggle(create_info);
	    create_info->dbl_toggle = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'str_toggle'
	 */
	else if (create_info->str_toggle)
	{
	    create_str_toggle(create_info);
	    create_info->str_toggle = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'infile_toggle'
	 */
	else if (create_info->infile_toggle)
	{
	    create_infile_toggle(create_info);
	    create_info->infile_toggle = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'outfile_toggle'
	 */
	else if (create_info->outfile_toggle)
	{
	    create_outfile_toggle(create_info);
	    create_info->outfile_toggle = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'wksp_sel'
	 */
	else if (create_info->wksp_sel)
	{
	    create_wksp_sel(create_info);
	    create_info->wksp_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'blank_sel'
	 */
	else if (create_info->blank_sel)
	{
	    create_blank_sel(create_info);
	    create_info->blank_sel = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'subform_button'
	 */
	else if (create_info->subform_button)
	{
	    create_subform_button(create_info);
	    create_info->subform_button = FALSE;
	}


}


