 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane create
   >>>> 
   >>>>  Private: 
   >>>> 	create_flag_toggle
   >>>> 	create_logical_toggle
   >>>> 	create_int_toggle
   >>>> 	create_flt_toggle
   >>>> 	create_string_toggle
   >>>> 	create_infile_toggle
   >>>> 	create_outfile_toggle
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "guise.h"

static int create_toggle_selection PROTO((int, int, kform_struct *));

/*-----------------------------------------------------------
| 
|  Routine Name: create_flag_toggle
| 
|       Purpose: Do routine which is called when
|                  pane action button flag_toggle is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Apr 06, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_flag_toggle(
     options_create *create_info)
{
	if (create_toggle_selection(KUIS_FLAG, 
				    create_info->control_dest_val,
				    create_info->save_struct))
	    set_save_needed(create_info->save_struct, NULL, NULL, 
		            create_info->save_struct);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_logical_toggle
| 
|       Purpose: Do routine which is called when
|                  pane action button logical_toggle is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Apr 06, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_logical_toggle(
     options_create *create_info)
{
	if (create_toggle_selection(KUIS_LOGICAL, 
				    create_info->control_dest_val,
				    create_info->save_struct))
	    set_save_needed(create_info->save_struct, NULL, NULL, 
		            create_info->save_struct);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_infile_toggle
| 
|       Purpose: Do routine which is called when
|                  pane action button infile_toggle is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Apr 06, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_infile_toggle(
     options_create *create_info)
{
	if (create_toggle_selection(KUIS_INPUTFILE, 
				    create_info->control_dest_val,
				    create_info->save_struct))
	    set_save_needed(create_info->save_struct, NULL, NULL, 
		            create_info->save_struct);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_outfile_toggle
| 
|       Purpose: Do routine which is called when
|                  pane action button outfile_toggle is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Apr 06, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_outfile_toggle(
     options_create *create_info)
{
	if (create_toggle_selection(KUIS_OUTPUTFILE, 
				    create_info->control_dest_val,
				    create_info->save_struct))
	    set_save_needed(create_info->save_struct, NULL, NULL, 
		            create_info->save_struct);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_int_toggle
| 
|       Purpose: Do routine which is called when
|                  pane action button int_toggle is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Apr 06, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_int_toggle(
     options_create *create_info)
{
	if (create_toggle_selection(KUIS_INTEGER, 
				    create_info->control_dest_val,
				    create_info->save_struct))
	    set_save_needed(create_info->save_struct, NULL, NULL, 
		            create_info->save_struct);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_flt_toggle
| 
|       Purpose: Do routine which is called when
|                  pane action button flt_toggle is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Apr 06, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_flt_toggle(
     options_create *create_info)
{
	if (create_toggle_selection(KUIS_FLOAT, 
				    create_info->control_dest_val,
				    create_info->save_struct))
	    set_save_needed(create_info->save_struct, NULL, NULL, 
		            create_info->save_struct);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_dbl_toggle
| 
|       Purpose: Do routine which is called when
|                  pane action button dbl_toggle is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
| 
|        Output: None
|    Written By: Danielle
|          Date: May 04, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_dbl_toggle(
     options_create *create_info)
{
	if (create_toggle_selection(KUIS_DOUBLE, 
				    create_info->control_dest_val,
				    create_info->save_struct))
	    set_save_needed(create_info->save_struct, NULL, NULL, 
		            create_info->save_struct);
}


/*-----------------------------------------------------------
| 
|  Routine Name: create_str_toggle
| 
|       Purpose: Do routine which is called when
|                  pane action button str_toggle is used
| 
|         Input: create_info - ptr to PaneInfo struct for create pane
|        Output: None
|
|    Written By: Danielle Argiro
|          Date: Apr 06, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void create_str_toggle(
     options_create *create_info)
{
	if (create_toggle_selection(KUIS_STRING, 
				    create_info->control_dest_val,
				    create_info->save_struct))
	    set_save_needed(create_info->save_struct, NULL, NULL, 
		            create_info->save_struct);
}



/*-----------------------------------------------------------
| 
|  Routine Name: create_toggle_selection
| 
|       Purpose: Creates a new toggle selection on the displayed form.
|
|         Input: type - type of toggle to be created
|        Output: None
|       Returns: 
|
|    Written By: Danielle Argiro
|          Date: Apr 06, 1993
| Modifications: 
| 
------------------------------------------------------------*/
static int create_toggle_selection(
    int          type,
    int          control_type,
    kform_struct *save_struct)
{
	int        i, member_number, response;
	char       *line = NULL;
        char       temp[KLENGTH];
	char       **prompts, **answers = NULL;
        kselection *selection, *toggle; 
        static int toggle_num = 1;
        Line_Info  line_info;
        kcontrol   *display_control;
        ksubform   *display_subform;
        kguide     *display_guide;
	kcontrol   *display_pane;
	

	/*
         *  set default values for action button
         */
        display_control = find_displayed_control("create_toggle_selection",
                              "toggle", control_type, &display_subform, 
			      &display_guide, &display_pane);
        if (display_control == NULL) return(FALSE);

	/*
	 * prompt for the number of toggle members
	 */
	prompts = (char **) kcalloc(1, sizeof(char *));
	answers = (char **) kcalloc(1, sizeof(char *));
	prompts[0] = kstring_copy("# members", NULL); 
	answers[0] = kstring_copy("3", NULL);
	response = xvu_query_wait("Number of members in toggle",
		                  prompts, "ok", answers, 1, 25);
	kfree(prompts[0]);
	kfree(prompts);

	if (!(response)) 
	{
	    kfree(answers[0]);
	    kfree(answers);
	    return(FALSE);
	}

	member_number = atoi(answers[0]);
	kfree(answers[0]);
	kfree(answers);

	/*
 	 * construct the -T UIS line
	 */
        kvf_clear_line_info(&line_info);
        line_info.typeflag    = KUIS_TOGGLE;
        line_info.activate    = TRUE;
        line_info.selected    = FALSE;
        line_info.optional    = FALSE;
        line_info.opt_sel     = TRUE;
        line_info.live        = FALSE;
        line_info.width       = 15.0;
        line_info.height      = (float) (member_number + 1);
        line_info.x           = 1.0;
	line_info.y           = xvf_calculate_y_position(display_control);
        line_info.xpos        = 0.0;
	line_info.ypos        = 0.0;
	line_info.toggle_def  = 1;
	line_info.toggle_val  = 1;
        ksprintf(temp, "toggle%d", toggle_num++);
        line_info.variable    = kstring_copy(temp, NULL);
	ksprintf(temp, "%s Toggle", kvf_ascii_typeflag(type));
        line_info.title       = kstring_copy(temp, NULL);
	ksprintf(temp, "%s toggle selection", kvf_ascii_typeflag(type));
        line_info.description = kstring_copy(temp, NULL);

        kvf_gen_deparse(&line_info, &line);

        /*
         * create new toggle selection in form tree
         */
	selection = kvf_create_new_selection(display_control, line);
	if (selection == NULL) 
	    return(FALSE);

	/*
	 *  now, create 3 toggle members
	 */
	for (i = 1; i < member_number+1; i++)
	    if (!(kvf_begin_toggle_member(selection, type, i)))
		return(FALSE);

        /*
         * create the new toggle selection on the GUI
         */
        xvf_create_selection(selection, display_control->back, control_type);

	xvf_set_attribute(selection->back_kformstruct, 
		          XVF_TOGGLE_SIZE, member_number);

	if (type == KUIS_INTEGER)
	{
	    toggle = selection->toggle_next;
	    while (toggle != NULL)
	    {
	        xvf_set_attribute(toggle->back_kformstruct, 
			          XVF_INT_GT0_SEL, TRUE);
		toggle = toggle->next;
	    }
	}
	else if (type == KUIS_FLOAT)
	{
	    toggle = selection->toggle_next;
	    while (toggle != NULL)
	    {
	        xvf_set_attribute(toggle->back_kformstruct, 
			          XVF_FLOAT_GT0_SEL, TRUE);
		toggle = toggle->next;
	    }
	}
	else if (type == KUIS_DOUBLE)
	{
	    toggle = selection->toggle_next;
	    while (toggle != NULL)
	    {
	        xvf_set_attribute(toggle->back_kformstruct, 
			          XVF_DOUBLE_GT0_SEL, TRUE);
		toggle = toggle->next;
	    }
	}

	/*
   	 * highlight optional box of default toggle choice
	 */
	xvf_highlight_toggle(selection);

        kfree(line);

        set_save_needed(save_struct, NULL, NULL, save_struct);
        xvf_add_gui_callback(selection->back_kformstruct, "xvf_all_attributes",
                             set_save_needed, (kaddr) save_struct);
	toggle = selection->toggle_next;
	while (toggle != NULL)
 	{
	    xvf_add_gui_callback(toggle->back_kformstruct, "xvf_all_attributes",
                             set_save_needed, (kaddr) save_struct);
	    toggle = toggle->next;

	}
        xvw_set_attribute(display_control->back, XVW_SELECT_REPLACE,
                          selection->back);

	return(TRUE);
}
