/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/* 
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Image Display Utility Routines
   >>>>
   >>>>  Private:
   >>>>
   >>>>   Static:
   >>>>
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "craftsman.h"


/*-----------------------------------------------------------
| Routine Name:	select_toolbox() - set `current' toolbox
|
| Purpose:	This routine is called to set or unset the current
|		toolbox.  This activates and de-activates appropriate
|		parts of the user interface.
|
| Input:	toolbox	- kobject for the selected toolbox
|
| Written By:	Neil Bowers
| Date:		19-sep-93
------------------------------------------------------------*/
void
select_toolbox(
   kobject toolbox)
{
   kobject   info_file      = NULL;
   kobject   config_file    = NULL;
   kobject   include_file   = NULL;
   kobject   alias_file     = NULL;
   kobject   todo_file      = NULL;
   kobject   changelog_file = NULL;
   int       active         = (toolbox != NULL);
   char      titlestring[KLENGTH];
   kstring   tbname;
   int       i;


   if (cmsToolbox != NULL)
      kcms_close(cmsToolbox);

   cmsToolbox = toolbox;
   select_object(NULL);

   /*-- activate action buttons and suform buttons --*/
   xvf_set_attribute(gui_info->template_struct, XVF_ACTIVATE, active);
   xvf_set_attribute(gui_info->rmtb_struct,     XVF_ACTIVATE, active);
   xvf_set_attribute(gui_info->mkmanual_struct, XVF_ACTIVATE, active);
   xvf_set_attribute(gui_info->tbattrs_struct,  XVF_ACTIVATE, active);
   xvf_set_attribute(gui_info->dereftb_struct,  XVF_ACTIVATE, active);
   xvf_set_attribute(gui_info->klinttb_struct,  XVF_ACTIVATE, active);

   if (toolbox == NULL)
   {
      strToolbox = NULL;
      update_object_list();
      return;
   }

   if (!kcms_get_attributes(toolbox,
			    KCMS_NAME, &tbname,
			    KCMS_TB_CONFIG_FILE,    &config_file,
			    KCMS_TB_INFO_FILE,      &info_file,
			    KCMS_TB_INCLUDE_FILE,   &include_file,
			    KCMS_TB_ALIAS_FILE,     &alias_file,
			    KCMS_TB_STATUS,         &tbstatus,
			    KCMS_TB_TODO_FILE,      &todo_file,
			    KCMS_TB_CHANGELOG_FILE, &changelog_file,
			    KCMS_END))
      return;

   /*-- update buttons on the toolbox Toolbox Attributes->Files pane --*/
   xvf_set_attribute(gui_info->tbattrs->files->tbinfo_struct,
		     XVF_TITLE, (info_file == NULL ? "Create" : "Edit"));
   xvf_set_attribute(gui_info->tbattrs->files->tbinclude_struct,
		     XVF_TITLE, (include_file == NULL ? "Create" : "Edit"));
   xvf_set_attribute(gui_info->tbattrs->files->config_struct,
		     XVF_TITLE, (config_file == NULL ? "Create" : "Edit"));
   xvf_set_attribute(gui_info->tbattrs->files->tbaliases_struct,
		     XVF_TITLE, (alias_file == NULL ? "Create" : "Edit"));
   xvf_set_attribute(gui_info->tbattrs->files->tbtodo_struct,
		     XVF_TITLE, (todo_file == NULL ? "Create" : "Edit"));
   xvf_set_attribute(gui_info->tbattrs->files->tbchangelog_struct,
		     XVF_TITLE, (changelog_file == NULL ? "Create" : "Edit"));

   if (tbstatus == KCMS_STATUS_SCRATCH || tbstatus == KCMS_STATUS_WORK)
   {
      xvf_unmap_kformstruct(gui_info->obj_attributes->obj_attrs->install_in_cantata_struct);
   }

   update_keywords(cmsToolbox, NULL);

   update_tb_props(toolbox);
   strToolbox = kstrdup(tbname);
   update_object_list();

   /*-- highlight selected toolbox in list ----------------------------*/
   for (i = 0; i < countToolboxes; i++)
      if (!kstrcasecmp(tbname, toolbox_names[i]))
	 xvf_set_attribute(gui_info->tblist_struct, XVF_LIST_VAL, i);

   ksprintf(titlestring, "Creating new object in toolbox %s", strToolbox);
   xvf_set_attribute(gui_info->template->blank2_struct,
                     XVF_TITLE, titlestring);

   xvf_set_attribute(gui_info->obj_attributes->obj_attrs->tb_struct,
		     XVF_TITLE, strToolbox);

   update_categories();
   change_lib_list();
}

/*-----------------------------------------------------------
| Routine Name:	update_tblist() - update widget list of toolboxes
|
| Purpose:	This routine is called to set or unset the current
|		toolbox.  This activates and de-activates appropriate
|		parts of the user interface.
|
| Input:	toolbox	- kobject for the selected toolbox
|
| Written By:	Neil Bowers
| Date:		19-sep-93
------------------------------------------------------------*/
void
update_tblist(void)
{
   char  label[KLENGTH];
   int   i;


   toolbox_names = kcms_query_toolboxes(&countToolboxes);
   for (i = 0; i < countToolboxes; i++)
      kstring_lower(toolbox_names[i], toolbox_names[i]);
   toolbox_names = karray_sort(toolbox_names, countToolboxes, FALSE);
   xvf_set_attributes(gui_info->tblist_struct,
		      XVF_LIST_SIZE,     countToolboxes,
		      XVF_LIST_CONTENTS, toolbox_names,
		      NULL);

   /*-- update the pulldown for destination tb on copy object ---------*/
   xvf_set_attributes(gui_info->copyobject->copy->desttb_struct,
		      XVF_LIST_SIZE,     countToolboxes,
		      XVF_LIST_CONTENTS, toolbox_names,
		      NULL);

   /*-- update the pulldown for destination tb on move object ---------*/
   xvf_set_attributes(gui_info->mvobject->move->desttb_struct,
		      XVF_LIST_SIZE,     countToolboxes,
		      XVF_LIST_CONTENTS, toolbox_names,
		      NULL);

   ksprintf(label, "Toolboxes (%d)", countToolboxes);
   xvf_set_attribute(gui_info->tblist_struct, XVF_TITLE, label);
}

/*-----------------------------------------------------------
| Routine Name:	delete_toolbox - delete (destroy) the current toolbox
|
| Purpose:	This function is used to remove the currently selected
|		toolbox.  The user is first prompt to ensure that (s)he
|		really does want to remove the toolbox.
|
| Written By:	Neil Bowers
| Date:		10-oct-93
------------------------------------------------------------*/
void
delete_toolbox(void)
{
   if (cmsToolbox == NULL)
   {
      kerror(NULL, "delete_toolbox()",
	     "You have not selected a toolbox to delete!");
      return;
   }

   if (!kprompt(KFORCE, "Yes", "No", FALSE,
		"Operation: destroy toolbox\n\n"
		"\tToolbox: %s\n\n"
		"Do you want to continue with removal of toolbox?",
		strToolbox))
      return;

   /*-- supress prompting by KCMS ------------------------------------*/
   kcms_set_bit(cmsToolbox, KCMS_TB_FLAGS, KCMS_BIT_TB_FORCE);

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);
   xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			"Deleting toolbox `%s'", strToolbox);

   if (kcms_destroy(cmsToolbox))
   {
      update_tblist();
      cmsToolbox = NULL;
      select_toolbox(NULL);
   }

   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
}
