 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_craftsman
   >>>> 	_xvf_free_craftsman
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_craftsman_warning
   >>>> 	_xvf_init_craftsman_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

static void _xvf_init_craftsman_warning PROTO((char *));
static void _xvf_init_craftsman_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_craftsman
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_craftsman_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 19, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_craftsman(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *master;
	kcontrol   *guidepane;

	master = form->master;
	/*
	 * initializing 'craftsman' Form Info structure
	 */

	forminfo->options_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.options");
	if (forminfo->options_struct == NULL)
	    _xvf_init_craftsman_warning("unknown selection 'options' on master form");

	forminfo->license_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.license");
	if (forminfo->license_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'license' on master form");

	forminfo->help_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.help");
	if (forminfo->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on master form");

	forminfo->quit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.quit");
	if (forminfo->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on master form");
	forminfo->quit = FALSE;

	forminfo->tblist_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.tblist");
	if (forminfo->tblist_struct != NULL)
	{
	    selection = forminfo->tblist_struct->Selptr;
	    kvf_get_attribute(forminfo->tblist_struct, KVF_LIST_VAL,
	                    &(forminfo->tblist));
	    kvf_get_attribute(forminfo->tblist_struct, KVF_LIST_LABEL,
	                    &(forminfo->tblist_label));
	}
	else
	    _xvf_init_craftsman_warning("displaylist selection 'tblist' on master form");

	forminfo->tblist_selected = FALSE;

	forminfo->objlist_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.objlist");
	if (forminfo->objlist_struct != NULL)
	{
	    selection = forminfo->objlist_struct->Selptr;
	    kvf_get_attribute(forminfo->objlist_struct, KVF_LIST_VAL,
	                    &(forminfo->objlist));
	    kvf_get_attribute(forminfo->objlist_struct, KVF_LIST_LABEL,
	                    &(forminfo->objlist_label));
	}
	else
	    _xvf_init_craftsman_warning("displaylist selection 'objlist' on master form");

	forminfo->objlist_selected = FALSE;

	forminfo->objlist_dblclick = FALSE;

	forminfo->tbops_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.tbops");
	if (forminfo->tbops_struct == NULL)
	    _xvf_init_craftsman_warning("unknown selection 'tbops' on master form");

	forminfo->mkmanual_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.mkmanual");
	if (forminfo->mkmanual_struct == NULL)
	    _xvf_init_craftsman_warning("master action button 'mkmanual' on master form");
	forminfo->mkmanual = FALSE;
	selection = forminfo->mkmanual_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->dereftb_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.dereftb");
	if (forminfo->dereftb_struct == NULL)
	    _xvf_init_craftsman_warning("master action button 'dereftb' on master form");
	forminfo->dereftb = FALSE;
	selection = forminfo->dereftb_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->klinttb_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.klinttb");
	if (forminfo->klinttb_struct == NULL)
	    _xvf_init_craftsman_warning("master action button 'klinttb' on master form");
	forminfo->klinttb = FALSE;
	selection = forminfo->klinttb_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->rmtb_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.rmtb");
	if (forminfo->rmtb_struct == NULL)
	    _xvf_init_craftsman_warning("master action button 'rmtb' on master form");
	forminfo->rmtb = FALSE;
	selection = forminfo->rmtb_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->objops_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.objops");
	if (forminfo->objops_struct == NULL)
	    _xvf_init_craftsman_warning("unknown selection 'objops' on master form");

	forminfo->open_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.open");
	if (forminfo->open_struct == NULL)
	    _xvf_init_craftsman_warning("master action button 'open' on master form");
	forminfo->open = FALSE;
	selection = forminfo->open_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->klintobj_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.klintobj");
	if (forminfo->klintobj_struct == NULL)
	    _xvf_init_craftsman_warning("master action button 'klintobj' on master form");
	forminfo->klintobj = FALSE;
	selection = forminfo->klintobj_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->delete_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.delete");
	if (forminfo->delete_struct == NULL)
	    _xvf_init_craftsman_warning("master action button 'delete' on master form");
	forminfo->delete = FALSE;
	selection = forminfo->delete_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->pixmap_struct =
	    kvf_create_struct_from_selname(master->sel_list, "craftsman.pixmap");
	if (forminfo->pixmap_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'pixmap' on master form");
	forminfo->preferences_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.preferences");
	if (forminfo->preferences_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'preferences' on form 'craftsman'", 
			    "craftsman_preferences");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->preferences' Subform Info structure
	 */

	forminfo->preferences = (craftsman_preferences *)
				kcalloc(1, sizeof(craftsman_preferences));
	subform = forminfo->preferences_struct->Subformptr;

	/*
	 * initializing 'craftsman->preferences->types' Pane Info structure
	 */

	forminfo->preferences->types = (preferences_types *)
				kcalloc(1, sizeof(preferences_types));
	forminfo->preferences->types_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.preferences.types");
	if (forminfo->preferences->types_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'types' on subform 'preferences'", "preferences_types");
	    return(FALSE);
	}
	pane = forminfo->preferences->types_struct->Controlptr;
	forminfo->preferences->types->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.preferences.types.help");
	if (forminfo->preferences->types->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'types' of subform 'preferences'");

	forminfo->preferences->types->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.preferences.types.quit");
	if (forminfo->preferences->types->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on pane 'types' of subform 'preferences'");
	forminfo->preferences->types->quit = FALSE;

	forminfo->preferences->types->objtypes_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.preferences.types.objtypes");
	if (forminfo->preferences->types->objtypes_struct != NULL)
	{
	    selection = forminfo->preferences->types->objtypes_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->types->objtypes_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->preferences->types->objtypes_num));
	    forminfo->preferences->types->objtypes_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'objtypes' on pane 'types' of subform 'preferences'");

	forminfo->preferences->types->objtypes_selected = FALSE;

	forminfo->preferences->types->cattype_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.preferences.types.cattype");
	if (forminfo->preferences->types->cattype_struct != NULL)
	{
	    selection = forminfo->preferences->types->cattype_struct->Selptr;
	    kvf_get_attribute(forminfo->preferences->types->cattype_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->preferences->types->cattype_num));
	    forminfo->preferences->types->cattype_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'cattype' on pane 'types' of subform 'preferences'");

	forminfo->preferences->types->cattype_selected = FALSE;

	forminfo->console_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.console");
	if (forminfo->console_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'console' on form 'craftsman'", 
			    "craftsman_console");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->console' Subform Info structure
	 */

	forminfo->console = (craftsman_console *)
				kcalloc(1, sizeof(craftsman_console));
	subform = forminfo->console_struct->Subformptr;

	/*
	 * initializing 'craftsman->console->conspane' Pane Info structure
	 */

	forminfo->console->conspane = (console_conspane *)
				kcalloc(1, sizeof(console_conspane));
	forminfo->console->conspane_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.console.conspane");
	if (forminfo->console->conspane_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'conspane' on subform 'console'", "console_conspane");
	    return(FALSE);
	}
	pane = forminfo->console->conspane_struct->Controlptr;
	forminfo->console->conspane->clear_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.console.conspane.clear");
	if (forminfo->console->conspane->clear_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'clear' on pane 'conspane' of subform 'console'");
	forminfo->console->conspane->clear = FALSE;
	selection = forminfo->console->conspane->clear_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->console->conspane->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.console.conspane.help");
	if (forminfo->console->conspane->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'conspane' of subform 'console'");

	forminfo->console->conspane->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.console.conspane.quit");
	if (forminfo->console->conspane->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on pane 'conspane' of subform 'console'");
	forminfo->console->conspane->quit = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_console(forminfo->console);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_conspane(forminfo->console->conspane);
	forminfo->console->conspane->workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.console.conspane.workspace");
	if (forminfo->console->conspane->workspace_struct == NULL)
	    _xvf_init_craftsman_warning("workspace 'workspace' on pane 'conspane' of subform 'console'");
	else
	{
	    kvf_get_attribute(forminfo->console->conspane->workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->console->conspane->workspace));

	}
	forminfo->newtb_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.newtb");
	if (forminfo->newtb_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'newtb' on form 'craftsman'", 
			    "craftsman_newtb");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->newtb' Subform Info structure
	 */

	forminfo->newtb = (craftsman_newtb *)
				kcalloc(1, sizeof(craftsman_newtb));
	subform = forminfo->newtb_struct->Subformptr;

	/*
	 * initializing 'craftsman->newtb->mktb' Pane Info structure
	 */

	forminfo->newtb->mktb = (newtb_mktb *)
				kcalloc(1, sizeof(newtb_mktb));
	forminfo->newtb->mktb_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.newtb.mktb");
	if (forminfo->newtb->mktb_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'mktb' on subform 'newtb'", "newtb_mktb");
	    return(FALSE);
	}
	pane = forminfo->newtb->mktb_struct->Controlptr;
	forminfo->newtb->mktb->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.help");
	if (forminfo->newtb->mktb->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'mktb' of subform 'newtb'");

	forminfo->newtb->mktb->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.quit");
	if (forminfo->newtb->mktb->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on pane 'mktb' of subform 'newtb'");
	forminfo->newtb->mktb->quit = FALSE;

	forminfo->newtb->mktb->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.tbname");
	if (forminfo->newtb->mktb->tbname_struct != NULL)
	{
	    selection = forminfo->newtb->mktb->tbname_struct->Selptr;
	    kvf_get_attribute(forminfo->newtb->mktb->tbname_struct, KVF_STRING_DEF,
	                    &(forminfo->newtb->mktb->tbname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'tbname' on pane 'mktb' of subform 'newtb'");


	forminfo->newtb->mktb->tbpath_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.tbpath");
	if (forminfo->newtb->mktb->tbpath_struct != NULL)
	{
	    selection = forminfo->newtb->mktb->tbpath_struct->Selptr;
	    kvf_get_attribute(forminfo->newtb->mktb->tbpath_struct, KVF_STRING_DEF,
	                    &(forminfo->newtb->mktb->tbpath));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'tbpath' on pane 'mktb' of subform 'newtb'");


	forminfo->newtb->mktb->tbtitle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.tbtitle");
	if (forminfo->newtb->mktb->tbtitle_struct != NULL)
	{
	    selection = forminfo->newtb->mktb->tbtitle_struct->Selptr;
	    kvf_get_attribute(forminfo->newtb->mktb->tbtitle_struct, KVF_STRING_DEF,
	                    &(forminfo->newtb->mktb->tbtitle));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'tbtitle' on pane 'mktb' of subform 'newtb'");


	forminfo->newtb->mktb->name_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.name");
	if (forminfo->newtb->mktb->name_struct != NULL)
	{
	    selection = forminfo->newtb->mktb->name_struct->Selptr;
	    kvf_get_attribute(forminfo->newtb->mktb->name_struct, KVF_STRING_DEF,
	                    &(forminfo->newtb->mktb->name));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'name' on pane 'mktb' of subform 'newtb'");


	forminfo->newtb->mktb->email_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.email");
	if (forminfo->newtb->mktb->email_struct != NULL)
	{
	    selection = forminfo->newtb->mktb->email_struct->Selptr;
	    kvf_get_attribute(forminfo->newtb->mktb->email_struct, KVF_STRING_DEF,
	                    &(forminfo->newtb->mktb->email));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'email' on pane 'mktb' of subform 'newtb'");


	forminfo->newtb->mktb->tbstatus_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.tbstatus");
	if (forminfo->newtb->mktb->tbstatus_struct != NULL)
	{
	    selection = forminfo->newtb->mktb->tbstatus_struct->Selptr;
	    kvf_get_attribute(forminfo->newtb->mktb->tbstatus_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->newtb->mktb->tbstatus_num));
	    forminfo->newtb->mktb->tbstatus_val = 3;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'tbstatus' on pane 'mktb' of subform 'newtb'");


	forminfo->newtb->mktb->createtb_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.createtb");
	if (forminfo->newtb->mktb->createtb_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'createtb' on pane 'mktb' of subform 'newtb'");
	forminfo->newtb->mktb->createtb = FALSE;
	selection = forminfo->newtb->mktb->createtb_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->newtb->mktb->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.blank1");
	if (forminfo->newtb->mktb->blank1_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'blank1' on pane 'mktb' of subform 'newtb'");
	forminfo->newtb->mktb->blank2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.blank2");
	if (forminfo->newtb->mktb->blank2_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'blank2' on pane 'mktb' of subform 'newtb'");
	forminfo->newtb->mktb->tbauthor_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.newtb.mktb.tbauthor");
	if (forminfo->newtb->mktb->tbauthor_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tbauthor' on pane 'mktb' of subform 'newtb'");
	forminfo->tbaddref_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.tbaddref");
	if (forminfo->tbaddref_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'tbaddref' on form 'craftsman'", 
			    "craftsman_tbaddref");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->tbaddref' Subform Info structure
	 */

	forminfo->tbaddref = (craftsman_tbaddref *)
				kcalloc(1, sizeof(craftsman_tbaddref));
	subform = forminfo->tbaddref_struct->Subformptr;

	/*
	 * initializing 'craftsman->tbaddref->addref' Pane Info structure
	 */

	forminfo->tbaddref->addref = (tbaddref_addref *)
				kcalloc(1, sizeof(tbaddref_addref));
	forminfo->tbaddref->addref_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.tbaddref.addref");
	if (forminfo->tbaddref->addref_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'addref' on subform 'tbaddref'", "tbaddref_addref");
	    return(FALSE);
	}
	pane = forminfo->tbaddref->addref_struct->Controlptr;
	forminfo->tbaddref->addref->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbaddref.addref.help");
	if (forminfo->tbaddref->addref->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'addref' of subform 'tbaddref'");

	forminfo->tbaddref->addref->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbaddref.addref.quit");
	if (forminfo->tbaddref->addref->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on pane 'addref' of subform 'tbaddref'");
	forminfo->tbaddref->addref->quit = FALSE;

	forminfo->tbaddref->addref->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbaddref.addref.tbname");
	if (forminfo->tbaddref->addref->tbname_struct != NULL)
	{
	    selection = forminfo->tbaddref->addref->tbname_struct->Selptr;
	    kvf_get_attribute(forminfo->tbaddref->addref->tbname_struct, KVF_STRING_DEF,
	                    &(forminfo->tbaddref->addref->tbname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'tbname' on pane 'addref' of subform 'tbaddref'");


	forminfo->tbaddref->addref->tbpath_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbaddref.addref.tbpath");
	if (forminfo->tbaddref->addref->tbpath_struct != NULL)
	{
	    selection = forminfo->tbaddref->addref->tbpath_struct->Selptr;
	    kvf_get_attribute(forminfo->tbaddref->addref->tbpath_struct, KVF_STRING_DEF,
	                    &(forminfo->tbaddref->addref->tbpath));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'tbpath' on pane 'addref' of subform 'tbaddref'");


	forminfo->tbaddref->addref->addit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbaddref.addref.addit");
	if (forminfo->tbaddref->addref->addit_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'addit' on pane 'addref' of subform 'tbaddref'");
	forminfo->tbaddref->addref->addit = FALSE;
	selection = forminfo->tbaddref->addref->addit_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.tbattrs");
	if (forminfo->tbattrs_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'tbattrs' on form 'craftsman'", 
			    "craftsman_tbattrs");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->tbattrs' Subform Info structure
	 */

	forminfo->tbattrs = (craftsman_tbattrs *)
				kcalloc(1, sizeof(craftsman_tbattrs));
	subform = forminfo->tbattrs_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->tbattrs->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.tbattrs.help");
	if (forminfo->tbattrs->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on subform 'tbattrs'");

	forminfo->tbattrs->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.tbattrs.quit");
	if (forminfo->tbattrs->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on subform 'tbattrs'");
	forminfo->tbattrs->quit = FALSE;


	/*
	 * initializing 'craftsman->tbattrs->strings' Pane Info structure
	 */

	forminfo->tbattrs->strings = (tbattrs_strings *)
				kcalloc(1, sizeof(tbattrs_strings));
	forminfo->tbattrs->strings_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.tbattrs.strings");
	if (forminfo->tbattrs->strings_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'strings' on subform 'tbattrs'", "tbattrs_strings");
	    return(FALSE);
	}
	pane = forminfo->tbattrs->strings_struct->Controlptr;
	forminfo->tbattrs->strings->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.strings.help");
	if (forminfo->tbattrs->strings->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'strings' of subform 'tbattrs'");

	forminfo->tbattrs->strings->tbtitle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.strings.tbtitle");
	if (forminfo->tbattrs->strings->tbtitle_struct != NULL)
	{
	    selection = forminfo->tbattrs->strings->tbtitle_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->strings->tbtitle_struct, KVF_STRING_DEF,
	                    &(forminfo->tbattrs->strings->tbtitle));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'tbtitle' on pane 'strings' of subform 'tbattrs'");


	forminfo->tbattrs->strings->authname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.strings.authname");
	if (forminfo->tbattrs->strings->authname_struct != NULL)
	{
	    selection = forminfo->tbattrs->strings->authname_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->strings->authname_struct, KVF_STRING_DEF,
	                    &(forminfo->tbattrs->strings->authname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'authname' on pane 'strings' of subform 'tbattrs'");


	forminfo->tbattrs->strings->authemail_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.strings.authemail");
	if (forminfo->tbattrs->strings->authemail_struct != NULL)
	{
	    selection = forminfo->tbattrs->strings->authemail_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->strings->authemail_struct, KVF_STRING_DEF,
	                    &(forminfo->tbattrs->strings->authemail));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'authemail' on pane 'strings' of subform 'tbattrs'");


	forminfo->tbattrs->strings->apply_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.strings.apply");
	if (forminfo->tbattrs->strings->apply_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'apply' on pane 'strings' of subform 'tbattrs'");
	forminfo->tbattrs->strings->apply = FALSE;
	selection = forminfo->tbattrs->strings->apply_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->strings->tbauthor_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.strings.tbauthor");
	if (forminfo->tbattrs->strings->tbauthor_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tbauthor' on pane 'strings' of subform 'tbattrs'");
	forminfo->tbattrs->strings->pathlabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.strings.pathlabel");
	if (forminfo->tbattrs->strings->pathlabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'pathlabel' on pane 'strings' of subform 'tbattrs'");
	forminfo->tbattrs->strings->tbpath_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.strings.tbpath");
	if (forminfo->tbattrs->strings->tbpath_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tbpath' on pane 'strings' of subform 'tbattrs'");

	/*
	 * initializing 'craftsman->tbattrs->keywords' Pane Info structure
	 */

	forminfo->tbattrs->keywords = (tbattrs_keywords *)
				kcalloc(1, sizeof(tbattrs_keywords));
	forminfo->tbattrs->keywords_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.tbattrs.keywords");
	if (forminfo->tbattrs->keywords_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'keywords' on subform 'tbattrs'", "tbattrs_keywords");
	    return(FALSE);
	}
	pane = forminfo->tbattrs->keywords_struct->Controlptr;
	forminfo->tbattrs->keywords->keylist_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.keywords.keylist");
	if (forminfo->tbattrs->keywords->keylist_struct != NULL)
	{
	    selection = forminfo->tbattrs->keywords->keylist_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->keywords->keylist_struct, KVF_LIST_VAL,
	                    &(forminfo->tbattrs->keywords->keylist));
	    kvf_get_attribute(forminfo->tbattrs->keywords->keylist_struct, KVF_LIST_LABEL,
	                    &(forminfo->tbattrs->keywords->keylist_label));
	}
	else
	    _xvf_init_craftsman_warning("displaylist selection 'keylist' on pane 'keywords' of subform 'tbattrs'");

	forminfo->tbattrs->keywords->keylist_selected = FALSE;

	forminfo->tbattrs->keywords->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.keywords.help");
	if (forminfo->tbattrs->keywords->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'keywords' of subform 'tbattrs'");

	forminfo->tbattrs->keywords->delete_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.keywords.delete");
	if (forminfo->tbattrs->keywords->delete_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'delete' on pane 'keywords' of subform 'tbattrs'");
	forminfo->tbattrs->keywords->delete = FALSE;
	selection = forminfo->tbattrs->keywords->delete_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->keywords->addkey_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.keywords.addkey");
	if (forminfo->tbattrs->keywords->addkey_struct != NULL)
	{
	    selection = forminfo->tbattrs->keywords->addkey_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->keywords->addkey_struct, KVF_STRING_DEF,
	                    &(forminfo->tbattrs->keywords->addkey));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'addkey' on pane 'keywords' of subform 'tbattrs'");

	forminfo->tbattrs->keywords->addkey_selected = FALSE;

	forminfo->tbattrs->keywords->chkey_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.keywords.chkey");
	if (forminfo->tbattrs->keywords->chkey_struct != NULL)
	{
	    selection = forminfo->tbattrs->keywords->chkey_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->keywords->chkey_struct, KVF_STRING_DEF,
	                    &(forminfo->tbattrs->keywords->chkey));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'chkey' on pane 'keywords' of subform 'tbattrs'");

	forminfo->tbattrs->keywords->chkey_selected = FALSE;


	/*
	 * initializing 'craftsman->tbattrs->flags' Pane Info structure
	 */

	forminfo->tbattrs->flags = (tbattrs_flags *)
				kcalloc(1, sizeof(tbattrs_flags));
	forminfo->tbattrs->flags_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.tbattrs.flags");
	if (forminfo->tbattrs->flags_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'flags' on subform 'tbattrs'", "tbattrs_flags");
	    return(FALSE);
	}
	pane = forminfo->tbattrs->flags_struct->Controlptr;
	forminfo->tbattrs->flags->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.flags.help");
	if (forminfo->tbattrs->flags->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'flags' of subform 'tbattrs'");

	forminfo->tbattrs->flags->tbstatus_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.flags.tbstatus");
	if (forminfo->tbattrs->flags->tbstatus_struct != NULL)
	{
	    selection = forminfo->tbattrs->flags->tbstatus_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->flags->tbstatus_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->tbattrs->flags->tbstatus_num));
	    forminfo->tbattrs->flags->tbstatus_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'tbstatus' on pane 'flags' of subform 'tbattrs'");


	forminfo->tbattrs->flags->flags_apply_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.flags.flags_apply");
	if (forminfo->tbattrs->flags->flags_apply_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'flags_apply' on pane 'flags' of subform 'tbattrs'");
	forminfo->tbattrs->flags->flags_apply = FALSE;
	selection = forminfo->tbattrs->flags->flags_apply_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	/*
	 * initializing 'craftsman->tbattrs->copyright' Pane Info structure
	 */

	forminfo->tbattrs->copyright = (tbattrs_copyright *)
				kcalloc(1, sizeof(tbattrs_copyright));
	forminfo->tbattrs->copyright_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.tbattrs.copyright");
	if (forminfo->tbattrs->copyright_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'copyright' on subform 'tbattrs'", "tbattrs_copyright");
	    return(FALSE);
	}
	pane = forminfo->tbattrs->copyright_struct->Controlptr;
	forminfo->tbattrs->copyright->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.copyright.help");
	if (forminfo->tbattrs->copyright->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'copyright' of subform 'tbattrs'");

	forminfo->tbattrs->copyright->short_copyright_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.copyright.short_copyright");
	if (forminfo->tbattrs->copyright->short_copyright_struct != NULL)
	{
	    selection = forminfo->tbattrs->copyright->short_copyright_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->copyright->short_copyright_struct, KVF_STRING_DEF,
	                    &(forminfo->tbattrs->copyright->short_copyright));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'short_copyright' on pane 'copyright' of subform 'tbattrs'");


	forminfo->tbattrs->copyright->long_copyright_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.copyright.long_copyright");
	if (forminfo->tbattrs->copyright->long_copyright_struct != NULL)
	{
	    selection = forminfo->tbattrs->copyright->long_copyright_struct->Selptr;
	    kvf_get_attribute(forminfo->tbattrs->copyright->long_copyright_struct, KVF_STRING_DEF,
	                    &(forminfo->tbattrs->copyright->long_copyright));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'long_copyright' on pane 'copyright' of subform 'tbattrs'");


	forminfo->tbattrs->copyright->copyright_apply_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.copyright.copyright_apply");
	if (forminfo->tbattrs->copyright->copyright_apply_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'copyright_apply' on pane 'copyright' of subform 'tbattrs'");
	forminfo->tbattrs->copyright->copyright_apply = FALSE;
	selection = forminfo->tbattrs->copyright->copyright_apply_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->copyright->scblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.copyright.scblank");
	if (forminfo->tbattrs->copyright->scblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'scblank' on pane 'copyright' of subform 'tbattrs'");
	forminfo->tbattrs->copyright->lcblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.copyright.lcblank");
	if (forminfo->tbattrs->copyright->lcblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'lcblank' on pane 'copyright' of subform 'tbattrs'");

	/*
	 * initializing 'craftsman->tbattrs->files' Pane Info structure
	 */

	forminfo->tbattrs->files = (tbattrs_files *)
				kcalloc(1, sizeof(tbattrs_files));
	forminfo->tbattrs->files_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.tbattrs.files");
	if (forminfo->tbattrs->files_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'files' on subform 'tbattrs'", "tbattrs_files");
	    return(FALSE);
	}
	pane = forminfo->tbattrs->files_struct->Controlptr;
	forminfo->tbattrs->files->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.help");
	if (forminfo->tbattrs->files->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'files' of subform 'tbattrs'");

	forminfo->tbattrs->files->config_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.config");
	if (forminfo->tbattrs->files->config_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'config' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->config = FALSE;
	selection = forminfo->tbattrs->files->config_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->files->tbinclude_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.tbinclude");
	if (forminfo->tbattrs->files->tbinclude_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'tbinclude' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->tbinclude = FALSE;
	selection = forminfo->tbattrs->files->tbinclude_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->files->tbinfo_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.tbinfo");
	if (forminfo->tbattrs->files->tbinfo_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'tbinfo' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->tbinfo = FALSE;
	selection = forminfo->tbattrs->files->tbinfo_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->files->tbaliases_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.tbaliases");
	if (forminfo->tbattrs->files->tbaliases_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'tbaliases' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->tbaliases = FALSE;
	selection = forminfo->tbattrs->files->tbaliases_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->files->tbtodo_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.tbtodo");
	if (forminfo->tbattrs->files->tbtodo_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'tbtodo' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->tbtodo = FALSE;
	selection = forminfo->tbattrs->files->tbtodo_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->files->tbchangelog_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.tbchangelog");
	if (forminfo->tbattrs->files->tbchangelog_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'tbchangelog' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->tbchangelog = FALSE;
	selection = forminfo->tbattrs->files->tbchangelog_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->tbattrs->files->configblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.configblank");
	if (forminfo->tbattrs->files->configblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'configblank' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->incblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.incblank");
	if (forminfo->tbattrs->files->incblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'incblank' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->infoblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.infoblank");
	if (forminfo->tbattrs->files->infoblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'infoblank' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->aliasblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.aliasblank");
	if (forminfo->tbattrs->files->aliasblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'aliasblank' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->todoblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.todoblank");
	if (forminfo->tbattrs->files->todoblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'todoblank' on pane 'files' of subform 'tbattrs'");
	forminfo->tbattrs->files->changelogblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.tbattrs.files.changelogblank");
	if (forminfo->tbattrs->files->changelogblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'changelogblank' on pane 'files' of subform 'tbattrs'");
	forminfo->template_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.template");
	if (forminfo->template_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'template' on form 'craftsman'", 
			    "craftsman_template");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->template' Subform Info structure
	 */

	forminfo->template = (craftsman_template *)
				kcalloc(1, sizeof(craftsman_template));
	subform = forminfo->template_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->template->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.help");
	if (forminfo->template->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on subform 'template'");

	forminfo->template->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.quit");
	if (forminfo->template->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on subform 'template'");
	forminfo->template->quit = FALSE;

	forminfo->template->obj_name_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.obj_name");
	if (forminfo->template->obj_name_struct != NULL)
	{
	    selection = forminfo->template->obj_name_struct->Selptr;
	    kvf_get_attribute(forminfo->template->obj_name_struct, KVF_STRING_DEF,
	                    &(forminfo->template->obj_name));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'obj_name' on subform 'template'");


	forminfo->template->bname_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.bname");
	if (forminfo->template->bname_struct != NULL)
	{
	    selection = forminfo->template->bname_struct->Selptr;
	    kvf_get_attribute(forminfo->template->bname_struct, KVF_STRING_DEF,
	                    &(forminfo->template->bname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'bname' on subform 'template'");


	forminfo->template->icon_name_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.icon_name");
	if (forminfo->template->icon_name_struct != NULL)
	{
	    selection = forminfo->template->icon_name_struct->Selptr;
	    kvf_get_attribute(forminfo->template->icon_name_struct, KVF_STRING_DEF,
	                    &(forminfo->template->icon_name));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'icon_name' on subform 'template'");


	forminfo->template->author_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.author");
	if (forminfo->template->author_struct != NULL)
	{
	    selection = forminfo->template->author_struct->Selptr;
	    kvf_get_attribute(forminfo->template->author_struct, KVF_STRING_DEF,
	                    &(forminfo->template->author));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'author' on subform 'template'");


	forminfo->template->email_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.email");
	if (forminfo->template->email_struct != NULL)
	{
	    selection = forminfo->template->email_struct->Selptr;
	    kvf_get_attribute(forminfo->template->email_struct, KVF_STRING_DEF,
	                    &(forminfo->template->email));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'email' on subform 'template'");


	forminfo->template->category_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.category");
	if (forminfo->template->category_struct != NULL)
	{
	    selection = forminfo->template->category_struct->Selptr;
	    kvf_get_attribute(forminfo->template->category_struct, KVF_STRING_DEF,
	                    &(forminfo->template->category));
	}
	else
	    _xvf_init_craftsman_warning("string list selection 'category' on subform 'template'");


	forminfo->template->subcategory_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.subcategory");
	if (forminfo->template->subcategory_struct != NULL)
	{
	    selection = forminfo->template->subcategory_struct->Selptr;
	    kvf_get_attribute(forminfo->template->subcategory_struct, KVF_STRING_DEF,
	                    &(forminfo->template->subcategory));
	}
	else
	    _xvf_init_craftsman_warning("string list selection 'subcategory' on subform 'template'");


	forminfo->template->description_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.description");
	if (forminfo->template->description_struct != NULL)
	{
	    selection = forminfo->template->description_struct->Selptr;
	    kvf_get_attribute(forminfo->template->description_struct, KVF_STRING_DEF,
	                    &(forminfo->template->description));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'description' on subform 'template'");


	forminfo->template->blank2_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.blank2");
	if (forminfo->template->blank2_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'blank2' on subform 'template'");
	forminfo->template->descblank_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.template.descblank");
	if (forminfo->template->descblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'descblank' on subform 'template'");

	/*
	 * initializing 'craftsman->template->kroutine' Pane Info structure
	 */

	forminfo->template->kroutine = (template_kroutine *)
				kcalloc(1, sizeof(template_kroutine));
	forminfo->template->kroutine_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.template.kroutine");
	if (forminfo->template->kroutine_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'kroutine' on subform 'template'", "template_kroutine");
	    return(FALSE);
	}
	pane = forminfo->template->kroutine_struct->Controlptr;
	forminfo->template->kroutine->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.kroutine.help");
	if (forminfo->template->kroutine->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'kroutine' of subform 'template'");

	forminfo->template->kroutine->incantata_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.kroutine.incantata");
	if (forminfo->template->kroutine->incantata_struct != NULL)
	{
	    selection = forminfo->template->kroutine->incantata_struct->Selptr;
	    kvf_get_attribute(forminfo->template->kroutine->incantata_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->kroutine->incantata_num));
	    forminfo->template->kroutine->incantata_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'incantata' on pane 'kroutine' of subform 'template'");


	forminfo->template->kroutine->lib_routine_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.kroutine.lib_routine");
	if (forminfo->template->kroutine->lib_routine_struct != NULL)
	{
	    selection = forminfo->template->kroutine->lib_routine_struct->Selptr;
	    kvf_get_attribute(forminfo->template->kroutine->lib_routine_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->kroutine->lib_routine_num));
	    forminfo->template->kroutine->lib_routine_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'lib_routine' on pane 'kroutine' of subform 'template'");

	forminfo->template->kroutine->lib_routine_selected = FALSE;

	forminfo->template->kroutine->lib_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.kroutine.lib_list");
	if (forminfo->template->kroutine->lib_list_struct != NULL)
	{
	    selection = forminfo->template->kroutine->lib_list_struct->Selptr;
	    kvf_get_attribute(forminfo->template->kroutine->lib_list_struct, KVF_STRING_DEF,
	                    &(forminfo->template->kroutine->lib_list));
	}
	else
	    _xvf_init_craftsman_warning("string list selection 'lib_list' on pane 'kroutine' of subform 'template'");

	forminfo->template->kroutine->lib_list_selected = FALSE;

	forminfo->template->kroutine->create_kroutine_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.kroutine.create_kroutine");
	if (forminfo->template->kroutine->create_kroutine_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'create_kroutine' on pane 'kroutine' of subform 'template'");
	forminfo->template->kroutine->create_kroutine = FALSE;
	selection = forminfo->template->kroutine->create_kroutine_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	/*
	 * initializing 'craftsman->template->xvroutine' Pane Info structure
	 */

	forminfo->template->xvroutine = (template_xvroutine *)
				kcalloc(1, sizeof(template_xvroutine));
	forminfo->template->xvroutine_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.template.xvroutine");
	if (forminfo->template->xvroutine_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'xvroutine' on subform 'template'", "template_xvroutine");
	    return(FALSE);
	}
	pane = forminfo->template->xvroutine_struct->Controlptr;
	forminfo->template->xvroutine->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.xvroutine.help");
	if (forminfo->template->xvroutine->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'xvroutine' of subform 'template'");

	forminfo->template->xvroutine->incantata_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.xvroutine.incantata");
	if (forminfo->template->xvroutine->incantata_struct != NULL)
	{
	    selection = forminfo->template->xvroutine->incantata_struct->Selptr;
	    kvf_get_attribute(forminfo->template->xvroutine->incantata_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->xvroutine->incantata_num));
	    forminfo->template->xvroutine->incantata_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'incantata' on pane 'xvroutine' of subform 'template'");


	forminfo->template->xvroutine->useform_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.xvroutine.useform");
	if (forminfo->template->xvroutine->useform_struct != NULL)
	{
	    selection = forminfo->template->xvroutine->useform_struct->Selptr;
	    kvf_get_attribute(forminfo->template->xvroutine->useform_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->xvroutine->useform_num));
	    forminfo->template->xvroutine->useform_val = 2;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'useform' on pane 'xvroutine' of subform 'template'");


	forminfo->template->xvroutine->create_xvroutine_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.xvroutine.create_xvroutine");
	if (forminfo->template->xvroutine->create_xvroutine_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'create_xvroutine' on pane 'xvroutine' of subform 'template'");
	forminfo->template->xvroutine->create_xvroutine = FALSE;
	selection = forminfo->template->xvroutine->create_xvroutine_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	/*
	 * initializing 'craftsman->template->library' Pane Info structure
	 */

	forminfo->template->library = (template_library *)
				kcalloc(1, sizeof(template_library));
	forminfo->template->library_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.template.library");
	if (forminfo->template->library_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'library' on subform 'template'", "template_library");
	    return(FALSE);
	}
	pane = forminfo->template->library_struct->Controlptr;
	forminfo->template->library->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.library.help");
	if (forminfo->template->library->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'library' of subform 'template'");

	forminfo->template->library->create_library_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.library.create_library");
	if (forminfo->template->library->create_library_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'create_library' on pane 'library' of subform 'template'");
	forminfo->template->library->create_library = FALSE;
	selection = forminfo->template->library->create_library_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	/*
	 * initializing 'craftsman->template->script' Pane Info structure
	 */

	forminfo->template->script = (template_script *)
				kcalloc(1, sizeof(template_script));
	forminfo->template->script_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.template.script");
	if (forminfo->template->script_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'script' on subform 'template'", "template_script");
	    return(FALSE);
	}
	pane = forminfo->template->script_struct->Controlptr;
	forminfo->template->script->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.script.help");
	if (forminfo->template->script->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'script' of subform 'template'");

	forminfo->template->script->lang_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.script.lang");
	if (forminfo->template->script->lang_struct != NULL)
	{
	    selection = forminfo->template->script->lang_struct->Selptr;
	    kvf_get_attribute(forminfo->template->script->lang_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->script->lang_num));
	    forminfo->template->script->lang_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'lang' on pane 'script' of subform 'template'");


	forminfo->template->script->wantpane_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.script.wantpane");
	if (forminfo->template->script->wantpane_struct != NULL)
	{
	    selection = forminfo->template->script->wantpane_struct->Selptr;
	    kvf_get_attribute(forminfo->template->script->wantpane_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->script->wantpane_num));
	    forminfo->template->script->wantpane_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'wantpane' on pane 'script' of subform 'template'");


	forminfo->template->script->incantata_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.script.incantata");
	if (forminfo->template->script->incantata_struct != NULL)
	{
	    selection = forminfo->template->script->incantata_struct->Selptr;
	    kvf_get_attribute(forminfo->template->script->incantata_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->script->incantata_num));
	    forminfo->template->script->incantata_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'incantata' on pane 'script' of subform 'template'");


	forminfo->template->script->create_script_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.script.create_script");
	if (forminfo->template->script->create_script_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'create_script' on pane 'script' of subform 'template'");
	forminfo->template->script->create_script = FALSE;
	selection = forminfo->template->script->create_script_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	/*
	 * initializing 'craftsman->template->pane' Pane Info structure
	 */

	forminfo->template->pane = (template_pane *)
				kcalloc(1, sizeof(template_pane));
	forminfo->template->pane_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.template.pane");
	if (forminfo->template->pane_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'pane' on subform 'template'", "template_pane");
	    return(FALSE);
	}
	pane = forminfo->template->pane_struct->Controlptr;
	forminfo->template->pane->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.pane.help");
	if (forminfo->template->pane->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'pane' of subform 'template'");

	forminfo->template->pane->incantata_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.pane.incantata");
	if (forminfo->template->pane->incantata_struct != NULL)
	{
	    selection = forminfo->template->pane->incantata_struct->Selptr;
	    kvf_get_attribute(forminfo->template->pane->incantata_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->pane->incantata_num));
	    forminfo->template->pane->incantata_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'incantata' on pane 'pane' of subform 'template'");


	forminfo->template->pane->genexec_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.pane.genexec");
	if (forminfo->template->pane->genexec_struct != NULL)
	{
	    selection = forminfo->template->pane->genexec_struct->Selptr;
	    kvf_get_attribute(forminfo->template->pane->genexec_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->template->pane->genexec_num));
	    forminfo->template->pane->genexec_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'genexec' on pane 'pane' of subform 'template'");


	forminfo->template->pane->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.pane.tbname");
	if (forminfo->template->pane->tbname_struct != NULL)
	{
	    selection = forminfo->template->pane->tbname_struct->Selptr;
	    kvf_get_attribute(forminfo->template->pane->tbname_struct, KVF_STRING_DEF,
	                    &(forminfo->template->pane->tbname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'tbname' on pane 'pane' of subform 'template'");


	forminfo->template->pane->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.pane.oname");
	if (forminfo->template->pane->oname_struct != NULL)
	{
	    selection = forminfo->template->pane->oname_struct->Selptr;
	    kvf_get_attribute(forminfo->template->pane->oname_struct, KVF_STRING_DEF,
	                    &(forminfo->template->pane->oname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'oname' on pane 'pane' of subform 'template'");


	forminfo->template->pane->args_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.pane.args");
	if (forminfo->template->pane->args_struct != NULL)
	{
	    selection = forminfo->template->pane->args_struct->Selptr;
	    kvf_get_attribute(forminfo->template->pane->args_struct, KVF_STRING_DEF,
	                    &(forminfo->template->pane->args));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'args' on pane 'pane' of subform 'template'");


	forminfo->template->pane->create_pane_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.pane.create_pane");
	if (forminfo->template->pane->create_pane_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'create_pane' on pane 'pane' of subform 'template'");
	forminfo->template->pane->create_pane = FALSE;
	selection = forminfo->template->pane->create_pane_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->template->pane->assoclabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.template.pane.assoclabel");
	if (forminfo->template->pane->assoclabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'assoclabel' on pane 'pane' of subform 'template'");
	forminfo->obj_attributes_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.obj_attributes");
	if (forminfo->obj_attributes_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'obj_attributes' on form 'craftsman'", 
			    "craftsman_obj_attributes");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->obj_attributes' Subform Info structure
	 */

	forminfo->obj_attributes = (craftsman_obj_attributes *)
				kcalloc(1, sizeof(craftsman_obj_attributes));
	subform = forminfo->obj_attributes_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->obj_attributes->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.obj_attributes.help");
	if (forminfo->obj_attributes->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on subform 'obj_attributes'");

	forminfo->obj_attributes->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "craftsman.obj_attributes.quit");
	if (forminfo->obj_attributes->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on subform 'obj_attributes'");
	forminfo->obj_attributes->quit = FALSE;


	/*
	 * initializing 'craftsman->obj_attributes->obj_attrs' Pane Info structure
	 */

	forminfo->obj_attributes->obj_attrs = (obj_attributes_obj_attrs *)
				kcalloc(1, sizeof(obj_attributes_obj_attrs));
	forminfo->obj_attributes->obj_attrs_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.obj_attributes.obj_attrs");
	if (forminfo->obj_attributes->obj_attrs_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'obj_attrs' on subform 'obj_attributes'", "obj_attributes_obj_attrs");
	    return(FALSE);
	}
	pane = forminfo->obj_attributes->obj_attrs_struct->Controlptr;
	forminfo->obj_attributes->obj_attrs->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.help");
	if (forminfo->obj_attributes->obj_attrs->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'obj_attrs' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_attrs->description_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.description");
	if (forminfo->obj_attributes->obj_attrs->description_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->description_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->description_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->description));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'description' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->category_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.category");
	if (forminfo->obj_attributes->obj_attrs->category_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->category_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->category_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->category));
	}
	else
	    _xvf_init_craftsman_warning("string list selection 'category' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->subcategory_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.subcategory");
	if (forminfo->obj_attributes->obj_attrs->subcategory_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->subcategory_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->subcategory_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->subcategory));
	}
	else
	    _xvf_init_craftsman_warning("string list selection 'subcategory' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->icon_name_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.icon_name");
	if (forminfo->obj_attributes->obj_attrs->icon_name_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->icon_name_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->icon_name_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->icon_name));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'icon_name' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->name_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.name");
	if (forminfo->obj_attributes->obj_attrs->name_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->name_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->name_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->name));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'name' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->email_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.email");
	if (forminfo->obj_attributes->obj_attrs->email_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->email_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->email_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->email));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'email' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->install_in_cantata_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.install_in_cantata");
	if (forminfo->obj_attributes->obj_attrs->install_in_cantata_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->install_in_cantata_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->install_in_cantata_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->obj_attributes->obj_attrs->install_in_cantata_num));
	    forminfo->obj_attributes->obj_attrs->install_in_cantata_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'install_in_cantata' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->apply_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.apply");
	if (forminfo->obj_attributes->obj_attrs->apply_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'apply' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->apply = FALSE;
	selection = forminfo->obj_attributes->obj_attrs->apply_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->obj_attributes->obj_attrs->tblabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.tblabel");
	if (forminfo->obj_attributes->obj_attrs->tblabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tblabel' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->onamelabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.onamelabel");
	if (forminfo->obj_attributes->obj_attrs->onamelabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'onamelabel' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->tb_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.tb");
	if (forminfo->obj_attributes->obj_attrs->tb_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tb' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.oname");
	if (forminfo->obj_attributes->obj_attrs->oname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'oname' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->authlabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.authlabel");
	if (forminfo->obj_attributes->obj_attrs->authlabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'authlabel' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->otypelabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.otypelabel");
	if (forminfo->obj_attributes->obj_attrs->otypelabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'otypelabel' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->otype_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.otype");
	if (forminfo->obj_attributes->obj_attrs->otype_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'otype' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->descblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_attrs.descblank");
	if (forminfo->obj_attributes->obj_attrs->descblank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'descblank' on pane 'obj_attrs' of subform 'obj_attributes'");

	/*
	 * initializing 'craftsman->obj_attributes->obj_keywords' Pane Info structure
	 */

	forminfo->obj_attributes->obj_keywords = (obj_attributes_obj_keywords *)
				kcalloc(1, sizeof(obj_attributes_obj_keywords));
	forminfo->obj_attributes->obj_keywords_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.obj_attributes.obj_keywords");
	if (forminfo->obj_attributes->obj_keywords_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'obj_keywords' on subform 'obj_attributes'", "obj_attributes_obj_keywords");
	    return(FALSE);
	}
	pane = forminfo->obj_attributes->obj_keywords_struct->Controlptr;
	forminfo->obj_attributes->obj_keywords->keylist_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_keywords.keylist");
	if (forminfo->obj_attributes->obj_keywords->keylist_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_keywords->keylist_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_keywords->keylist_struct, KVF_LIST_VAL,
	                    &(forminfo->obj_attributes->obj_keywords->keylist));
	    kvf_get_attribute(forminfo->obj_attributes->obj_keywords->keylist_struct, KVF_LIST_LABEL,
	                    &(forminfo->obj_attributes->obj_keywords->keylist_label));
	}
	else
	    _xvf_init_craftsman_warning("displaylist selection 'keylist' on pane 'obj_keywords' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_keywords->keylist_selected = FALSE;

	forminfo->obj_attributes->obj_keywords->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_keywords.help");
	if (forminfo->obj_attributes->obj_keywords->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'obj_keywords' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_keywords->delete_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_keywords.delete");
	if (forminfo->obj_attributes->obj_keywords->delete_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'delete' on pane 'obj_keywords' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_keywords->delete = FALSE;
	selection = forminfo->obj_attributes->obj_keywords->delete_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->obj_attributes->obj_keywords->addkey_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_keywords.addkey");
	if (forminfo->obj_attributes->obj_keywords->addkey_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_keywords->addkey_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_keywords->addkey_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_keywords->addkey));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'addkey' on pane 'obj_keywords' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_keywords->addkey_selected = FALSE;

	forminfo->obj_attributes->obj_keywords->chkey_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.obj_keywords.chkey");
	if (forminfo->obj_attributes->obj_keywords->chkey_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_keywords->chkey_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_keywords->chkey_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_keywords->chkey));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'chkey' on pane 'obj_keywords' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_keywords->chkey_selected = FALSE;


	/*
	 * initializing 'craftsman->obj_attributes->paneattrs' Pane Info structure
	 */

	forminfo->obj_attributes->paneattrs = (obj_attributes_paneattrs *)
				kcalloc(1, sizeof(obj_attributes_paneattrs));
	forminfo->obj_attributes->paneattrs_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.obj_attributes.paneattrs");
	if (forminfo->obj_attributes->paneattrs_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'paneattrs' on subform 'obj_attributes'", "obj_attributes_paneattrs");
	    return(FALSE);
	}
	pane = forminfo->obj_attributes->paneattrs_struct->Controlptr;
	forminfo->obj_attributes->paneattrs->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.paneattrs.help");
	if (forminfo->obj_attributes->paneattrs->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'paneattrs' of subform 'obj_attributes'");

	forminfo->obj_attributes->paneattrs->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.paneattrs.tbname");
	if (forminfo->obj_attributes->paneattrs->tbname_struct != NULL)
	{
	    selection = forminfo->obj_attributes->paneattrs->tbname_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->paneattrs->tbname_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->paneattrs->tbname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'tbname' on pane 'paneattrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->paneattrs->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.paneattrs.oname");
	if (forminfo->obj_attributes->paneattrs->oname_struct != NULL)
	{
	    selection = forminfo->obj_attributes->paneattrs->oname_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->paneattrs->oname_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->paneattrs->oname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'oname' on pane 'paneattrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->paneattrs->args_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.paneattrs.args");
	if (forminfo->obj_attributes->paneattrs->args_struct != NULL)
	{
	    selection = forminfo->obj_attributes->paneattrs->args_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->paneattrs->args_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->paneattrs->args));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'args' on pane 'paneattrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->paneattrs->genexec_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.paneattrs.genexec");
	if (forminfo->obj_attributes->paneattrs->genexec_struct != NULL)
	{
	    selection = forminfo->obj_attributes->paneattrs->genexec_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->paneattrs->genexec_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->obj_attributes->paneattrs->genexec_num));
	    forminfo->obj_attributes->paneattrs->genexec_val = 1;
	}
	else
	    _xvf_init_craftsman_warning("toggle selection 'genexec' on pane 'paneattrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->paneattrs->apply_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.paneattrs.apply");
	if (forminfo->obj_attributes->paneattrs->apply_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'apply' on pane 'paneattrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->paneattrs->apply = FALSE;
	selection = forminfo->obj_attributes->paneattrs->apply_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->obj_attributes->paneattrs->assoclabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.obj_attributes.paneattrs.assoclabel");
	if (forminfo->obj_attributes->paneattrs->assoclabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'assoclabel' on pane 'paneattrs' of subform 'obj_attributes'");
	forminfo->copyobject_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.copyobject");
	if (forminfo->copyobject_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'copyobject' on form 'craftsman'", 
			    "craftsman_copyobject");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->copyobject' Subform Info structure
	 */

	forminfo->copyobject = (craftsman_copyobject *)
				kcalloc(1, sizeof(craftsman_copyobject));
	subform = forminfo->copyobject_struct->Subformptr;

	/*
	 * initializing 'craftsman->copyobject->copy' Pane Info structure
	 */

	forminfo->copyobject->copy = (copyobject_copy *)
				kcalloc(1, sizeof(copyobject_copy));
	forminfo->copyobject->copy_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.copyobject.copy");
	if (forminfo->copyobject->copy_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'copy' on subform 'copyobject'", "copyobject_copy");
	    return(FALSE);
	}
	pane = forminfo->copyobject->copy_struct->Controlptr;
	forminfo->copyobject->copy->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.copyobject.copy.help");
	if (forminfo->copyobject->copy->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'copy' of subform 'copyobject'");

	forminfo->copyobject->copy->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.copyobject.copy.quit");
	if (forminfo->copyobject->copy->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on pane 'copy' of subform 'copyobject'");
	forminfo->copyobject->copy->quit = FALSE;

	forminfo->copyobject->copy->desttb_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.copyobject.copy.desttb");
	if (forminfo->copyobject->copy->desttb_struct != NULL)
	{
	    selection = forminfo->copyobject->copy->desttb_struct->Selptr;
	    kvf_get_attribute(forminfo->copyobject->copy->desttb_struct, KVF_STRING_DEF,
	                    &(forminfo->copyobject->copy->desttb));
	}
	else
	    _xvf_init_craftsman_warning("string list selection 'desttb' on pane 'copy' of subform 'copyobject'");


	forminfo->copyobject->copy->docopy_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.copyobject.copy.docopy");
	if (forminfo->copyobject->copy->docopy_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'docopy' on pane 'copy' of subform 'copyobject'");
	forminfo->copyobject->copy->docopy = FALSE;
	selection = forminfo->copyobject->copy->docopy_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->copyobject->copy->tblabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.copyobject.copy.tblabel");
	if (forminfo->copyobject->copy->tblabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tblabel' on pane 'copy' of subform 'copyobject'");
	forminfo->copyobject->copy->olabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.copyobject.copy.olabel");
	if (forminfo->copyobject->copy->olabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'olabel' on pane 'copy' of subform 'copyobject'");
	forminfo->copyobject->copy->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.copyobject.copy.tbname");
	if (forminfo->copyobject->copy->tbname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tbname' on pane 'copy' of subform 'copyobject'");
	forminfo->copyobject->copy->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.copyobject.copy.oname");
	if (forminfo->copyobject->copy->oname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'oname' on pane 'copy' of subform 'copyobject'");
	forminfo->mvobject_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.mvobject");
	if (forminfo->mvobject_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'mvobject' on form 'craftsman'", 
			    "craftsman_mvobject");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->mvobject' Subform Info structure
	 */

	forminfo->mvobject = (craftsman_mvobject *)
				kcalloc(1, sizeof(craftsman_mvobject));
	subform = forminfo->mvobject_struct->Subformptr;

	/*
	 * initializing 'craftsman->mvobject->move' Pane Info structure
	 */

	forminfo->mvobject->move = (mvobject_move *)
				kcalloc(1, sizeof(mvobject_move));
	forminfo->mvobject->move_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.mvobject.move");
	if (forminfo->mvobject->move_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'move' on subform 'mvobject'", "mvobject_move");
	    return(FALSE);
	}
	pane = forminfo->mvobject->move_struct->Controlptr;
	forminfo->mvobject->move->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.mvobject.move.help");
	if (forminfo->mvobject->move->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'move' of subform 'mvobject'");

	forminfo->mvobject->move->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.mvobject.move.quit");
	if (forminfo->mvobject->move->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on pane 'move' of subform 'mvobject'");
	forminfo->mvobject->move->quit = FALSE;

	forminfo->mvobject->move->desttb_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.mvobject.move.desttb");
	if (forminfo->mvobject->move->desttb_struct != NULL)
	{
	    selection = forminfo->mvobject->move->desttb_struct->Selptr;
	    kvf_get_attribute(forminfo->mvobject->move->desttb_struct, KVF_STRING_DEF,
	                    &(forminfo->mvobject->move->desttb));
	}
	else
	    _xvf_init_craftsman_warning("string list selection 'desttb' on pane 'move' of subform 'mvobject'");


	forminfo->mvobject->move->domove_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.mvobject.move.domove");
	if (forminfo->mvobject->move->domove_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'domove' on pane 'move' of subform 'mvobject'");
	forminfo->mvobject->move->domove = FALSE;
	selection = forminfo->mvobject->move->domove_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->mvobject->move->tblabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.mvobject.move.tblabel");
	if (forminfo->mvobject->move->tblabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tblabel' on pane 'move' of subform 'mvobject'");
	forminfo->mvobject->move->olabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.mvobject.move.olabel");
	if (forminfo->mvobject->move->olabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'olabel' on pane 'move' of subform 'mvobject'");
	forminfo->mvobject->move->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.mvobject.move.tbname");
	if (forminfo->mvobject->move->tbname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tbname' on pane 'move' of subform 'mvobject'");
	forminfo->mvobject->move->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.mvobject.move.oname");
	if (forminfo->mvobject->move->oname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'oname' on pane 'move' of subform 'mvobject'");
	forminfo->rename_obj_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.rename_obj");
	if (forminfo->rename_obj_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'rename_obj' on form 'craftsman'", 
			    "craftsman_rename_obj");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->rename_obj' Subform Info structure
	 */

	forminfo->rename_obj = (craftsman_rename_obj *)
				kcalloc(1, sizeof(craftsman_rename_obj));
	subform = forminfo->rename_obj_struct->Subformptr;

	/*
	 * initializing 'craftsman->rename_obj->rename' Pane Info structure
	 */

	forminfo->rename_obj->rename = (rename_obj_rename *)
				kcalloc(1, sizeof(rename_obj_rename));
	forminfo->rename_obj->rename_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.rename_obj.rename");
	if (forminfo->rename_obj->rename_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'rename' on subform 'rename_obj'", "rename_obj_rename");
	    return(FALSE);
	}
	pane = forminfo->rename_obj->rename_struct->Controlptr;
	forminfo->rename_obj->rename->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.rename_obj.rename.help");
	if (forminfo->rename_obj->rename->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'rename' of subform 'rename_obj'");

	forminfo->rename_obj->rename->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.rename_obj.rename.quit");
	if (forminfo->rename_obj->rename->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on pane 'rename' of subform 'rename_obj'");
	forminfo->rename_obj->rename->quit = FALSE;

	forminfo->rename_obj->rename->newname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.rename_obj.rename.newname");
	if (forminfo->rename_obj->rename->newname_struct != NULL)
	{
	    selection = forminfo->rename_obj->rename->newname_struct->Selptr;
	    kvf_get_attribute(forminfo->rename_obj->rename->newname_struct, KVF_STRING_DEF,
	                    &(forminfo->rename_obj->rename->newname));
	}
	else
	    _xvf_init_craftsman_warning("string selection 'newname' on pane 'rename' of subform 'rename_obj'");


	forminfo->rename_obj->rename->dorename_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.rename_obj.rename.dorename");
	if (forminfo->rename_obj->rename->dorename_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'dorename' on pane 'rename' of subform 'rename_obj'");
	forminfo->rename_obj->rename->dorename = FALSE;
	selection = forminfo->rename_obj->rename->dorename_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->rename_obj->rename->tblabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.rename_obj.rename.tblabel");
	if (forminfo->rename_obj->rename->tblabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tblabel' on pane 'rename' of subform 'rename_obj'");
	forminfo->rename_obj->rename->olabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.rename_obj.rename.olabel");
	if (forminfo->rename_obj->rename->olabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'olabel' on pane 'rename' of subform 'rename_obj'");
	forminfo->rename_obj->rename->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.rename_obj.rename.tbname");
	if (forminfo->rename_obj->rename->tbname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tbname' on pane 'rename' of subform 'rename_obj'");
	forminfo->rename_obj->rename->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.rename_obj.rename.oname");
	if (forminfo->rename_obj->rename->oname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'oname' on pane 'rename' of subform 'rename_obj'");
	forminfo->objinfo_struct =
	    kvf_create_struct_from_subformname(form, "craftsman.objinfo");
	if (forminfo->objinfo_struct == NULL)
	{
	    _xvf_init_craftsman_error("subform 'objinfo' on form 'craftsman'", 
			    "craftsman_objinfo");
	    return(FALSE);
	}

	/*
	 * initializing 'craftsman->objinfo' Subform Info structure
	 */

	forminfo->objinfo = (craftsman_objinfo *)
				kcalloc(1, sizeof(craftsman_objinfo));
	subform = forminfo->objinfo_struct->Subformptr;

	/*
	 * initializing 'craftsman->objinfo->infopane' Pane Info structure
	 */

	forminfo->objinfo->infopane = (objinfo_infopane *)
				kcalloc(1, sizeof(objinfo_infopane));
	forminfo->objinfo->infopane_struct =
	    kvf_create_struct_from_panename(subform, "craftsman.objinfo.infopane");
	if (forminfo->objinfo->infopane_struct == NULL)
	{
	    _xvf_init_craftsman_error("pane 'infopane' on subform 'objinfo'", "objinfo_infopane");
	    return(FALSE);
	}
	pane = forminfo->objinfo->infopane_struct->Controlptr;
	forminfo->objinfo->infopane->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.help");
	if (forminfo->objinfo->infopane->help_struct == NULL)
		    _xvf_init_craftsman_warning("unknown selection 'help' on pane 'infopane' of subform 'objinfo'");

	forminfo->objinfo->infopane->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.quit");
	if (forminfo->objinfo->infopane->quit_struct == NULL)
		    _xvf_init_craftsman_warning("quit button 'quit' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->quit = FALSE;

	forminfo->objinfo->infopane->todo_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.todo");
	if (forminfo->objinfo->infopane->todo_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'todo' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->todo = FALSE;
	selection = forminfo->objinfo->infopane->todo_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->objinfo->infopane->crtodo_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.crtodo");
	if (forminfo->objinfo->infopane->crtodo_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'crtodo' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->crtodo = FALSE;
	selection = forminfo->objinfo->infopane->crtodo_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->objinfo->infopane->bugs_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.bugs");
	if (forminfo->objinfo->infopane->bugs_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'bugs' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->bugs = FALSE;
	selection = forminfo->objinfo->infopane->bugs_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->objinfo->infopane->crbugs_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.crbugs");
	if (forminfo->objinfo->infopane->crbugs_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'crbugs' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->crbugs = FALSE;
	selection = forminfo->objinfo->infopane->crbugs_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->objinfo->infopane->done_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.done");
	if (forminfo->objinfo->infopane->done_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'done' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->done = FALSE;
	selection = forminfo->objinfo->infopane->done_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->objinfo->infopane->crdone_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.crdone");
	if (forminfo->objinfo->infopane->crdone_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'crdone' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->crdone = FALSE;
	selection = forminfo->objinfo->infopane->crdone_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->objinfo->infopane->changelog_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.changelog");
	if (forminfo->objinfo->infopane->changelog_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'changelog' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->changelog = FALSE;
	selection = forminfo->objinfo->infopane->changelog_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->objinfo->infopane->crchangelog_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.crchangelog");
	if (forminfo->objinfo->infopane->crchangelog_struct == NULL)
	    _xvf_init_craftsman_warning("pane action button 'crchangelog' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->crchangelog = FALSE;
	selection = forminfo->objinfo->infopane->crchangelog_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->objinfo->infopane->tblabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.tblabel");
	if (forminfo->objinfo->infopane->tblabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tblabel' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->olabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.olabel");
	if (forminfo->objinfo->infopane->olabel_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'olabel' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.tbname");
	if (forminfo->objinfo->infopane->tbname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'tbname' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.oname");
	if (forminfo->objinfo->infopane->oname_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'oname' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->todo_blank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.todo_blank");
	if (forminfo->objinfo->infopane->todo_blank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'todo_blank' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->bugs_blank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.bugs_blank");
	if (forminfo->objinfo->infopane->bugs_blank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'bugs_blank' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->done_blank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.done_blank");
	if (forminfo->objinfo->infopane->done_blank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'done_blank' on pane 'infopane' of subform 'objinfo'");
	forminfo->objinfo->infopane->changelog_blank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "craftsman.objinfo.infopane.changelog_blank");
	if (forminfo->objinfo->infopane->changelog_blank_struct == NULL)
	    _xvf_init_craftsman_warning("blank selection 'changelog_blank' on pane 'infopane' of subform 'objinfo'");
	forminfo->craftsman_struct =
	    kvf_create_struct_from_mastername(form, "craftsman");
	if (forminfo->craftsman_struct == NULL)
	{
	    _xvf_init_craftsman_error("form 'craftsman'",
			    "gui_info");
	    return(FALSE);
	}

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_craftsman_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 19, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_craftsman_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_craftsman_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 19, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_craftsman_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_craftsman
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_craftsman_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 19, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_craftsman(
    gui_info_struct *forminfo)
{
	if (forminfo->options_struct != NULL)
	    kfree(forminfo->options_struct);
	if (forminfo->license_struct != NULL)
	    kfree(forminfo->license_struct);
	if (forminfo->help_struct != NULL)
	    kfree(forminfo->help_struct);
	if (forminfo->quit_struct != NULL)
	    kfree(forminfo->quit_struct);
	if (forminfo->tblist_struct != NULL)
	    kfree(forminfo->tblist_struct);
	kfree(forminfo->tblist_label);
	if (forminfo->objlist_struct != NULL)
	    kfree(forminfo->objlist_struct);
	kfree(forminfo->objlist_label);
	if (forminfo->tbops_struct != NULL)
	    kfree(forminfo->tbops_struct);
	if (forminfo->mkmanual_struct != NULL)
	    kfree(forminfo->mkmanual_struct);
	if (forminfo->dereftb_struct != NULL)
	    kfree(forminfo->dereftb_struct);
	if (forminfo->klinttb_struct != NULL)
	    kfree(forminfo->klinttb_struct);
	if (forminfo->rmtb_struct != NULL)
	    kfree(forminfo->rmtb_struct);
	if (forminfo->objops_struct != NULL)
	    kfree(forminfo->objops_struct);
	if (forminfo->open_struct != NULL)
	    kfree(forminfo->open_struct);
	if (forminfo->klintobj_struct != NULL)
	    kfree(forminfo->klintobj_struct);
	if (forminfo->delete_struct != NULL)
	    kfree(forminfo->delete_struct);
	if (forminfo->pixmap_struct != NULL)
	    kfree(forminfo->pixmap_struct);
	if (forminfo->preferences->types->help_struct != NULL)
	    kfree(forminfo->preferences->types->help_struct);
	if (forminfo->preferences->types->quit_struct != NULL)
	    kfree(forminfo->preferences->types->quit_struct);
	if (forminfo->preferences->types->objtypes_struct != NULL)
	    kfree(forminfo->preferences->types->objtypes_struct);
	if (forminfo->preferences->types->cattype_struct != NULL)
	    kfree(forminfo->preferences->types->cattype_struct);
	kfree(forminfo->preferences->types);
	if (forminfo->preferences->types_struct != NULL)
	    kfree(forminfo->preferences->types_struct);


	if (forminfo->preferences_struct != NULL)
	    kfree(forminfo->preferences_struct);
	kfree(forminfo->preferences);
	if (forminfo->console->conspane->clear_struct != NULL)
	    kfree(forminfo->console->conspane->clear_struct);
	if (forminfo->console->conspane->help_struct != NULL)
	    kfree(forminfo->console->conspane->help_struct);
	if (forminfo->console->conspane->quit_struct != NULL)
	    kfree(forminfo->console->conspane->quit_struct);
	if (forminfo->console->conspane->workspace_struct != NULL)
	    kfree(forminfo->console->conspane->workspace_struct);
	kfree(forminfo->console->conspane);
	if (forminfo->console->conspane_struct != NULL)
	    kfree(forminfo->console->conspane_struct);


	if (forminfo->console_struct != NULL)
	    kfree(forminfo->console_struct);
	kfree(forminfo->console);
	if (forminfo->newtb->mktb->help_struct != NULL)
	    kfree(forminfo->newtb->mktb->help_struct);
	if (forminfo->newtb->mktb->quit_struct != NULL)
	    kfree(forminfo->newtb->mktb->quit_struct);
	kfree(forminfo->newtb->mktb->tbname);
	if (forminfo->newtb->mktb->tbname_struct != NULL)
	    kfree(forminfo->newtb->mktb->tbname_struct);
	kfree(forminfo->newtb->mktb->tbpath);
	if (forminfo->newtb->mktb->tbpath_struct != NULL)
	    kfree(forminfo->newtb->mktb->tbpath_struct);
	kfree(forminfo->newtb->mktb->tbtitle);
	if (forminfo->newtb->mktb->tbtitle_struct != NULL)
	    kfree(forminfo->newtb->mktb->tbtitle_struct);
	kfree(forminfo->newtb->mktb->name);
	if (forminfo->newtb->mktb->name_struct != NULL)
	    kfree(forminfo->newtb->mktb->name_struct);
	kfree(forminfo->newtb->mktb->email);
	if (forminfo->newtb->mktb->email_struct != NULL)
	    kfree(forminfo->newtb->mktb->email_struct);
	if (forminfo->newtb->mktb->tbstatus_struct != NULL)
	    kfree(forminfo->newtb->mktb->tbstatus_struct);
	if (forminfo->newtb->mktb->createtb_struct != NULL)
	    kfree(forminfo->newtb->mktb->createtb_struct);
	if (forminfo->newtb->mktb->blank1_struct != NULL)
	    kfree(forminfo->newtb->mktb->blank1_struct);
	if (forminfo->newtb->mktb->blank2_struct != NULL)
	    kfree(forminfo->newtb->mktb->blank2_struct);
	if (forminfo->newtb->mktb->tbauthor_struct != NULL)
	    kfree(forminfo->newtb->mktb->tbauthor_struct);
	kfree(forminfo->newtb->mktb);
	if (forminfo->newtb->mktb_struct != NULL)
	    kfree(forminfo->newtb->mktb_struct);


	if (forminfo->newtb_struct != NULL)
	    kfree(forminfo->newtb_struct);
	kfree(forminfo->newtb);
	if (forminfo->tbaddref->addref->help_struct != NULL)
	    kfree(forminfo->tbaddref->addref->help_struct);
	if (forminfo->tbaddref->addref->quit_struct != NULL)
	    kfree(forminfo->tbaddref->addref->quit_struct);
	kfree(forminfo->tbaddref->addref->tbname);
	if (forminfo->tbaddref->addref->tbname_struct != NULL)
	    kfree(forminfo->tbaddref->addref->tbname_struct);
	kfree(forminfo->tbaddref->addref->tbpath);
	if (forminfo->tbaddref->addref->tbpath_struct != NULL)
	    kfree(forminfo->tbaddref->addref->tbpath_struct);
	if (forminfo->tbaddref->addref->addit_struct != NULL)
	    kfree(forminfo->tbaddref->addref->addit_struct);
	kfree(forminfo->tbaddref->addref);
	if (forminfo->tbaddref->addref_struct != NULL)
	    kfree(forminfo->tbaddref->addref_struct);


	if (forminfo->tbaddref_struct != NULL)
	    kfree(forminfo->tbaddref_struct);
	kfree(forminfo->tbaddref);
	if (forminfo->tbattrs->help_struct != NULL)
	    kfree(forminfo->tbattrs->help_struct);
	if (forminfo->tbattrs->quit_struct != NULL)
	    kfree(forminfo->tbattrs->quit_struct);
	if (forminfo->tbattrs->strings->help_struct != NULL)
	    kfree(forminfo->tbattrs->strings->help_struct);
	kfree(forminfo->tbattrs->strings->tbtitle);
	if (forminfo->tbattrs->strings->tbtitle_struct != NULL)
	    kfree(forminfo->tbattrs->strings->tbtitle_struct);
	kfree(forminfo->tbattrs->strings->authname);
	if (forminfo->tbattrs->strings->authname_struct != NULL)
	    kfree(forminfo->tbattrs->strings->authname_struct);
	kfree(forminfo->tbattrs->strings->authemail);
	if (forminfo->tbattrs->strings->authemail_struct != NULL)
	    kfree(forminfo->tbattrs->strings->authemail_struct);
	if (forminfo->tbattrs->strings->apply_struct != NULL)
	    kfree(forminfo->tbattrs->strings->apply_struct);
	if (forminfo->tbattrs->strings->tbauthor_struct != NULL)
	    kfree(forminfo->tbattrs->strings->tbauthor_struct);
	if (forminfo->tbattrs->strings->pathlabel_struct != NULL)
	    kfree(forminfo->tbattrs->strings->pathlabel_struct);
	if (forminfo->tbattrs->strings->tbpath_struct != NULL)
	    kfree(forminfo->tbattrs->strings->tbpath_struct);
	kfree(forminfo->tbattrs->strings);
	if (forminfo->tbattrs->strings_struct != NULL)
	    kfree(forminfo->tbattrs->strings_struct);

	if (forminfo->tbattrs->keywords->keylist_struct != NULL)
	    kfree(forminfo->tbattrs->keywords->keylist_struct);
	kfree(forminfo->tbattrs->keywords->keylist_label);
	if (forminfo->tbattrs->keywords->help_struct != NULL)
	    kfree(forminfo->tbattrs->keywords->help_struct);
	if (forminfo->tbattrs->keywords->delete_struct != NULL)
	    kfree(forminfo->tbattrs->keywords->delete_struct);
	kfree(forminfo->tbattrs->keywords->addkey);
	if (forminfo->tbattrs->keywords->addkey_struct != NULL)
	    kfree(forminfo->tbattrs->keywords->addkey_struct);
	kfree(forminfo->tbattrs->keywords->chkey);
	if (forminfo->tbattrs->keywords->chkey_struct != NULL)
	    kfree(forminfo->tbattrs->keywords->chkey_struct);
	kfree(forminfo->tbattrs->keywords);
	if (forminfo->tbattrs->keywords_struct != NULL)
	    kfree(forminfo->tbattrs->keywords_struct);

	if (forminfo->tbattrs->flags->help_struct != NULL)
	    kfree(forminfo->tbattrs->flags->help_struct);
	if (forminfo->tbattrs->flags->tbstatus_struct != NULL)
	    kfree(forminfo->tbattrs->flags->tbstatus_struct);
	if (forminfo->tbattrs->flags->flags_apply_struct != NULL)
	    kfree(forminfo->tbattrs->flags->flags_apply_struct);
	kfree(forminfo->tbattrs->flags);
	if (forminfo->tbattrs->flags_struct != NULL)
	    kfree(forminfo->tbattrs->flags_struct);

	if (forminfo->tbattrs->copyright->help_struct != NULL)
	    kfree(forminfo->tbattrs->copyright->help_struct);
	kfree(forminfo->tbattrs->copyright->short_copyright);
	if (forminfo->tbattrs->copyright->short_copyright_struct != NULL)
	    kfree(forminfo->tbattrs->copyright->short_copyright_struct);
	kfree(forminfo->tbattrs->copyright->long_copyright);
	if (forminfo->tbattrs->copyright->long_copyright_struct != NULL)
	    kfree(forminfo->tbattrs->copyright->long_copyright_struct);
	if (forminfo->tbattrs->copyright->copyright_apply_struct != NULL)
	    kfree(forminfo->tbattrs->copyright->copyright_apply_struct);
	if (forminfo->tbattrs->copyright->scblank_struct != NULL)
	    kfree(forminfo->tbattrs->copyright->scblank_struct);
	if (forminfo->tbattrs->copyright->lcblank_struct != NULL)
	    kfree(forminfo->tbattrs->copyright->lcblank_struct);
	kfree(forminfo->tbattrs->copyright);
	if (forminfo->tbattrs->copyright_struct != NULL)
	    kfree(forminfo->tbattrs->copyright_struct);

	if (forminfo->tbattrs->files->help_struct != NULL)
	    kfree(forminfo->tbattrs->files->help_struct);
	if (forminfo->tbattrs->files->config_struct != NULL)
	    kfree(forminfo->tbattrs->files->config_struct);
	if (forminfo->tbattrs->files->tbinclude_struct != NULL)
	    kfree(forminfo->tbattrs->files->tbinclude_struct);
	if (forminfo->tbattrs->files->tbinfo_struct != NULL)
	    kfree(forminfo->tbattrs->files->tbinfo_struct);
	if (forminfo->tbattrs->files->tbaliases_struct != NULL)
	    kfree(forminfo->tbattrs->files->tbaliases_struct);
	if (forminfo->tbattrs->files->tbtodo_struct != NULL)
	    kfree(forminfo->tbattrs->files->tbtodo_struct);
	if (forminfo->tbattrs->files->tbchangelog_struct != NULL)
	    kfree(forminfo->tbattrs->files->tbchangelog_struct);
	if (forminfo->tbattrs->files->configblank_struct != NULL)
	    kfree(forminfo->tbattrs->files->configblank_struct);
	if (forminfo->tbattrs->files->incblank_struct != NULL)
	    kfree(forminfo->tbattrs->files->incblank_struct);
	if (forminfo->tbattrs->files->infoblank_struct != NULL)
	    kfree(forminfo->tbattrs->files->infoblank_struct);
	if (forminfo->tbattrs->files->aliasblank_struct != NULL)
	    kfree(forminfo->tbattrs->files->aliasblank_struct);
	if (forminfo->tbattrs->files->todoblank_struct != NULL)
	    kfree(forminfo->tbattrs->files->todoblank_struct);
	if (forminfo->tbattrs->files->changelogblank_struct != NULL)
	    kfree(forminfo->tbattrs->files->changelogblank_struct);
	kfree(forminfo->tbattrs->files);
	if (forminfo->tbattrs->files_struct != NULL)
	    kfree(forminfo->tbattrs->files_struct);


	if (forminfo->tbattrs_struct != NULL)
	    kfree(forminfo->tbattrs_struct);
	kfree(forminfo->tbattrs);
	if (forminfo->template->help_struct != NULL)
	    kfree(forminfo->template->help_struct);
	if (forminfo->template->quit_struct != NULL)
	    kfree(forminfo->template->quit_struct);
	kfree(forminfo->template->obj_name);
	if (forminfo->template->obj_name_struct != NULL)
	    kfree(forminfo->template->obj_name_struct);
	kfree(forminfo->template->bname);
	if (forminfo->template->bname_struct != NULL)
	    kfree(forminfo->template->bname_struct);
	kfree(forminfo->template->icon_name);
	if (forminfo->template->icon_name_struct != NULL)
	    kfree(forminfo->template->icon_name_struct);
	kfree(forminfo->template->author);
	if (forminfo->template->author_struct != NULL)
	    kfree(forminfo->template->author_struct);
	kfree(forminfo->template->email);
	if (forminfo->template->email_struct != NULL)
	    kfree(forminfo->template->email_struct);
	kfree(forminfo->template->category);
	if (forminfo->template->category_struct != NULL)
	    kfree(forminfo->template->category_struct);
	kfree(forminfo->template->subcategory);
	if (forminfo->template->subcategory_struct != NULL)
	    kfree(forminfo->template->subcategory_struct);
	kfree(forminfo->template->description);
	if (forminfo->template->description_struct != NULL)
	    kfree(forminfo->template->description_struct);
	if (forminfo->template->blank2_struct != NULL)
	    kfree(forminfo->template->blank2_struct);
	if (forminfo->template->descblank_struct != NULL)
	    kfree(forminfo->template->descblank_struct);
	if (forminfo->template->kroutine->help_struct != NULL)
	    kfree(forminfo->template->kroutine->help_struct);
	if (forminfo->template->kroutine->incantata_struct != NULL)
	    kfree(forminfo->template->kroutine->incantata_struct);
	if (forminfo->template->kroutine->lib_routine_struct != NULL)
	    kfree(forminfo->template->kroutine->lib_routine_struct);
	kfree(forminfo->template->kroutine->lib_list);
	if (forminfo->template->kroutine->lib_list_struct != NULL)
	    kfree(forminfo->template->kroutine->lib_list_struct);
	if (forminfo->template->kroutine->create_kroutine_struct != NULL)
	    kfree(forminfo->template->kroutine->create_kroutine_struct);
	kfree(forminfo->template->kroutine);
	if (forminfo->template->kroutine_struct != NULL)
	    kfree(forminfo->template->kroutine_struct);

	if (forminfo->template->xvroutine->help_struct != NULL)
	    kfree(forminfo->template->xvroutine->help_struct);
	if (forminfo->template->xvroutine->incantata_struct != NULL)
	    kfree(forminfo->template->xvroutine->incantata_struct);
	if (forminfo->template->xvroutine->useform_struct != NULL)
	    kfree(forminfo->template->xvroutine->useform_struct);
	if (forminfo->template->xvroutine->create_xvroutine_struct != NULL)
	    kfree(forminfo->template->xvroutine->create_xvroutine_struct);
	kfree(forminfo->template->xvroutine);
	if (forminfo->template->xvroutine_struct != NULL)
	    kfree(forminfo->template->xvroutine_struct);

	if (forminfo->template->library->help_struct != NULL)
	    kfree(forminfo->template->library->help_struct);
	if (forminfo->template->library->create_library_struct != NULL)
	    kfree(forminfo->template->library->create_library_struct);
	kfree(forminfo->template->library);
	if (forminfo->template->library_struct != NULL)
	    kfree(forminfo->template->library_struct);

	if (forminfo->template->script->help_struct != NULL)
	    kfree(forminfo->template->script->help_struct);
	if (forminfo->template->script->lang_struct != NULL)
	    kfree(forminfo->template->script->lang_struct);
	if (forminfo->template->script->wantpane_struct != NULL)
	    kfree(forminfo->template->script->wantpane_struct);
	if (forminfo->template->script->incantata_struct != NULL)
	    kfree(forminfo->template->script->incantata_struct);
	if (forminfo->template->script->create_script_struct != NULL)
	    kfree(forminfo->template->script->create_script_struct);
	kfree(forminfo->template->script);
	if (forminfo->template->script_struct != NULL)
	    kfree(forminfo->template->script_struct);

	if (forminfo->template->pane->help_struct != NULL)
	    kfree(forminfo->template->pane->help_struct);
	if (forminfo->template->pane->incantata_struct != NULL)
	    kfree(forminfo->template->pane->incantata_struct);
	if (forminfo->template->pane->genexec_struct != NULL)
	    kfree(forminfo->template->pane->genexec_struct);
	kfree(forminfo->template->pane->tbname);
	if (forminfo->template->pane->tbname_struct != NULL)
	    kfree(forminfo->template->pane->tbname_struct);
	kfree(forminfo->template->pane->oname);
	if (forminfo->template->pane->oname_struct != NULL)
	    kfree(forminfo->template->pane->oname_struct);
	kfree(forminfo->template->pane->args);
	if (forminfo->template->pane->args_struct != NULL)
	    kfree(forminfo->template->pane->args_struct);
	if (forminfo->template->pane->create_pane_struct != NULL)
	    kfree(forminfo->template->pane->create_pane_struct);
	if (forminfo->template->pane->assoclabel_struct != NULL)
	    kfree(forminfo->template->pane->assoclabel_struct);
	kfree(forminfo->template->pane);
	if (forminfo->template->pane_struct != NULL)
	    kfree(forminfo->template->pane_struct);


	if (forminfo->template_struct != NULL)
	    kfree(forminfo->template_struct);
	kfree(forminfo->template);
	if (forminfo->obj_attributes->help_struct != NULL)
	    kfree(forminfo->obj_attributes->help_struct);
	if (forminfo->obj_attributes->quit_struct != NULL)
	    kfree(forminfo->obj_attributes->quit_struct);
	if (forminfo->obj_attributes->obj_attrs->help_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->help_struct);
	kfree(forminfo->obj_attributes->obj_attrs->description);
	if (forminfo->obj_attributes->obj_attrs->description_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->description_struct);
	kfree(forminfo->obj_attributes->obj_attrs->category);
	if (forminfo->obj_attributes->obj_attrs->category_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->category_struct);
	kfree(forminfo->obj_attributes->obj_attrs->subcategory);
	if (forminfo->obj_attributes->obj_attrs->subcategory_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->subcategory_struct);
	kfree(forminfo->obj_attributes->obj_attrs->icon_name);
	if (forminfo->obj_attributes->obj_attrs->icon_name_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->icon_name_struct);
	kfree(forminfo->obj_attributes->obj_attrs->name);
	if (forminfo->obj_attributes->obj_attrs->name_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->name_struct);
	kfree(forminfo->obj_attributes->obj_attrs->email);
	if (forminfo->obj_attributes->obj_attrs->email_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->email_struct);
	if (forminfo->obj_attributes->obj_attrs->install_in_cantata_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->install_in_cantata_struct);
	if (forminfo->obj_attributes->obj_attrs->apply_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->apply_struct);
	if (forminfo->obj_attributes->obj_attrs->tblabel_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->tblabel_struct);
	if (forminfo->obj_attributes->obj_attrs->onamelabel_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->onamelabel_struct);
	if (forminfo->obj_attributes->obj_attrs->tb_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->tb_struct);
	if (forminfo->obj_attributes->obj_attrs->oname_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->oname_struct);
	if (forminfo->obj_attributes->obj_attrs->authlabel_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->authlabel_struct);
	if (forminfo->obj_attributes->obj_attrs->otypelabel_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->otypelabel_struct);
	if (forminfo->obj_attributes->obj_attrs->otype_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->otype_struct);
	if (forminfo->obj_attributes->obj_attrs->descblank_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->descblank_struct);
	kfree(forminfo->obj_attributes->obj_attrs);
	if (forminfo->obj_attributes->obj_attrs_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs_struct);

	if (forminfo->obj_attributes->obj_keywords->keylist_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->keylist_struct);
	kfree(forminfo->obj_attributes->obj_keywords->keylist_label);
	if (forminfo->obj_attributes->obj_keywords->help_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->help_struct);
	if (forminfo->obj_attributes->obj_keywords->delete_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->delete_struct);
	kfree(forminfo->obj_attributes->obj_keywords->addkey);
	if (forminfo->obj_attributes->obj_keywords->addkey_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->addkey_struct);
	kfree(forminfo->obj_attributes->obj_keywords->chkey);
	if (forminfo->obj_attributes->obj_keywords->chkey_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->chkey_struct);
	kfree(forminfo->obj_attributes->obj_keywords);
	if (forminfo->obj_attributes->obj_keywords_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords_struct);

	if (forminfo->obj_attributes->paneattrs->help_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->help_struct);
	kfree(forminfo->obj_attributes->paneattrs->tbname);
	if (forminfo->obj_attributes->paneattrs->tbname_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->tbname_struct);
	kfree(forminfo->obj_attributes->paneattrs->oname);
	if (forminfo->obj_attributes->paneattrs->oname_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->oname_struct);
	kfree(forminfo->obj_attributes->paneattrs->args);
	if (forminfo->obj_attributes->paneattrs->args_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->args_struct);
	if (forminfo->obj_attributes->paneattrs->genexec_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->genexec_struct);
	if (forminfo->obj_attributes->paneattrs->apply_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->apply_struct);
	if (forminfo->obj_attributes->paneattrs->assoclabel_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->assoclabel_struct);
	kfree(forminfo->obj_attributes->paneattrs);
	if (forminfo->obj_attributes->paneattrs_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs_struct);


	if (forminfo->obj_attributes_struct != NULL)
	    kfree(forminfo->obj_attributes_struct);
	kfree(forminfo->obj_attributes);
	if (forminfo->copyobject->copy->help_struct != NULL)
	    kfree(forminfo->copyobject->copy->help_struct);
	if (forminfo->copyobject->copy->quit_struct != NULL)
	    kfree(forminfo->copyobject->copy->quit_struct);
	kfree(forminfo->copyobject->copy->desttb);
	if (forminfo->copyobject->copy->desttb_struct != NULL)
	    kfree(forminfo->copyobject->copy->desttb_struct);
	if (forminfo->copyobject->copy->docopy_struct != NULL)
	    kfree(forminfo->copyobject->copy->docopy_struct);
	if (forminfo->copyobject->copy->tblabel_struct != NULL)
	    kfree(forminfo->copyobject->copy->tblabel_struct);
	if (forminfo->copyobject->copy->olabel_struct != NULL)
	    kfree(forminfo->copyobject->copy->olabel_struct);
	if (forminfo->copyobject->copy->tbname_struct != NULL)
	    kfree(forminfo->copyobject->copy->tbname_struct);
	if (forminfo->copyobject->copy->oname_struct != NULL)
	    kfree(forminfo->copyobject->copy->oname_struct);
	kfree(forminfo->copyobject->copy);
	if (forminfo->copyobject->copy_struct != NULL)
	    kfree(forminfo->copyobject->copy_struct);


	if (forminfo->copyobject_struct != NULL)
	    kfree(forminfo->copyobject_struct);
	kfree(forminfo->copyobject);
	if (forminfo->mvobject->move->help_struct != NULL)
	    kfree(forminfo->mvobject->move->help_struct);
	if (forminfo->mvobject->move->quit_struct != NULL)
	    kfree(forminfo->mvobject->move->quit_struct);
	kfree(forminfo->mvobject->move->desttb);
	if (forminfo->mvobject->move->desttb_struct != NULL)
	    kfree(forminfo->mvobject->move->desttb_struct);
	if (forminfo->mvobject->move->domove_struct != NULL)
	    kfree(forminfo->mvobject->move->domove_struct);
	if (forminfo->mvobject->move->tblabel_struct != NULL)
	    kfree(forminfo->mvobject->move->tblabel_struct);
	if (forminfo->mvobject->move->olabel_struct != NULL)
	    kfree(forminfo->mvobject->move->olabel_struct);
	if (forminfo->mvobject->move->tbname_struct != NULL)
	    kfree(forminfo->mvobject->move->tbname_struct);
	if (forminfo->mvobject->move->oname_struct != NULL)
	    kfree(forminfo->mvobject->move->oname_struct);
	kfree(forminfo->mvobject->move);
	if (forminfo->mvobject->move_struct != NULL)
	    kfree(forminfo->mvobject->move_struct);


	if (forminfo->mvobject_struct != NULL)
	    kfree(forminfo->mvobject_struct);
	kfree(forminfo->mvobject);
	if (forminfo->rename_obj->rename->help_struct != NULL)
	    kfree(forminfo->rename_obj->rename->help_struct);
	if (forminfo->rename_obj->rename->quit_struct != NULL)
	    kfree(forminfo->rename_obj->rename->quit_struct);
	kfree(forminfo->rename_obj->rename->newname);
	if (forminfo->rename_obj->rename->newname_struct != NULL)
	    kfree(forminfo->rename_obj->rename->newname_struct);
	if (forminfo->rename_obj->rename->dorename_struct != NULL)
	    kfree(forminfo->rename_obj->rename->dorename_struct);
	if (forminfo->rename_obj->rename->tblabel_struct != NULL)
	    kfree(forminfo->rename_obj->rename->tblabel_struct);
	if (forminfo->rename_obj->rename->olabel_struct != NULL)
	    kfree(forminfo->rename_obj->rename->olabel_struct);
	if (forminfo->rename_obj->rename->tbname_struct != NULL)
	    kfree(forminfo->rename_obj->rename->tbname_struct);
	if (forminfo->rename_obj->rename->oname_struct != NULL)
	    kfree(forminfo->rename_obj->rename->oname_struct);
	kfree(forminfo->rename_obj->rename);
	if (forminfo->rename_obj->rename_struct != NULL)
	    kfree(forminfo->rename_obj->rename_struct);


	if (forminfo->rename_obj_struct != NULL)
	    kfree(forminfo->rename_obj_struct);
	kfree(forminfo->rename_obj);
	if (forminfo->objinfo->infopane->help_struct != NULL)
	    kfree(forminfo->objinfo->infopane->help_struct);
	if (forminfo->objinfo->infopane->quit_struct != NULL)
	    kfree(forminfo->objinfo->infopane->quit_struct);
	if (forminfo->objinfo->infopane->todo_struct != NULL)
	    kfree(forminfo->objinfo->infopane->todo_struct);
	if (forminfo->objinfo->infopane->crtodo_struct != NULL)
	    kfree(forminfo->objinfo->infopane->crtodo_struct);
	if (forminfo->objinfo->infopane->bugs_struct != NULL)
	    kfree(forminfo->objinfo->infopane->bugs_struct);
	if (forminfo->objinfo->infopane->crbugs_struct != NULL)
	    kfree(forminfo->objinfo->infopane->crbugs_struct);
	if (forminfo->objinfo->infopane->done_struct != NULL)
	    kfree(forminfo->objinfo->infopane->done_struct);
	if (forminfo->objinfo->infopane->crdone_struct != NULL)
	    kfree(forminfo->objinfo->infopane->crdone_struct);
	if (forminfo->objinfo->infopane->changelog_struct != NULL)
	    kfree(forminfo->objinfo->infopane->changelog_struct);
	if (forminfo->objinfo->infopane->crchangelog_struct != NULL)
	    kfree(forminfo->objinfo->infopane->crchangelog_struct);
	if (forminfo->objinfo->infopane->tblabel_struct != NULL)
	    kfree(forminfo->objinfo->infopane->tblabel_struct);
	if (forminfo->objinfo->infopane->olabel_struct != NULL)
	    kfree(forminfo->objinfo->infopane->olabel_struct);
	if (forminfo->objinfo->infopane->tbname_struct != NULL)
	    kfree(forminfo->objinfo->infopane->tbname_struct);
	if (forminfo->objinfo->infopane->oname_struct != NULL)
	    kfree(forminfo->objinfo->infopane->oname_struct);
	if (forminfo->objinfo->infopane->todo_blank_struct != NULL)
	    kfree(forminfo->objinfo->infopane->todo_blank_struct);
	if (forminfo->objinfo->infopane->bugs_blank_struct != NULL)
	    kfree(forminfo->objinfo->infopane->bugs_blank_struct);
	if (forminfo->objinfo->infopane->done_blank_struct != NULL)
	    kfree(forminfo->objinfo->infopane->done_blank_struct);
	if (forminfo->objinfo->infopane->changelog_blank_struct != NULL)
	    kfree(forminfo->objinfo->infopane->changelog_blank_struct);
	kfree(forminfo->objinfo->infopane);
	if (forminfo->objinfo->infopane_struct != NULL)
	    kfree(forminfo->objinfo->infopane_struct);


	if (forminfo->objinfo_struct != NULL)
	    kfree(forminfo->objinfo_struct);
	kfree(forminfo->objinfo);
	kfree(forminfo);
}
