 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane files
   >>>> 
   >>>>  Private: 
   >>>> 	files_config
   >>>> 	files_info
   >>>> 	files_files_apply
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

static int create_toolbox_file PROTO((kobject, int));


/*-----------------------------------------------------------
| Routine Name:	files_config - create or edit the toolbox imake config file
| 
| Purpose:	Do routine which is called when
|                  pane action button config is used
| 
| Input:	files_info - ptr to PaneInfo struct for files pane
| 
| Output:	None
| Written By:	Neil Bowers
| Date:		21-aug-1994
------------------------------------------------------------*/
void
files_config(
     tbattrs_files *files_info)
{
   kobject  file_object;
   kstring  path;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "files_config()", "No toolbox selected.");
      return;
   }

   if (!kcms_get_attribute(cmsToolbox, KCMS_TB_CONFIG_FILE, &file_object))
      return;

   /*-- if file exists, edit it ---------------------------------------*/
   if (file_object != NULL)
   {
      if (!kcms_get_attribute(file_object, KCMS_PATH, &path)
	  || path == NULL)
	 return;
      keditfile(path, TRUE,
		KEDITOR_GEOMETRY, "80x48",
		KEDITOR_CHDIR,    TRUE,
		NULL);
   }
   else  /*-- create template file and file object --------------------*/
   {
      if (create_toolbox_file(cmsToolbox, KCMS_TB_CONFIG_FILE))
	 xvf_set_attribute(files_info->config_struct, XVF_TITLE, "Edit");
   }
}

/*-----------------------------------------------------------
| Routine Name:	files_tbinfo - create or edit toolbox info file
| 
| Purpose:	Do routine which is called when
|		pane action button tbinfo is used
| 
| Input:	files_info - ptr to PaneInfo struct for files pane
| 
| Written By:	Neil Bowers
| Date:		21-aug-94
------------------------------------------------------------*/
void
files_tbinfo(
   tbattrs_files *files_info)
{
   kobject  file_object;
   kstring  path;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "files_tbinfo()", "No toolbox selected.");
      return;
   }

   if (!kcms_get_attribute(cmsToolbox, KCMS_TB_INFO_FILE, &file_object))
      return;

   /*-- if file exists, edit it ---------------------------------------*/
   if (file_object != NULL)
   {
      if (!kcms_get_attribute(file_object, KCMS_PATH, &path)
	  || path == NULL)
	 return;
      keditfile(path, TRUE,
		KEDITOR_GEOMETRY, "80x48",
		KEDITOR_CHDIR,    TRUE,
		NULL);
   }
   else  /*-- create template file and file object --------------------*/
   {
      if (create_toolbox_file(cmsToolbox, KCMS_TB_INFO_FILE))
	 xvf_set_attribute(files_info->tbinfo_struct, XVF_TITLE, "Edit");
   }
}

/*-----------------------------------------------------------
| Routine Name:	files_tbinclude - action handler for toolbox include button
| 
| Purpose:	This function is called when the user hits the
|		Toolbox Include File button on the toolbox attributes
|		subform, the Files pane.
|
| Input:	files_info - ptr to PaneInfo struct for files pane
| 
| Written By:	Neil Bowers
| Date:		13-oct-94
------------------------------------------------------------*/
void
files_tbinclude(
     tbattrs_files *files_info)
{
   kobject  file_object;
   kstring  path;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "files_tbinclude()", "No toolbox selected.");
      return;
   }

   if (!kcms_get_attribute(cmsToolbox, KCMS_TB_INCLUDE_FILE, &file_object))
      return;

   /*-- if file exists, edit it ---------------------------------------*/
   if (file_object != NULL)
   {
      if (!kcms_get_attribute(file_object, KCMS_PATH, &path)
	  || path == NULL)
	 return;
      keditfile(path, TRUE,
		KEDITOR_GEOMETRY, "80x48",
		KEDITOR_CHDIR,    TRUE,
		NULL);
   }
   else  /*-- create template file and file object --------------------*/
   {
      if (create_toolbox_file(cmsToolbox, KCMS_TB_INCLUDE_FILE))
	 xvf_set_attribute(files_info->tbinclude_struct, XVF_TITLE, "Edit");
   }
}

/*-----------------------------------------------------------
| Routine Name:	files_tbaliases - create or edit toolbox aliases file
| 
| Purpose:	This routine is invoked when the user hits the Create/Edit
|		button for toolbox aliases, on the Files pane of the
|		toolbox attributes subform.
| 
| Input:	files_info - ptr to PaneInfo struct for files pane
| 
| Written By:	Neil Bowers
| Date:		30-nov-94
------------------------------------------------------------*/
void
files_tbaliases(
   tbattrs_files *files_info)
{
   kobject  file_object;
   kstring  path;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "files_tbaliases()", "No toolbox selected.");
      return;
   }

   if (!kcms_get_attribute(cmsToolbox, KCMS_TB_ALIAS_FILE, &file_object))
      return;

   /*-- if file exists, edit it ---------------------------------------*/
   if (file_object != NULL)
   {
      if (!kcms_get_attribute(file_object, KCMS_PATH, &path)
	  || path == NULL)
	 return;
      keditfile(path, TRUE,
		KEDITOR_GEOMETRY, "80x48",
		KEDITOR_CHDIR,    TRUE,
		NULL);
   }
   else  /*-- create template file and file object --------------------*/
   {
      if (create_toolbox_file(cmsToolbox, KCMS_TB_ALIAS_FILE))
	 xvf_set_attribute(files_info->tbaliases_struct, XVF_TITLE, "Edit");
   }
}

/*-----------------------------------------------------------
| Routine Name:	create_toolbox_file - create standard toolbox file
| 
| Purpose:	This function is used to create a new file and associated
|		file object, for a specified toolbox.
|
|		NOTE: this function, like create_info_file() in
|		      do_infopane.c, is a temporary hack, and will go
|		      away once kcms has generic file/file object creation
|		      with template support.
| 
| Input:	files_info - ptr to PaneInfo struct for files pane
| 
| Written By:	Neil Bowers
| Date:		21-aug-94
------------------------------------------------------------*/
static int
create_toolbox_file(
   kobject  toolbox,
   int      attribute)
{
   kstring  routine  = "create_toolbox_file()";
   kobject  file_object;
   int      template_id;
   char     destination[KLENGTH];
   char     tblower[KLENGTH];
   char     tbcap[KLENGTH];
   kstring  template;
   kstring  tbname;
   kstring  tbpath;
   kstring  description;
   int      ftype;
   int      fsubtype;


   if (!kcms_get_attributes(toolbox,
			    KCMS_NAME, &tbname,
			    KCMS_PATH, &tbpath,
			    KCMS_END))
      return FALSE;
   kstring_lower(tbname, tblower);
   kstring_capitalize(tbname, tbcap);

   switch (attribute)
   {
      case KCMS_TB_INFO_FILE:
	 template_id = KCMS_TEMPLATE_INFO_FILE;
	 ftype       = KCMS_FOBJ_TYPE_INFO;
	 fsubtype    = KCMS_FOBJ_SUBTYPE_DESCRIPTION;
	 description = "toolbox description";
	 ksprintf(destination, "$%s/repos/ToolboxInfo", tbname);
	 break;

      case KCMS_TB_INCLUDE_FILE:
	 template_id = KCMS_TEMPLATE_TB_INCLUDE_FILE;
	 ftype       = KCMS_FOBJ_TYPE_SRC;
	 fsubtype    = KCMS_FOBJ_SUBTYPE_INCL;
	 description = "toolbox include";
	 ksprintf(destination, "$%s/include/%s.h", tbname, tblower);
	 break;

      case KCMS_TB_ALIAS_FILE:
	 template_id = KCMS_TEMPLATE_TB_ALIAS_FILE;
	 ftype       = KCMS_FOBJ_TYPE_CONFIG;
	 fsubtype    = KCMS_FOBJ_SUBTYPE_ALIAS_FILE;
	 description = "toolbox aliases";
	 ksprintf(destination, "$%s/repos/Aliases", tbname);
	 break;

      case KCMS_TB_CONFIG_FILE:
	 template_id = KCMS_TEMPLATE_CONFIG_FILE;
	 ftype       = KCMS_FOBJ_TYPE_CONFIG;
	 fsubtype    = KCMS_FOBJ_SUBTYPE_IMAKE_CONFIG;
	 description = "imake configuration";
	 ksprintf(destination, "$%s/repos/config/imake_config/%s.def",
		  tbname, tblower);
	 break;

      case KCMS_TB_TODO_FILE:
	 template_id = KCMS_TEMPLATE_TB_TODO;
	 ftype       = KCMS_FOBJ_TYPE_INFO;
	 fsubtype    = KCMS_FOBJ_SUBTYPE_TODO;
	 description = "toolbox todo";
	 ksprintf(destination, "$%s/repos/info/todo", tbname);
	 break;

      case KCMS_TB_CHANGELOG_FILE:
	 template_id = KCMS_TEMPLATE_TB_CHANGELOG;
	 ftype       = KCMS_FOBJ_TYPE_INFO;
	 fsubtype    = KCMS_FOBJ_SUBTYPE_CHANGELOG;
	 description = "toolbox changelog";
	 ksprintf(destination, "$%s/repos/info/changelog", tbname);
	 break;

      default:
	 kerror(NULL, routine, "Illegal toolbox file specified.");
	 return FALSE;
   }

   template = kcms_query_template(toolbox, template_id);

   if (kaccess(destination, R_OK) == 0)
   {
      kwarn(NULL, routine, "Toolbox `%s' already has a `%s' file. "
	    "This will NOT be overwritten, but will be "
	    "added to the toolbox's database.",
	    tbname, description);
   }
   else if (!ksedfile(template, destination, FALSE, KFILE_UPDATE, NULL,
		      "#toolbox-name#", tblower,
		      "#Toolbox-Name#", tbcap,
		      "#TOOLBOX-NAME#", tbname,
		      NULL))
   {
      kerror(NULL, routine, "Could not copy template file into toolbox:\n\n"
	    "Toolbox:     %s\n"
	    "Template:    %s\n"
	    "Destination: %s\n\n"
	    "The file will not be referenced in the toolbox database.",
	    tbname, template, destination);
      return FALSE;
   }

   file_object = kcms_create_fileobj(toolbox, destination, NULL,
				     ftype, fsubtype,
				     KCMS_FOBJ_GEN_NONE,
				     KCMS_FOBJ_ACCESS_RDWR);

   return (file_object != NULL);
}
/*-----------------------------------------------------------
| 
|  Routine Name: files_tbtodo
| 
|       Purpose: Do routine which is called when
|                  pane action button tbtodo is used
| 
|         Input: files_info - ptr to PaneInfo struct for files pane
| 
|        Output: None
|    Written By: 
|          Date: Mar 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
files_tbtodo(
   tbattrs_files *files_info)
{
   kobject  file_object;
   kstring  path;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "files_tbinclude()", "No toolbox selected.");
      return;
   }

   if (!kcms_get_attribute(cmsToolbox, KCMS_TB_TODO_FILE, &file_object))
      return;

   /*-- if file exists, edit it ---------------------------------------*/
   if (file_object != NULL)
   {
      if (!kcms_get_attribute(file_object, KCMS_PATH, &path)
	  || path == NULL)
	 return;
      keditfile(path, TRUE,
		KEDITOR_GEOMETRY, "80x48",
		KEDITOR_CHDIR,    TRUE,
		NULL);
   }
   else  /*-- create template file and file object --------------------*/
   {
      if (create_toolbox_file(cmsToolbox, KCMS_TB_TODO_FILE))
	 xvf_set_attribute(files_info->tbtodo_struct, XVF_TITLE, "Edit");
   }
}


/*-----------------------------------------------------------
| Routine Name: files_tbchangelog
| 
| Purpose:	Do routine which is called when
|		pane action button tbchangelog is used
| 
| Input:	files_info - ptr to PaneInfo struct for files pane
| 
| Written By:	Neil Bowers
| Date:		8-mar-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
files_tbchangelog(
   tbattrs_files *files_info)
{
   kobject  file_object;
   kstring  path;


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "files_tbinclude()", "No toolbox selected.");
      return;
   }

   if (!kcms_get_attribute(cmsToolbox, KCMS_TB_CHANGELOG_FILE, &file_object))
      return;

   /*-- if file exists, edit it ---------------------------------------*/
   if (file_object != NULL)
   {
      if (!kcms_get_attribute(file_object, KCMS_PATH, &path)
	  || path == NULL)
	 return;
      keditfile(path, TRUE,
		KEDITOR_GEOMETRY, "80x48",
		KEDITOR_CHDIR,    TRUE,
		NULL);
   }
   else  /*-- create template file and file object --------------------*/
   {
      if (create_toolbox_file(cmsToolbox, KCMS_TB_CHANGELOG_FILE))
	 xvf_set_attribute(files_info->tbchangelog_struct, XVF_TITLE, "Edit");
   }
}


