/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/* 
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for master Craftsman
   >>>> 
   >>>>  Private: 
   >>>>         craftsman_toolbox
   >>>>         craftsman_open
   >>>>         craftsman_delete
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	craftsman_open - edit the selected software object
| 
| Purpose:	This is the UIS callback function associated with the
|		"Edit Object" selection on the "Object Operations" menu.
|		The selected software object is edited, which currently
|		means that Composer is invoked on the object.
| 
| Input:	craftsman_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		Jun 01, 1993
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_open(
   gui_info_struct * craftsman_info)
{
   if (strObject == NULL)
      kerror(NULL, "craftsman_open()",
	     "You have not selected a software object to edit!");
   else
      edit_object();
}

/*-----------------------------------------------------------
| Routine Name:	craftsman_delete - delete the selected software object
| 
| Purpose:	This is the UIS callback function associated with the
|		"Delete Object" selection on the "Object Operations" menu.
|		The user is prompted to confirm that they really do want
|		to remove the object.  If so, the object is deleted.
| 
| Input:	craftsman_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		1-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_delete(
   gui_info_struct * craftsman_info)
{
   if (strObject == NULL)
      kerror(NULL, "craftsman_delete()",
	     "You have not selected a software object to delete!");
   else
      delete_object();
}

/*-----------------------------------------------------------
| Routine Name:	craftsman_rmtb - delete the selected toolbox
| 
| Purpose:	Do routine which is called when
|		master action button rmtb is used
| 
| Input:	craftsman_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		1-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_rmtb(
   gui_info_struct * craftsman_info)
{
   if (cmsToolbox == NULL)
      kerror(NULL, "craftsman_rmtb()",
	     "You have not selected a toolbox to delete!");
   else
      delete_toolbox();
}

/*-----------------------------------------------------------
| Routine Name:	craftsman_tblist
| 
| Purpose:	This routine is called when the user selects
|		a toolbox from the DisplayList of toolboxes.
| 
| Input:	master_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		16-feb-94
------------------------------------------------------------*/
void
craftsman_tblist(
   gui_info_struct * master_info)
{
   kstring routine = "Toolbox List Callback";
   kobject toolbox;
   kstring tbname;


   tbname = toolbox_names[master_info->tblist];

   if ((toolbox = kcms_open_toolbox(tbname)) != NULL)
      select_toolbox(toolbox);
   else
      kerror(NULL, routine, "Unable to open toolbox `%s'.", tbname);
}


/*-----------------------------------------------------------
| Routine Name:	craftsman_objlist
| 
| Purpose:	callback routine for object list.
| 
| Input:	master_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		Feb 16, 1994
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_objlist(
   gui_info_struct * master_info)
{
   kstring routine = "Object List Callback";
   kstring oname;
   kobject object;


   oname = object_names[gui_info->objlist];

   if ((object = kcms_open_cmobj(cmsToolbox, oname)) != NULL)
   {
      kcms_close(object);
      select_object(oname);
   }
   else
      kerror(NULL, routine,
	 "Failed to open object `%s' in toolbox `%s'\n",
	 oname, strToolbox);
}

/*-----------------------------------------------------------
| Routine Name:	craftsman_mkmanual - create toolbox manual
| 
| Purpose:	Do routine which is called when
|		master action button mkmanual is used
| 
| Input:	master_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		19-aug-94
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_mkmanual(
   gui_info_struct *master_info)
{
   char  manual_name[KLENGTH];


   if (cmsToolbox == NULL)
   {
      kerror(NULL, "craftsman_mkmanual()",
	     "You have not selected a toolbox to create a manual for!");
      return;
   }

   /*-- prompt the user for confirmation on manual creation -----------*/
   if (kstring_lower(strToolbox, manual_name) == NULL)
      return;

   manual_name[0] = toupper(manual_name[0]);
   if (!kprompt(KFORCE, "Yes", "No", FALSE,
		"Operation: create toolbox manual\n\n"
		"\tToolbox : %s\n"
		"\tManual  : %s\n\n"
		"Do you want to continue with creation of the manual?",
		strToolbox, manual_name))
      return;

   /*-- pop up the notifier, so user can see progress messages --------*/
   xvw_set_attributes(xvoNotifier,
		      XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		      XVW_NOTIFYWINDOW_MESSAGE, "Generating Manual",
		      NULL);

   kcms_create_manual(cmsToolbox, manual_name);

   /*-- pop down the notifier window ----------------------------------*/
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
}

/*-----------------------------------------------------------
| Routine Name:	craftsman_dereftb - remove a toolbox reference
| 
| Purpose:	Do routine which is called when
|		master action button dereftb is used
| 
| Input:	master_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		30-nov-94
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_dereftb(
   gui_info_struct *master_info)
{
   if (cmsToolbox == NULL)
   {
      kerror(NULL, "craftsman_dereftb()",
	     "You have not selected a toolbox to remove a reference to!");
      return;
   }

   if (!kprompt(KFORCE, "Yes", "No", FALSE,
		"Operation: remove toolbox reference\n\n"
		"\tToolbox: %s\n\n"
		"Do you want to continue with removal of toolbox reference?",
		strToolbox))
      return;

   if (kcms_env_deletetb(strToolbox))
   {
      update_tblist();
      cmsToolbox = NULL;
      select_toolbox(NULL);
   }
}

/*-----------------------------------------------------------
| Routine Name:	craftsman_objlist_dblclick - double click handler for list
|					     of software objects
| 
| Purpose:	This routine is invoked when the user double-clicks on
|		an entry in the software object list.
| 
| Input:	master_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		1-dec-94
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_objlist_dblclick(
     gui_info_struct *master_info)
{
   kstring routine = "Object List Double-click Callback";
   kstring oname;
   kobject object;


   /*-- object name which user double-clicked on ----------------------*/
   oname = object_names[gui_info->objlist];

   /*-- if not already selected, then select object -------------------*/
   if (oname != strObject)
   {
      if ((object = kcms_open_cmobj(cmsToolbox, oname)) != NULL)
      {
	 kcms_close(object);
	 select_object(oname);
      }
      else
	 kerror(NULL, routine, "Failed to open object `%s' in toolbox `%s'\n",
		oname, strToolbox);
   }

   /*-- double-clicking is used to invoked composer -------------------*/
   edit_object();
}

/*-----------------------------------------------------------
| Routine Name: craftsman_klinttb
| 
| Purpose:	Do routine which is called when
|		master action button klinttb is used
| 
| Input:	master_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		11-mar-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_klinttb(
   gui_info_struct *master_info)
{
   char  buffer[KLENGTH];

   ksprintf(buffer, "klint -tb %s", strToolbox);
   xvw_set_attributes(xvoNotifier,
		      XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		      XVW_NOTIFYWINDOW_MESSAGE, buffer,
		      NULL);
   xvw_system(buffer);
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
}

/*-----------------------------------------------------------
| Routine Name:	craftsman_klintobj - run klint on selected object
| 
| Purpose:	Do routine which is called when
|		master action button klintobj is used
| 
| Input:	master_info - ptr to FormInfo struct for craftsman
| 
| Written By:	Neil Bowers
| Date:		11-mar-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
craftsman_klintobj(
   gui_info_struct *master_info)
{
   char  buffer[KLENGTH];

   ksprintf(buffer, "klint -tb %s -oname %s", strToolbox, strObject);
   xvw_set_attributes(xvoNotifier,
		      XVW_NOTIFYWINDOW_VISIBLE, TRUE,
		      XVW_NOTIFYWINDOW_MESSAGE, buffer,
		      NULL);
   xvw_system(buffer);
   xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
}

