/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>   Static:
   >>>>         xvlist_callback()
   >>>>   Public:
   >>>>         objlist_callback()
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"

/*-----------------------------------------------------------
| Routine Name:	install_xvlist_context - install a list context onto a list
|
| Purpose:	This routine attaches an xvlist context to an xvlist.
|
| Input:	list		- a pointer to the xvlist structure
|		context	- pointer to the context to be installed
|
| Output:	none
|
| Returns:	TRUE (1) on success, FALSE (0) otherwise
| Written By:	Neil Bowers
| Date:		18-oct-93
------------------------------------------------------------*/
int
install_xvlist_context(
   xvlist_context *  context)
{
   xvf_set_attributes(gui_info->filelist_struct,
		      XVF_LIST_SIZE,     context->nstrings,
		      XVF_LIST_CONTENTS, context->strings,
		      NULL);

   /*-- if no files, then de-activate all edit/view buttons -----------*/
   if (context->nstrings == 0)
   {
      xvf_set_attributes(gui_info->edit_struct,
			 XVF_ACTIVATE, FALSE,
			 XVF_TITLE,    "",
			 NULL);
      xvf_set_attributes(gui_info->view_struct,
			 XVF_ACTIVATE, FALSE,
			 XVF_TITLE,    "",
			 NULL);
      xvf_set_attributes(gui_info->interactive_struct,
			 XVF_ACTIVATE, FALSE,
			 XVF_TITLE,    "",
			 NULL);
   }

   if (context->selected != -1)
   {
      xvf_set_attribute(gui_info->filelist_struct,
			XVF_LIST_INDEX, context->selected);

      if (context->callback != NULL)
	 context->callback(context,
			   context->strings[context->selected],
			   context->selected);
   }
   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	create_xvlist_context - create a context for list object
|
| Purpose:	This routine allocates and initializes an xvlist context
|		structure.  An xvlist_context is attached to an xvlist,
|		providing the list of strings and callback function.
|
|		When you are finished with the context, you should free
|		up the memory associated with it, by calling
|		free_xvlist_context().
|
| Input:	name		- a name for the context
|		strings	- an array of string pointers
|		nstrings	- the number of strings in the strings
|		argument.
|		callback	- the callback function to associate
|		with this context.
|
| Returns:	a pointer to the new xvlist_context structure if successful,
|		NULL otherwise.
|
| Written By:	Neil Bowers
| Date:		17-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
xvlist_context *
create_xvlist_context(
   char *name,
   char **strings,
   int nstrings,
   xvlist_callback callback)
{
   xvlist_context *context;


   context = (xvlist_context *) kmalloc(sizeof(xvlist_context));
   if (context != NULL)
   {
      context->callback = callback;
      context->strings  = strings;
      context->nstrings = nstrings;
      context->selected = nstrings > 0 ? 0 : -1;
   }

   return context;
}

/*-----------------------------------------------------------
| Routine Name:	update_xvlist_context - change strings in an xvlist context
|
| Purpose:	This routine updates an xvlist context with a new array
|		of strings.  If the context is currently attached to
|		an xvlist, then the xvlist is updated.
|
| Input:	context	- the xvlist context to update
|		strings	- array of string pointers
|		nstrings	- number of strings in the argument strings
|
| Returns:	TRUE on success, FALSE on failure.
|
| Written By:	Neil Bowers
| Date:		17-oct-93
------------------------------------------------------------*/
int
update_xvlist_context(
   xvlist_context  *context,
   kstring         *strings,
   int              nstrings)
{
   /*-- UPDATE: worry about whether we should free current strings --*/

   context->strings  = strings;
   context->nstrings = nstrings;

   xvf_set_attributes(gui_info->filelist_struct,
		      XVF_LIST_SIZE,     nstrings,
		      XVF_LIST_CONTENTS, strings,
		      NULL);

   if (context->nstrings > 0)
   {
      context->selected = 0;
      xvf_set_attribute(gui_info->filelist_struct,
			XVF_LIST_INDEX, context->selected);

      if (context->callback != NULL)
	 context->callback(context, strings[0], 0);
   }
   else
      context->selected = -1;

   return TRUE;
}
