/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Image Display Utility Routines
   >>>>
   >>>>  Private:
   >>>>		create_list_widget()
   >>>>		change_list_contents()
   >>>>
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"

static FileInfo file_info_table[] =
{
   {COMP_UIS_LIST, "User Interface Spec.",
    KCMS_CMOBJ_ALL_UIS, -1, NULL, NULL, NULL,
    {NULL, NULL, NULL}, NULL},

   {COMP_SRC_LIST, "Source Code",
    KCMS_CMOBJ_ALL_SRC, -1, NULL, NULL, NULL,
    {NULL, NULL, NULL}, NULL},

   {COMP_DOC_LIST, "Documentation",
    KCMS_CMOBJ_ALL_DOC, -1, NULL, NULL, NULL,
    {NULL, NULL, NULL}, NULL},

   {COMP_CONFIG_LIST, "Configuration",
    KCMS_CMOBJ_ALL_CONFIG, -1, NULL, NULL, NULL,
    {NULL, NULL, NULL}, NULL},

   {COMP_INFO_LIST, "Information",
    KCMS_CMOBJ_ALL_INFO, -1, NULL, NULL, NULL,
    {NULL, NULL, NULL}, NULL},

   {COMP_MISC_LIST, "Miscellaneous",
    KCMS_CMOBJ_ALL_MISC, -1, NULL, NULL, NULL,
    {NULL, NULL, NULL}, NULL},

   {COMP_ALL_LIST, "All Files",
    KCMS_CMOBJ_ALL_FILES, -1, NULL, NULL, NULL,
    {NULL, NULL, NULL}, NULL},

   {-1, NULL, -1, -1, NULL, NULL, NULL,
    {NULL, NULL, NULL}, NULL}
};

EditFileInfo editor_table[] =
{
   {KCMS_FOBJ_TYPE_MISC,
    {"Edit       ", NULL},
    {"View       ", NULL},
    {NULL, NULL}},

   {KCMS_FOBJ_TYPE_SRC,
    {"Edit       ", NULL},
    {"View       ", NULL},
    {NULL, NULL}},

   {KCMS_FOBJ_TYPE_MAN,
    {"Edit       ", NULL},
    {"View       ", NULL},
    {"Formatted", NULL}},

   {KCMS_FOBJ_TYPE_HELP,
    {"Edit       ", NULL},
    {"View       ", NULL},
    {" Formatted ", NULL}},

   {KCMS_FOBJ_TYPE_MANUAL,
    {"Edit       ", NULL},
    {"View       ", NULL},
    {" Formatted ", NULL}},

   {KCMS_FOBJ_TYPE_UIS,
    {"Edit       ", NULL},
    {"Preview    ", "preview -i %f"},
    {"Guise      ", "guise -tb %T -oname %O -uis %f"}},

   {KCMS_FOBJ_TYPE_SCRIPT,
    {"Edit       ", NULL},
    {"View       ", NULL},
    {NULL, NULL}},

   {KCMS_FOBJ_TYPE_DBM,
    {NULL, NULL},
    {"View       ", "kdbmedit -view -dbm %f"},
    {NULL, NULL}},

   {KCMS_FOBJ_TYPE_INFO,
    {"Edit       ", NULL},
    {"View       ", NULL},
    {NULL, NULL}},

   {KCMS_FOBJ_TYPE_CONFIG,
    {"Edit       ", NULL},
    {"View       ", NULL},
    {NULL, NULL}},

   {-1,
    {NULL, NULL},
    {NULL, NULL},
    {NULL, NULL}}
};

EditFileInfo workspace_edit_info=
{
   KCMS_FOBJ_TYPE,
   {"Edit", NULL},
   {"Run Workspace", "runwksp -tb %T -oname %O"},
   {"Cantata", "cantata -tb %T -oname %O"}
};

/*-----------------------------------------------------------
| Routine Name:	change_list_contents - Routine to change the list
|
| Purpose:	This routine is called to change the contents of
|		the list based on which type of files should be
|		displayed.  For example, for library objects, there
|		is not a UIS, therefore, upons startup, the source
|		file should be displayed in the list.
|
| Input:	list_type - type of files being displayed in list
|
| Returns:	
| Written By:	Becky Bishop
| Date:		Wed May 26 09:30:04 MDT 1993
------------------------------------------------------------*/
void
change_list_contents(
   int  list_type)
{
   char  label[KLENGTH];


   cur_file_info = get_file_info(list_type);
   cur_file_type = list_type;

   /*-- change the label on the displayList to reflect file type ------*/
   xvf_set_attribute(gui_info->filelist_struct,
		     XVF_TITLE, cur_file_info->title);

   ksprintf(label, "Adding file to object of type \"%s\":",
	    cur_file_info->title);
   xvf_set_attribute(gui_info->addfile->add_pane_struct,
		     XVF_TITLE, label);

   install_xvlist_context(cur_file_info->context);
   if (cur_file_info->context->selected != -1)
      cur_fileobj = cur_file_info->fileobjs[cur_file_info->context->selected];
}

/*-----------------------------------------------------------
| Routine Name:	context_callback - callback routine for list contexts
|
| Purpose:	This is the function called when the user selects an item
|		in the list of files.
|
| Input:	context	-	the active xvlist_context
|		string		-	the string selected
|		string_index	-	the index (position) of the item
|		in the list
|
| Written By:	Neil Bowers
| Date:		28-oct-93
------------------------------------------------------------*/
/* ARGSUSED */
static void
context_callback(
   xvlist_context  *context,
   kstring          string,
   int              string_index)
{
   int            file_type;
   int            fsubtype;
   EditFileInfo  *edit_info;


   if (!select_file_object(cur_file_info->fileobjs[string_index]))
      return;

   if (!kcms_get_attributes(cur_fileobj,
			    KCMS_FOBJ_TYPE,    &file_type,
			    KCMS_FOBJ_SUBTYPE, &fsubtype,
			    KCMS_END))
   {
      kerror(NULL, "File Select",
	     "Unable to determine type of selected file.");
      return;
   }

   if ((edit_info = get_edit_info(file_type, fsubtype)) == NULL)
   {
      kerror(NULL, "File Select",
	     "Unable to get editor information for file.");
      return;
   }

   if (file_type == COMP_DOC_LIST && context->nstrings == 2 &&
       string_index == 0)
      xvf_set_attribute(gui_info->edit_struct, XVF_ACTIVATE,
			FALSE);
   else
      xvf_set_attribute(gui_info->edit_struct, XVF_ACTIVATE,
			(edit_info->ascii.name == NULL ? 0 : 1));

   xvf_set_attribute(gui_info->view_struct, XVF_ACTIVATE,
		     (edit_info->view.name == NULL ? 0 : 1));

   xvf_set_attribute(gui_info->interactive_struct, XVF_ACTIVATE,
		     (edit_info->edit.name == NULL ? 0 : 1));

   xvf_set_attribute(gui_info->edit_struct,
		     XVF_TITLE, (edit_info->ascii.name != NULL
				 ? edit_info->ascii.name
				 : ""));

   xvf_set_attribute(gui_info->view_struct,
		     XVF_TITLE, (edit_info->view.name != NULL
				 ? edit_info->view.name
				 : ""));

   xvf_set_attribute(gui_info->interactive_struct,
		     XVF_TITLE, (edit_info->edit.name != NULL
				 ? edit_info->edit.name
			         : ""));
}

/*-----------------------------------------------------------
| Routine Name:	get_file_info - get FileInfo structure for a given file type
|
| Purpose:	This should be a complete description that anyone
|		could understand;  it should have acceptable grammar
|		and correct spelling.
|
| Input:	file_type	- identifier specifying required file type.
|		this can be one of:
| Output:	none
| Returns:	pointer to the FileInfo structure, or NULL on failure.
| Written By:	Neil Bowers
| Date:		18-oct-93
------------------------------------------------------------*/
FileInfo *
get_file_info(
   int file_type)
{
   int        i;
   klist     *fobj_list;
   FileInfo  *finfo = NULL;


   for (i = 0; finfo == NULL && file_info_table[i].file_type != -1; i++)
      if (file_info_table[i].file_type == file_type)
	 finfo = &file_info_table[i];
   if (finfo == NULL)
      return NULL;

   if (finfo->nfiles != -1)
      return finfo;

   kcms_get_attribute(cmsObject, finfo->attribute, &fobj_list);

   if (finfo->paths != NULL)
      kfree(finfo->paths);
   finfo->paths = kcms_list_get_attribute(fobj_list,
					KCMS_FOBJ_FULLNAME, &finfo->nfiles);

   if (finfo->basenames != NULL)
      kfree(finfo->basenames);
   finfo->basenames = kcms_list_get_attribute(fobj_list,
					KCMS_FOBJ_BASENAME, &finfo->nfiles);
   if (finfo->fileobjs != NULL)
      kfree(finfo->fileobjs);

#if 0
   for (i = 0; i < 3; i++)
   {
      if (finfo->pids[i] != NULL)
	 kfree(finfo->pids[i]);
      finfo->pids[i] = (int *)kcalloc(finfo->nfiles, sizeof(int));
   }
#endif

   finfo->fileobjs = (kobject *) kmalloc(finfo->nfiles * sizeof(kobject));
   for (i = 0; i < finfo->nfiles; i++)
   {
      finfo->fileobjs[i] = klist_clientdata(fobj_list);
      fobj_list = klist_next(fobj_list);
   }
   if (finfo->context == NULL)
   {
      finfo->context = create_xvlist_context("context",
					     finfo->basenames, finfo->nfiles,
					(xvlist_callback) context_callback);
      if (file_type == COMP_DOC_LIST && finfo->nfiles == 2)
	 finfo->context->selected = 1;
   }
   else
      update_xvlist_context(finfo->context, finfo->basenames,
			    finfo->nfiles);

   return finfo;
}

/*-----------------------------------------------------------
| Routine Name:	get_edit_info - get EditFileInfo structure for a given file type
|
| Purpose:	This should be a complete description that anyone
|		could understand;  it should have acceptable grammar
|		and correct spelling.
|
| Input:	file_type	- identifier specifying required file type.
| Output:	none
| Returns:	pointer to the EditFileInfo structure, or NULL on failure.
| Written By:	Neil Bowers
| Date:		26-oct-93
------------------------------------------------------------*/
EditFileInfo *
get_edit_info(
   int  file_type,
   int  file_subtype)
{
   int i;


   if (file_type == KCMS_FOBJ_TYPE_DBM
       && file_subtype == KCMS_FOBJ_SUBTYPE_WORKSPACE)
   {
      return &workspace_edit_info;
   }

   for (i = 0; editor_table[i].file_type != -1; i++)
      if (editor_table[i].file_type == file_type)
	 return &editor_table[i];
   return NULL;
}

/*-----------------------------------------------------------
| Routine Name:	clear_file_table - reset the file info table
|
| Purpose:	This function clears the file info table, and
|		sets it so the table will be initialized on demand,
|		the same way it is on start-up.  Lazy re-initialization ;-)
|
| Written By:	Neil Bowers
| Date:		30-oct-93
------------------------------------------------------------*/
void
clear_file_table(void)
{
   int i;


   /*-- KLUDGE: should free up anything pre-allocated in the table --*/
   for (i = 0; file_info_table[i].file_type != -1; i++)
      file_info_table[i].nfiles = -1;
}
