/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane obj_attrs
   >>>> 
   >>>>  Private: 
   >>>>         obj_attrs_apply
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"

/*-----------------------------------------------------------
| Routine Name:	obj_attrs_apply
| 
| Purpose:	This function is invoked by the forms when the user hits
|		the 'APPLY CHANGES' button on the 'Object Attributes'
|		subform.
|
|		For each string on the pane, the associated object attribute
|		is retrieved from the object, and compared with the string
|		in the string selection.  If they are different then the
|		attribute is changed to the value in the string selection.
| 
| Input:	obj_attrs_info - ptr to PaneInfo struct for obj_attrs pane
| 
| Written By:	Neil Bowers
| Date:		Oct 29, 1993
------------------------------------------------------------*/
void
obj_attrs_apply(
   obj_attributes_obj_attrs * pane)
{
   kstring        string;
   int            installed;


   /*UPDATE:-------------------------------------------------------
   |    Still Ugly, ugly, ugly.  This will be table driven.
   +------------------------------------------------------------- */

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_AUTHOR, &string);
   if (kstrcmp(string, pane->name))
      kcms_set_attribute(cmsObject, KCMS_CMOBJ_AUTHOR, pane->name);

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_AUTHOR_EMAIL, &string);
   if (kstrcmp(string, pane->email))
      kcms_set_attribute(cmsObject, KCMS_CMOBJ_AUTHOR_EMAIL, pane->email);

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_CATEGORY, &string);
   if (kstrcmp(string, pane->category))
      kcms_set_attribute(cmsObject, KCMS_CMOBJ_CATEGORY, pane->category);

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_SUBCATEGORY, &string);
   if (kstrcmp(string, pane->subcategory))
      kcms_set_attribute(cmsObject, KCMS_CMOBJ_SUBCATEGORY, pane->subcategory);

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_SHORT_DESC, &string);
   if (kstrcmp(string, pane->description))
      kcms_set_attribute(cmsObject, KCMS_CMOBJ_SHORT_DESC, pane->description);

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_ICON_NAME, &string);
   if (kstrcmp(string, pane->icon_name))
      kcms_set_attribute(cmsObject, KCMS_CMOBJ_ICON_NAME, pane->icon_name);

   kcms_get_attribute(cmsObject, KCMS_CMOBJ_CI_INSTALLED, &installed);
   if (installed != pane->install_in_cantata_num - 1)
      kcms_set_attribute(cmsObject, KCMS_CMOBJ_CI_INSTALLED,
			 pane->install_in_cantata_num - 1);

}
