 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Routines For Dealing w/ Cantata Form
   >>>> 
   >>>>  Private: 
   >>>>			create_glyph()
   >>>>			status_callback()
   >>>>			update_status()
   >>>>			update_position()
   >>>>			change_workspace()
   >>>>			save_workspace()
   >>>>			restore_workspace()
   >>>>			update_vardef_displaylist()
   >>>>			update_varscope_displaylist()
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "cantata.h"

/*-----------------------------------------------------------
|
|  Routine Name: create_glyph
|
|       Purpose: Creates a operator according to the selection from the 
|                pulldown menu.
|         Input: object - the subcategory action
|		 client_data - the pane list
|		 call_data   - none
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Oct 11, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void create_glyph(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject  operator, temp;
	xvw_program_info *info = (xvw_program_info *) call_data;

	if (!info)
	   return;

	if (info->type == Procedure)
	{
	   operator = xvw_create_procedure(workspace, "procedure");
	   xvw_set_attributes(operator,
                XVW_NODE_NAME,      info->icon_name,
                XVW_GLYPH_TBNAME,   info->tbname,
                XVW_GLYPH_ONAME,    info->oname,
                NULL);
	   xvw_get_attribute(operator, XVW_PROCEDURE_WORKSPACE_OBJECT, &temp);
	   xvw_set_attribute(temp, XVW_WORKSPACE_RESTORE, info->workspace);
	}
	else if (info->type == Conditional)
	{
	   operator = xvw_create_conditional(workspace, "conditional");
	   xvw_set_attributes(operator, 
		XVW_NODE_NAME,	    info->icon_name,
		XVW_GLYPH_FORMFILE, info->panefile,
		XVW_GLYPH_TBNAME,   info->tbname,
		XVW_GLYPH_ONAME,    info->oname,
		NULL);
	}
	else if (info->type == Loop)
	{
	   operator = xvw_create_loop(workspace, "loop");
	   xvw_set_attributes(operator, 
		XVW_NODE_NAME,	    info->icon_name,
		XVW_GLYPH_FORMFILE, info->panefile,
		XVW_GLYPH_TBNAME,   info->tbname,
		XVW_GLYPH_ONAME,    info->oname,
		NULL);
	}
	else
	{
	   operator = xvw_create_glyph(workspace, "glyph");
	   xvw_set_attributes(operator, 
		XVW_NODE_NAME,	    info->icon_name,
		XVW_GLYPH_FORMFILE, info->panefile,
		XVW_GLYPH_TBNAME,   info->tbname,
		XVW_GLYPH_ONAME,    info->oname,
		NULL);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: status_callback
|
|       Purpose: Updates the description from the currently selected
|		 form struct.  The description is updated
|		 
|         Input: object - the toolboxlist object
|		 client_data - the description kformstruct
|		 call_data   - the program object information
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Jul 11, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void status_callback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	char title[KLENGTH];
	xvw_program_info *info = (xvw_program_info *) call_data;


	if (status_mode == FALSE)
	   return;

	ksprintf(title, "%s - %s", info->oname, info->short_desc ?
			info->short_desc: "(unknown short description)");
	if (status)  xvw_set_attribute(status,  XVW_LABEL, title);
}

/*-----------------------------------------------------------
|
|  Routine Name: update_status
|
|       Purpose: Updates the status from the currently status info message.
|
|         Input: toolbox - the toolbox in which the message was issued
|		 program - the program in which the message was issued
|		 library - the library in which the message was issued
|		 routine - the routine in which the message was issued
|		 message - the message in which the message was issued
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Jul 11, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int update_status(
   char *toolbox,
   char *program,
   char *library,
   char *routine,
   char *message)
{
	if (status_mode == FALSE)
	   return(TRUE);

	if (status)  xvw_set_attribute(status, XVW_LABEL, message);
        return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: update_position
|
|       Purpose: Updates the position indicator from the current workspace
|		 position.
|
|         Input: object - the workspace plane
|		 client_data - the position indicator
|		 event  - the event
|       Returns:
|    Written By: Mark Young
|          Date: Dec 08, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
void update_position(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   int      *dispatch)
{
	xvobject position = (xvobject) client_data;
	char temp[KLENGTH];


	if (event->type != MotionNotify)
	   return;

	ksprintf(temp, "( %4d x %4d )", event->xmotion.x, event->xmotion.y);
	xvw_set_attribute(position, XVW_LABEL, temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: change_workspace
|
|       Purpose: This routine changes the currently selected workspace within
|                the main workspace object.  We use this info to know which
|		 workspace the user is currently working.
|
|         Input: object - the main workspace object
|		 client_data - the active workspace indicator
|		 call_data   - the newly selected workspace
|       Returns:
|    Written By: Mark Young
|          Date: Dec 08, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
void change_workspace(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject status   = (xvobject) client_data;
	xvobject selected = *((xvobject *) call_data);

	xvobject plane;
	char temp[KLENGTH], *name;


	/*
	 *  Now build a name heirarchy in which we can show the active
	 *  workspace.
	 */
	ksprintf(temp, "Active Workspace:  %s", xvw_name(object));
	while (object != selected)
	{
	   kstrcat(temp, ".");

	   plane = selected;
	   while (xvw_parent(plane) != object)
	      plane = xvw_parent(plane);

	   object = plane;
	   xvw_get_attribute(object, XVW_WORKSPACE_NAME, &name);
	   kstrcat(temp, name);
	}
	xvw_set_attribute(status, XVW_LABEL, temp);

	/*
	 *  Now change the active workspace that the position is tracking on.
	 */
	xvw_get_attribute(workspace, XVW_VP_PLANE_OBJECT, &plane);
	xvw_remove_event(plane, PointerMotionMask, update_position, position);
	xvw_get_attribute(selected, XVW_VP_PLANE_OBJECT, &plane);
	xvw_add_event(plane, PointerMotionMask, update_position, position);

	/*
	 *  Finally make the newly selected object our working workspace object.
	 */
	workspace = selected;
	update_varscope_displaylist(NULL);

}

/*-----------------------------------------------------------
|
|  Routine Name: save_workspace
|
|       Purpose: saves a workspace into the supplied filename
|         Input: filename - the filename to save the workspace into
|		 saveall  - whether to save all glyphs or just the
|			    selected ones.
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Oct 11, 1993
| Modifications:
|
------------------------------------------------------------*/

void save_workspace(
   char *filename,
   int  saveall)
{
	/*
	 *  Do the actual restoring of the workspace...
	 */
	if (!koverwrite(KSTANDARD, filename))
	   return;

	if (saveall)
	   xvw_set_attribute(workspace, XVW_WORKSPACE_SAVEALL, filename);
	else
	   xvw_set_attribute(workspace, XVW_WORKSPACE_SAVE, filename);
}

/*-----------------------------------------------------------
|
|  Routine Name: restore_workspace
|
|       Purpose: restore a workspace into the supplied filename
|         Input: filename - the filename to restore the workspace from
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Oct 11, 1993
| Modifications:
|
------------------------------------------------------------*/

void restore_workspace(
   char *filename)
{
	xvw_set_attribute(workspace, XVW_WORKSPACE_RESTORE, filename);
}

/*-----------------------------------------------------------
|
|  Routine Name: update_vardef_displaylist
|
|       Purpose: Updates the list of variables & their values
|                on the "Variables Defined" displaylist selection 
|                of the "Variables" subform, according to the variables 
|                currently defined in the scope of the current workspace.
|         Input: selected_workspace - workspace to update the variable list for
|        Output:
|       Returns:
|    Written By: Danielle Argiro
|          Date: Dec 13, 1994
| Modifications:
|
------------------------------------------------------------*/

void update_vardef_displaylist(
   xvobject selected_workspace)
{
	int  num;
	char **variable_entries;

	/* get the variables defined in the scope of the current workspace */
        variable_entries = kexpr_variables_list((long)selected_workspace, 1,
					        &num);

        /* set the "Variables Defined By:" displaylist to display wksp names */
        xvf_set_attributes(gui_info->var->variables->vardef_struct,
                           XVF_LIST_SIZE,     num,
                           XVF_LIST_CONTENTS, variable_entries,
                           NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: update_varscope_displaylist
|
|       Purpose: Updates the list of workspace names on the 
|                "Scope Defined By:" displaylist selection 
|                of the "Variables" subform, according to the 
|                names of the main workspace  & any sub-workspaces
|                currently defined in the scope of the current workspace.
|         Input: selected_name - selected name of workspace, if NULL
|				 then use the active workspace.
|        Output:
|       Returns:
|    Written By: Danielle Argiro
|          Date: Dec 13, 1994
| Modifications:
|
------------------------------------------------------------*/

void update_varscope_displaylist(
   char *selected_name)
{
	char         *name;
	xvobject     *subworkspaces = NULL;
	char         **workspace_names; 
	int          i, num, indx;
	xvobject     selected_workspace = main_workspace;

	if (selected_name == NULL)
	{
	   if (workspace == main_workspace)
	      selected_name = xvw_name(workspace);
	   else
              xvw_get_attribute(workspace, XVW_WORKSPACE_NAME, &selected_name);
	}
	
	/* get all subworkspaces of main workspace */
        subworkspaces = xvw_children(main_workspace, xvwWorkspaceWidgetClass, 
				     &num);

	indx = 0;

	/* get list of workspace names, including name of main workspace */
        workspace_names = (char **) kcalloc(num+1, sizeof(char *));
        workspace_names[0] = xvw_name(main_workspace);
        for (i = 0; i < num; i++)
        {
            xvw_get_attribute(subworkspaces[i], XVW_WORKSPACE_NAME, &name);
            workspace_names[i+1] = kstrdup(name);
	    if (kstrcmp(name, selected_name) == 0)
	    {
	       indx = i+1;
	       selected_workspace = subworkspaces[i];
	    }
        }

        /* set the "scope" displaylist to display workspace names */
        xvf_set_attributes(gui_info->var->variables->scope_struct,
                           XVF_LIST_SIZE,     num+1,
                           XVF_LIST_CONTENTS, workspace_names,
                           XVF_LIST_INDEX,    indx,
                           NULL);

	/*
	 * update list of variables & their values on 
	 * "Variables Defined" displaylist
	 */
	update_vardef_displaylist(selected_workspace);
}
