 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>           Pop-Up Online Help Utilities                <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>                xvu_quit_online_help()	    	      <<<<              
   >>>>   Public:                                             <<<<
   >>>>                xvu_online_help_wait()		      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"	

static int  xvu_help_done  = FALSE;


/*-----------------------------------------------------------
|
|  Routine Name: xvu_quit_online_help()
|
|       Purpose: Quits the online help object.
|
|         Input: object      - the quit button
|                client_data - stores the Help_Data structure
|                call_data   - unused
|
|        Output: none
|          Date: Jul 9, 1992
|    Written By: Danielle Argiro
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/
/* ARGSUSED */
static void xvu_quit_online_help(
   xvobject object,
   kaddr  client_data,
   kaddr  call_data)
{
	/*
	 * set the toplevel to designate the we are done
	 */
	xvu_help_done = TRUE;
}

/************************************************************
*
*  Routine Name: xvu_online_help_wait - display help file or help directory
*
*       Purpose: Create a large read-only text object in which one or
*		 more ascii files may be displayed.
*
*		 If the path specified is to a single file, that
*		 file is displayed. If the path specified is a directory, 
*		 the text object will have one button at the top labeled
*		 with the name of each file in the directory.  Clicking
*		 on such a button will cause the contents of the file labeled
*		 to appear in the text object.  In either case, the on-line
*		 help object will be displayed until the user clicks on the
*		 "Quit" button.  This utility will not grab events from the 
*		 application program.
*
*         Input: path   - the path of the (single) file to be displayed, 
*                         or the directory containing the (multiple) files 
*                         to be displayed in the online help object.  
*			  The path may include a '~' if desired, or may contain
*			  a reference to $TOOLBOX.
*
*                label  - short label for top of help object;
*			  NULL gives default of "Help".
*
*        Output:
*	Returns: TRUE on success, FALSE on failure
*  Restrictions:
*    Written By: Danielle Argiro & Mark Young
*          Date: Jul 9, 1992
*      Verified:
*  Side Effects:
* Modifications: Converted from Khoros 1.0 (DA)
*
*************************************************************/

int xvu_online_help_wait(
   char *path,
   char *label)
{
	xvobject help;

	xvu_help_done = FALSE;
	if (xvw_display(NULL) == NULL)
	{
	    kinfo(KSTANDARD, "see '%s'\n", path);
	    return(TRUE);
	}

	help = xvw_create_help(NULL, "Online Help");
	xvw_set_attributes(help,
		XVW_HELP_TITLE,	    label,
		XVW_HELP_FILENAME,  path,
		NULL);
	xvw_add_callback(help, XVW_HELP_CALLBACK, xvu_quit_online_help, NULL);

	while(!xvu_help_done)
	    xvw_process_event();  

	return(TRUE);
}
