 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Double GUI Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		ActionCallback()
   >>>> 		ScrollbarCallback()
   >>>>   Public:
   >>>>			xvw_create_double()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/DoubleP.h>

static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	ActionCallback  PROTO((xvobject, kaddr));
static void     ScrollbarCallback PROTO((xvobject, kaddr, kaddr));



/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_DOUBLE_LABEL_OBJECT,     NULL,   XtRPointer,  NULL},
{XVW_DOUBLE_CRLABEL_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_DOUBLE_SCROLLBAR_OBJECT, NULL,   XtRPointer,  NULL},
{XVW_DOUBLE_TEXT_OBJECT,      NULL,   XtRPointer,  NULL},
{XVW_DOUBLE_VALUE,            NULL,   XtRDouble,   NULL},
{XVW_DOUBLE_MINVALUE,         NULL,   XtRDouble,   NULL},
{XVW_DOUBLE_MAXVALUE,         NULL,   XtRDouble,   NULL},
{XVW_DOUBLE_CALLBACK,	      NULL,   XtRCallback, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwDoubleWidgetRec, doublepart.field)

static XtResource resources[] = { 
{XVW_DOUBLE_VALUE, NULL, XtRDouble, sizeof(double),
        offset(value), XtRString, (XtPointer) "0.0"},
{XVW_DOUBLE_MINVALUE, NULL, XtRDouble, sizeof(double),
        offset(minvalue), XtRString, (XtPointer) "0.0"},
{XVW_DOUBLE_MAXVALUE, NULL, XtRDouble, sizeof(double),
        offset(maxvalue), XtRString, (XtPointer) "1.0"},
{XVW_DOUBLE_LABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(label), XtRImmediate, (XtPointer) NULL},
{XVW_DOUBLE_TEXT_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(text), XtRImmediate, (XtPointer) NULL},
{XVW_DOUBLE_SCROLLBAR_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(scrollbar), XtRImmediate, (XtPointer) NULL},
{XVW_DOUBLE_CRLABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(crlabel), XtRImmediate, (XtPointer) NULL},
{XVW_DOUBLE_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(double_callback), XtRCallback, (XtPointer) NULL},

{XVW_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwDoubleWidgetRec, core.width),
        XtRImmediate, (XtPointer) 300 },
{XVW_BORDER_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwDoubleWidgetRec, core.border_width),
        XtRImmediate, (XtPointer) 0 },
{XVW_BUFFER_DIST, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwDoubleWidgetRec, manager.buffer_dist),
        XtRImmediate, (XtPointer) 0 },
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Double Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwDoubleWidgetClassRec xvwDoubleWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Double",				/* class_name		  */
    sizeof(XvwDoubleWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,				/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwDoubleWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwDoubleWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwDoubleWidgetClass = (WidgetClass) &xvwDoubleWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwDoubleWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwDoubleWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwDoubleWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Double");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial double widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwDoubleWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);

	char temp[KLENGTH];

	xwid->doublepart.label = xvw_create_labelstr(object, "label");
	xvw_set_attributes(xwid->doublepart.label,
		XVW_LABEL,	      "Double:",
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_LABEL_JUSTIFY,    KLABEL_JUSTIFY_LEFT,
		XVW_BORDER_WIDTH,     0,
		XVW_RIGHT_OF,	      NULL,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xwid->doublepart.crlabel = xvw_create_pixmap(object, "cr_pixmap");
	xvw_set_attributes(xwid->doublepart.crlabel,
		XVW_BORDER_WIDTH,     0,
		XVW_LEFT_OF,	      NULL,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	(void) ksprintf(temp, "%g", xwid->doublepart.value);
	xwid->doublepart.text = xvw_create_text(object, "text");
	xvw_set_attributes(xwid->doublepart.text,
		XVW_TEXT_STRING,      temp,
		XVW_TEXT_MULTILINE,   FALSE,
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_CHAR_WIDTH,	      10.0,
		XVW_BORDER_WIDTH,     2,
		XVW_LEFT_OF,	      xwid->doublepart.crlabel,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xwid->doublepart.scrollbar = xvw_create_scrollbar(object, "scrollbar");
	xvw_set_attributes(xwid->doublepart.scrollbar,
		XVW_CHAR_MAX_HEIGHT,  1.0,
		XVW_SCROLL_VALUE,     xwid->doublepart.value,
		XVW_SCROLL_MIN,       xwid->doublepart.minvalue,
		XVW_SCROLL_MAX,	      xwid->doublepart.maxvalue,
		XVW_LEFT_OF,	      xwid->doublepart.text,
		XVW_RIGHT_OF,	      xwid->doublepart.label,
		XVW_TACK_EDGE,	      KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	      NULL,
		XVW_BELOW,	      NULL,
		NULL);

	xvw_set_attributes(object,
		XVW_CHAR_MAX_HEIGHT, 1.0,
		XVW_CHAR_MIN_HEIGHT, 1.0,
		XVW_BORDER_WIDTH,    0,
		NULL);

	xvw_add_action(xwid->doublepart.text, "<Key>Return", ActionCallback,
		object, TRUE);
	xvw_insert_callback(xwid->doublepart.scrollbar, XVW_SCROLL_CONT_MOTION,
			 FALSE, ScrollbarCallback, (XtPointer) object);
	xvw_insert_callback(xwid->doublepart.scrollbar, XVW_SCROLL_INCR_MOTION,
			 FALSE, ScrollbarCallback, (XtPointer) object);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwDoubleWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the double.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|       Returns:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwDoubleWidget cxwid = kwidget(current);
	XvwDoubleWidget nxwid = kwidget(new);

	char temp[KLENGTH];

	if (cxwid->doublepart.value    != nxwid->doublepart.value ||
	    cxwid->doublepart.minvalue != nxwid->doublepart.minvalue ||
	    cxwid->doublepart.maxvalue != nxwid->doublepart.maxvalue)
	{
	   xvw_set_attributes(nxwid->doublepart.scrollbar,
		XVW_SCROLL_MIN,    nxwid->doublepart.minvalue,
		XVW_SCROLL_VALUE,  nxwid->doublepart.value,
		XVW_SCROLL_MAX,    nxwid->doublepart.maxvalue,
		NULL);

	   ksprintf(temp, "%g", nxwid->doublepart.value);
	   xvw_set_attribute(nxwid->doublepart.text, XVW_TEXT_STRING, temp);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ActionCallback
|
|       Purpose: This routine will be called when the user presses return
|		 within the text window.
|
|         Input: text      - which text being manipulated
|                client_data - the double gui object
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Nov 01, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ActionCallback(
   xvobject text,
   kaddr    client_data)
{
	xvobject object = (xvobject) client_data;
	XvwDoubleWidget xwid = (XvwDoubleWidget) xvw_widget(object);

	char *tmp = NULL;
	double value;

	xvw_get_attribute(text, XVW_TEXT_STRING, &tmp);
	(void) ksscanf(tmp, "%lg", &value);
	xvw_set_attribute(object, XVW_DOUBLE_VALUE, value);
	XtCallCallbacks(xvw_widget(object), XVW_DOUBLE_CALLBACK,
		&xwid->doublepart.value);
}

/*-----------------------------------------------------------
|
|  Routine Name: ScrollbarCallback
|
|       Purpose: This routine will change the text and update the
|	 	 scrollbar according to the value paased in.
|
|         Input: scrollbar      - which scrollbar being manipulated
|		 client_data - the double gui object
|		 call_data   - double representing the scroll position
|
|        Output: None
|       Returns: None 
|
|    Written By: Mark Young 
|          Date: Jun 06, 1993 10:58
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ScrollbarCallback(
   xvobject scrollbar,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject object = (xvobject) client_data;
	XvwDoubleWidget xwid = (XvwDoubleWidget) xvw_widget(object);
	double value = *((double *) call_data);


	xvw_set_attribute(object, XVW_DOUBLE_VALUE, value);
	XtCallCallbacks(xvw_widget(object), XVW_DOUBLE_CALLBACK,
		&xwid->doublepart.value);
}

/************************************************************
*
*  Routine Name: xvw_create_double - creates a double object
*
*       Purpose: The double GUI object 
*                allows the user to enter a double precision value.
*                It features a text box in which the user may explicitly 
*                enter the double value;  the double value is registered 
*                when the user hits <cr>.  The double value may be bounded 
*                by a minimum and maximum value, if desired.
*
*                A scroll bar provides an alternate way for the user to 
*                specify the double value.  The double object consists of 
*                a manager object with four children: a label object, a 
*                text object, a scrollbar, and a pixmap object.  
*
*		 A callback can be installed on the double object, which
*                will be fired when the user enters a new double value.
*
*         Input: parent - parent of the double object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference double object
*        Output:
*       Returns: The double GUI object on success, NULL on failure.
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 01, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_double(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, DoubleWidgetClass);
	return(object);
}
