 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Loop Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		Initialize()
   >>>> 		SetValues()
   >>>>	
   >>>> 		LoopExec()
   >>>> 		LoopRunCallback()
   >>>>   Public:
   >>>>			xvw_create_loop()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/LoopP.h>
#include <xvlang/ProcedureP.h>
#include <xvlang/WorkspaceP.h>

static void ClassInitialize PROTO((void));
static void Initialize      PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,Cardinal *));

static void LoopExec	    PROTO((Widget, int));
static void LoopRunCallback PROTO((Widget, int));


/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_LOOP_TYPE,   NULL,   XtRInt,  NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwLoopWidgetRec, loop.field)

static XtResource resources[] = { 
{XVW_LOOP_TYPE, NULL, XtRInt, sizeof(int),
        offset(type), XtRImmediate, (XtPointer) KLOOP_TYPE_UNKNOWN},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Loop Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwProcedureWidgetClassRec)

XvwLoopWidgetClassRec xvwLoopWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Loop",				/* class_name		  */
    sizeof(XvwLoopWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwLoopWidgetConstraintsRec),/* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    XtInheritCheckNode,	                    /* firing rule check  */
    LoopExec,  		                    /* execute node       */
    NULL, 		                    /* extension          */
  },  /* XvwNodeWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwGlyphWidgetClass fields initialization */
  {
    LoopRunCallback, 	                    /* run callback       */
    NULL,  		                    /* extension          */
  },  /* XvwProcedureWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwLoopWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwLoopWidgetClass = (WidgetClass) &xvwLoopWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	    (XvwLoopWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwLoopWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|    Written By: Mark Young
|          Date: Nov 24, 1994
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwLoopWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvlang/uis/Loop.pane");
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/Loop");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial loop
|                widget instance.
|
|         Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: May 26, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
        XvwLoopWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);


	xwid->loop.count = xvw_create_labelstr(object, "Value");
	xvw_set_attributes(xwid->loop.count,
		XVW_FOREGROUND_COLOR, "yellow",
		XVW_BELOW,    xwid->node.icon,
		XVW_ABOVE,    xwid->node.icon,
		XVW_LEFT_OF,  xwid->node.icon,
		XVW_RIGHT_OF, xwid->node.icon,
		XVW_MAPPED,   FALSE,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwLoopWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the loop.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Nov 24, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwLoopWidget cxwid = kwidget(current);
	XvwLoopWidget nxwid = kwidget(new);

	char *icon = NULL, *file = NULL;


	if (cxwid->glyph.oname != nxwid->glyph.oname)
	{
	   if (kstrcmp(nxwid->glyph.oname, "while") == 0)
	      nxwid->loop.type = KLOOP_TYPE_WHILE;
	   else if (kstrcmp(nxwid->glyph.oname, "count") == 0)
	      nxwid->loop.type = KLOOP_TYPE_COUNT;
	}
	else if (cxwid->loop.type != nxwid->loop.type)
	{
	   if (nxwid->loop.type == KLOOP_TYPE_WHILE)
	      nxwid->glyph.oname = kstrdup("while");
	   else if (nxwid->loop.type == KLOOP_TYPE_COUNT)
	      nxwid->glyph.oname = kstrdup("count");
	}

	if (cxwid->node.modified != nxwid->node.modified)
	{
	   if (nxwid->node.modified == TRUE)
	      xvw_set_attribute(nxwid->loop.count, XVW_MAPPED, FALSE);
	   else
	      xvw_set_attribute(nxwid->loop.count, XVW_MAPPED, TRUE);
	}

	if (cxwid->loop.type != nxwid->loop.type)
	{
	   if (nxwid->loop.type == KLOOP_TYPE_WHILE)
	   {
              icon = "$DESIGN/objects/library/xvlang/misc/control/while.xpm";
              file = "$DESIGN/objects/library/xvlang/uis/control/while.pane";
	   }
	   else if (nxwid->loop.type == KLOOP_TYPE_COUNT)
	   {
              icon = "$DESIGN/objects/library/xvlang/misc/control/count.xpm";
              file = "$DESIGN/objects/library/xvlang/uis/control/count.pane";
	   }

	   if (icon != NULL)
	      xvw_set_attribute(xvw_object(new), XVW_NODE_PIXMAPFILE, icon);

	   if (file != NULL)
	   {
	      xvw_set_attribute(xvw_object(new), XVW_GLYPH_FORMFILE, file);
	      xvw_set_attribute(nxwid->procedure.workspace,
			XVW_WORKSPACE_WKSPGUI, nxwid->glyph.form);
	   }
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: LoopExec
|
|       Purpose: This routine will run or stop the execution of a loop.
|         Input: widget      - the loop widget to be run
|                exec        - whether we wish to run or stop the loop
|    Written By: Mark Young
|          Date: Nov 24, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void LoopExec(
   Widget   widget,
   int      exec)
{
	XvwLoopWidget xwid = kwidget(widget);

	kselection *selection;
	int	   i, init, run;
	char	   temp[KLENGTH], *lcv;


	if (exec == KNODE_RUNNING)
	{
	   /*
	    *  Make sure that our glyph data available is set to
	    *  false.
	    */
	   run = TRUE;
	   for (i = 0; i < xwid->glyph.osize; i++)
	      xvw_set_attribute(xwid->glyph.oports[i], XVW_PORT_DAV, FALSE);

	   xwid->loop.value = 0;
	   xvw_set_attribute(xwid->procedure.workspace,
		XVW_WORKSPACE_RESET, TRUE);

	   if (xwid->loop.type == KLOOP_TYPE_WHILE)
	   {
	      selection = kvf_variable_sel_search(xwid->glyph.form, "init");
	      if (selection == NULL)
	         return;
	      xvf_get_attribute(selection->back_kformstruct, XVF_INT_VAL,&init);
	   }
	   else if (xwid->loop.type == KLOOP_TYPE_COUNT)
	   {
              long id = (long) xwid->glyph.expression_id;

	      selection = kvf_variable_sel_search(xwid->glyph.form, "lcv");
	      if (selection == NULL)
	         return;
	      xvf_get_attribute(selection->back_kformstruct,
			XVF_STRING_VAL, &lcv);

	      selection = kvf_variable_sel_search(xwid->glyph.form, "init");
	      if (selection == NULL)
	         return;
	      xvf_get_attribute(selection->back_kformstruct, XVF_INT_VAL,&init);
	      ksprintf(temp, "%s = %d", lcv, init);
	      (void) kexpr_evaluate_int(id, temp, &init, NULL);
	   }
	}
	else if (exec == KNODE_STOPPED)
	   run = FALSE;

	xvw_set_attribute(xwid->procedure.workspace, XVW_WORKSPACE_RUN, run);
}

/*-----------------------------------------------------------
|
|  Routine Name: LoopRunCallback
|
|       Purpose: This routine will indicate that the workspace is or has run
|         Input: widget      - the loop widget to be run
|                running     - whether we are running or not
|    Written By: Mark Young
|          Date: Nov 24, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void LoopRunCallback(
   Widget   widget,
   int      running)
{
	XvwLoopWidget xwid = kwidget(widget);
	XvwWorkspaceWidget xtmp;

	kselection *selection;
	char	   temp[KLENGTH], *lcv;
	int	   i, value, update, incr, test;


	/*
	 *  We know why the procedure is already running.  What we want
	 *  to do is run it again if it stops.  Hence if exec says that there
	 *  are things scheduled or running then we don't need to do anything.
	 */
	xtmp = (XvwWorkspaceWidget) xvw_widget(xwid->procedure.workspace);
	if (running == TRUE)
	   xvw_set_attribute(xwid->glyph.execute, XVW_PIXMAP,
			xwid->glyph.on_pixmap);
	else
	   xvw_set_attribute(xwid->glyph.execute, XVW_PIXMAP,
			xwid->glyph.off_pixmap);

	/*
	 *  If the isn't running or the workspace is in the middle of
	 *  scheduling.  Then return.
	 */
	if (xwid->node.running == KNODE_STOPPED ||
	    xtmp->workspace.scheduling == TRUE)
	{
	   return;
	}

	if (xwid->loop.type == KLOOP_TYPE_WHILE)
	{
	   selection = kvf_variable_sel_search(xwid->glyph.form, "update");
	   if (selection == NULL)
	      return;
	   xvf_get_attribute(selection->back_kformstruct, XVF_INT_VAL, &update);

	   selection = kvf_variable_sel_search(xwid->glyph.form, "test");
	   if (selection == NULL)
	      return;
	   xvf_get_attribute(selection->back_kformstruct, XVF_INT_VAL, &value);
	}
	else if (xwid->loop.type == KLOOP_TYPE_COUNT)
	{
           long id = (long) xwid->glyph.expression_id;

	   selection = kvf_variable_sel_search(xwid->glyph.form, "lcv");
	   if (selection == NULL)
	      return;
	   xvf_get_attribute(selection->back_kformstruct, XVF_STRING_VAL, &lcv);

	   selection = kvf_variable_sel_search(xwid->glyph.form, "incr");
	   if (selection == NULL)
	      return;
	   xvf_get_attribute(selection->back_kformstruct, XVF_INT_VAL, &incr);

	   ksprintf(temp, "%s += %d", lcv, incr);
	   (void) kexpr_evaluate_int(id, temp, &incr, NULL);

	   selection = kvf_variable_sel_search(xwid->glyph.form, "test");
	   if (selection == NULL)
	      return;
	   xvf_get_attribute(selection->back_kformstruct, XVF_INT_VAL, &test);
	   ksprintf(temp, "%s <= %d", lcv, test);
	   (void) kexpr_evaluate_int(id, temp, &value, NULL);
	}

	if (value == FALSE)
	{
	   /*
	    *  Make sure that our glyph data available is set to
	    *  true.
	    */
	   for (i = 0; i < xwid->glyph.osize; i++)
	      xvw_set_attribute(xwid->glyph.oports[i], XVW_PORT_DAV, TRUE);

	   if (running == FALSE)
	   {
	      xvw_set_attributes(xvw_object(widget),
		   XVW_NODE_MODIFIED, FALSE,
		   XVW_NODE_EXECUTE, FALSE,
		   NULL);
	   }
	}
	else
	{
	   ksprintf(temp, "%d", ++xwid->loop.value);
	   xvw_set_attributes(xwid->loop.count,
		XVW_LABEL,  temp,
	   	XVW_MAPPED, TRUE,
		NULL);
	   xvw_set_attributes(xwid->procedure.workspace,
		XVW_WORKSPACE_RESET, TRUE,
		XVW_WORKSPACE_RUN, TRUE,
		NULL);
	}
}


/************************************************************
*
*  Routine Name: xvw_create_loop - create a loop object
*
*       Purpose: The purpose of the loop GUI object is to provide a
*		 visual heirarchy for visual programming.  The loop
*		 object consists of glyph object, which is the node used
*		 to represent the iconified visual program.  When the Loop
*		 is opened a workspace object will be mapped which will contain
*		 the visual program.  The workspace can be used to construct
*		 visual programs, where the exported input/output parameters
*		 will appear on the Loop object as input & output
*		 ports.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The loop object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Nov 24, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_loop(
   xvobject parent,
   char     *name)
{
	xvobject loop;


	loop = xvw_create(parent, FALSE, TRUE, name, LoopWidgetClass);
	xvw_set_attributes(loop,
		XVW_SELECTABLE, TRUE,
		XVW_RESIZABLE, FALSE,
		XVW_MENUABLE, FALSE,
		NULL);
	return(loop);
}
