 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Image Capture Routines
   >>>>
   >>>>   Static:
   >>>>		   getinfo()
   >>>>  Private:
   >>>>   Public:
   >>>>		   xvw_getimage()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <X11/cursorfont.h>


/*-----------------------------------------------------------
|
|  Routine Name: getinfo - 
|
|       Purpose: 
|         Input: 
|        Output: 
|       Returns: 
|
|    Written By:
|          Date: 
|
------------------------------------------------------------*/

static int getinfo(
    xvobject object, 
    int      subimage,
    int      decor,
    Window   *workspace,
    int	     *x,
    int	     *y,
    unsigned int *w,
    unsigned int *h)
{
        GC        gc;
        XGCValues xgcv;
        XEvent    event;
        Display   *display;
        unsigned  long mask, gcmask;
        Window    window, root, dummy;
	int       x1, x2, y1, y2, xtmp, ytmp, grab, screen_num;
        unsigned  int  width, height, root_width, root_height, tmp;
        Cursor    cursor, temp, cursor_ul, cursor_ll, cursor_ur, cursor_lr;

        display    = xvw_display(object);
	root       = xvw_rootwindow(object);
	screen_num = xvw_screennum(object);
	root_width  = DisplayWidth(display, screen_num);
	root_height = DisplayHeight(display, screen_num);

	/*
	 *  If the object already exists, then 
	 */
	if (object != NULL)
	{
	   window = xvw_window(object);
           if (!decor && window != root)
	      window = XmuClientWindow(display, window);

	   if (subimage == FALSE)
	   {
	      *workspace = window; *x = 0; *y = 0;
	      XGetGeometry(display, *workspace, &root, x, y, w, h, &tmp, &tmp);
	      XTranslateCoordinates(display, *workspace, root, 0,0,x,y, &dummy);
	      if (*x < 0)
		 *w += *x, *x = kabs(*x);
	      else if (*x+*w > root_width)
		 *w = root_width - *x, *x = 0;
	      else *x = 0;

	      if (*y < 0)
	         *h += *y, *y = kabs(*y);
	      else if (*y+*h > root_height)
		 *h = root_height - *y, *y = 0;
	      else *y = 0;

	      return(TRUE);
	   }
	}
	else window = root;

        /*
         * Grab the mouse so that the user can select either the
         * window or area of the screen they desire to dump.
         */
	if (subimage)
	{
           cursor_ul = XCreateFontCursor(display, XC_ul_angle);
           cursor_ur = XCreateFontCursor(display, XC_ur_angle);
           cursor_ll = XCreateFontCursor(display, XC_ll_angle);
           cursor_lr = XCreateFontCursor(display, XC_lr_angle);
	   cursor = cursor_ul;
	}
	else
           cursor = XCreateFontCursor(display, XC_crosshair);

	mask = PointerMotionMask|ButtonReleaseMask|ButtonPressMask;
        grab = XGrabPointer(display, window, False, mask, GrabModeAsync,
			GrabModeAsync, window, cursor, CurrentTime);
        if (grab != GrabSuccess)
        {
	   kerror(NULL, "xvw_getimage","Could not grab pointer for display");
	   return(FALSE);
        }

        /*
         * Get the entire window rather than a portion or subimage of one.
         */
        do
	{
          XNextEvent(display, &event);
        } while(event.type != ButtonPress);

        /*
         * ----- get interactively specified area of screen ----
         */
        if (subimage)
        {
           /* set up the graphics context to be used with graphics windows */
           xgcv.function       = GXinvert;
           xgcv.subwindow_mode = IncludeInferiors;
           gcmask = GCFunction  | GCSubwindowMode;
           gc = XCreateGC(display, window, gcmask, &xgcv);

           /* Get the second corner */
           x1 = x2 = event.xbutton.x;
           y1 = y2 = event.xbutton.y;
           do
	   {
	      if (x2 < x1)
	         temp = (y2 < y1) ? cursor_ul : cursor_ll;
	      else
	         temp = (y2 < y1) ? cursor_ur : cursor_lr;

	      if (temp != cursor)
	      {
		 cursor = temp;
		 XChangeActivePointerGrab(display, mask, cursor, CurrentTime);
	      }
              xtmp = kmin(x1,x2);
              ytmp = kmin(y1,y2);
              width = kmax(x1,x2) - xtmp;
              height = kmax(y1,y2) - ytmp;

              /*
               * Draw a rubberband box around the image to let the user
               * know how to what area they are selecting.
               */
              XDrawRectangle(display, window, gc, xtmp, ytmp, width, height);
              XFlush(display);
              XNextEvent(display, &event);
              XDrawRectangle(display, window, gc, xtmp, ytmp, width, height);

              if (event.type == MotionNotify)
              {
                 x2 = event.xmotion.x;
                 y2 = event.xmotion.y;
              }
           } while(event.type != ButtonRelease);
           *workspace = window;
           *x = xtmp;  *y = ytmp;
           *w = width; *h = height;

           /*
            * Release the pointer, so that other events can occur.  This
            * should really be done after getting the image, but the image
            * routines take such a long time!
            */
           XFreeGC(display, gc);
           XUngrabPointer(display, CurrentTime);
	   XFreeCursor(display, cursor_ul); XFreeCursor(display, cursor_ll);
	   XFreeCursor(display, cursor_ur); XFreeCursor(display, cursor_lr);
	}

        /*
         * ----- get interactively specified window ----
         */
        else
        {
           if (event.xbutton.subwindow != 0)
              *workspace = event.xbutton.subwindow;
           else
              *workspace = event.xbutton.window;

           if (!decor && *workspace != root)
	      *workspace = XmuClientWindow(display, *workspace);

           /*
            * Release the pointer, so that other events can occur.  This
            * should really be done after getting the image, but the image
            * routines take such a long time!
            */
           XUngrabPointer(display, CurrentTime);
	   XFreeCursor(display, cursor);

	   XGetGeometry(display, *workspace, &root, x,y,w,h, &tmp,&tmp);
	   XTranslateCoordinates(display, *workspace, root, 0, 0, x, y, &dummy);
	   if (*x < 0)
	      *w += *x, *x = kabs(*x);
	   else if (*x+*w > root_width)
	      *w = root_width - *x, *x = 0;
	   else *x = 0;

	   if (*y < 0)
	      *h += *y, *y = kabs(*y);
	   else if (*y+*h > root_height)
	      *h = root_height - *y, *y = 0;
	   else *y = 0;
        }

        if (*w == 0 || *h == 0)
        {
	    kerror(NULL, "xvw_getimage", "Cannot create an image of zero \
width or height");
            return(FALSE);
        }
        return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_getimage - returns the image associated with
*				an object
*
*       Purpose: xvw_getimage provides a convenient way in which to create a
*		 Khoros 2.0 VIFF file from images that may be displayed using
*		 non-Khoros methods.  Images captured using getimage may be
*		 displayed with putimage (see putimage(1)), or manipulated
*		 using editimage (see editimage(1)). 
*
*		 xvw_getimage may be used in several ways:  (1) you may get
*		 a single window in its entirety from the screen, (2) you
*		 may get specified portion of the screen, regardless of the
*		 number of windows which it may include, (3) you may get
*		 a window by the window name or window id, (4) get the entire
*		 screen without prompting the user.
*
*         Input: object   - the object in which to get the screen contents
*		 subimage - a boolean which indicates whether we should
*			    get a portion or the whole window
*		 decor    - a boolean which indicates whether we should
*			    include the window decorations in the image
*        Output: image    - the output image in which to store the
*			    contents of the window
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Mark Young
*          Date: May 15, 1993 11:10
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

int xvw_getimage(
   xvobject object,
   int	    subimage,
   int	    decor,
   kobject  image)
{
	int      x, y;
	XImage   *ximage;
	XColor   *xcolors;
	Window   window;
	unsigned int w, h;
	unsigned char *data, *temp;
	Display  *display;
	Visual   *visual;
	Colormap colormap;
	XWindowAttributes attributes;


	/*
	 *  Need to get the information about what portion of the screen
	 *  to extract.
	 */
	display  = xvw_display(object);
	if (getinfo(object, subimage, decor, &window, &x, &y, &w, &h) == FALSE)
	{
	   return(FALSE);
	}
	XGetWindowAttributes(display, window, &attributes);
	visual   = attributes.visual;
	colormap = attributes.colormap;

	/*
	 *  Get the image.  This really whole thing should be more complicated
	 *  since it really should resolve getting sub-sections of subwindows,
	 *  but for now....
	 */
        ximage = XGetImage(display, window, x, y, w, h, AllPlanes, ZPixmap);

	/*
	 *
	 */
	h = visual->map_entries;
	if (visual->class == GrayScale || visual->class == StaticGray)
	   w = 1;
	else
	   w = 3;

	/*
	 *
	 */
	xcolors = (XColor *) kcalloc(h, sizeof(XColor));
	for (y = 0; y < h; y++)
	{
	    xcolors[y].pixel = y;
	    xcolors[y].flags = DoRed | DoGreen | DoBlue;
	}
	XQueryColors(display, colormap, xcolors, (int) h);

	/*
	 *  Initialize the maps and value segments to their correct
	 *  dimensions.  Need to do this before the first put data...
	 */
	if (!kpds_query_map(image))
	   kpds_create_map(image);

	kpds_set_attributes(image,
	    KPDS_MAP_SIZE, w, h, 1, 1, 1,
	    KPDS_MAP_DATA_TYPE, KUBYTE,
	    NULL);

	if (!kpds_query_value(image))
	   kpds_create_value(image);

	kpds_set_attributes(image,
	    KPDS_VALUE_SIZE, ximage->width, ximage->height, 1, 1, 1,
	    KPDS_VALUE_DATA_TYPE, KUBYTE,
	    NULL);

	/*
	 *  Create the maps of the image.  This is done by getting the map
	 *  data, then initializing it from the xcolors.  The data is then
	 *  stored into the image object.
	 */
	if ((data = kpds_get_data(image, KPDS_MAP_PLANE, NULL)) == NULL)
	{
	   kerror("design", "xvw_getimage", "Unable to get maps. \
Destroying maps.");
	   if (!kpds_query_map(image)) kpds_destroy_map(image);
	}
	else
	{
	   temp = data;
	   for (y = 0, temp = data; y < h; y++)
	   {
	       *temp++ = xcolors[y].red >> 8;
	       if (w == 3)
	       {
	          *temp++ = xcolors[y].green >> 8;
	          *temp++ = xcolors[y].blue >> 8;
	       }
	   }
	   kpds_put_data(image, KPDS_MAP_PLANE, data);
	   kfree(data);
	}

	/*
	 *  Create the value data of the image.  This is done by getting the
	 *  value data, then initializing it from the ximage data.  The data
	 *  is then stored into the image object.
	 */
	if ((data = (unsigned char *) kpds_get_data(image,
			KPDS_VALUE_PLANE, NULL)) == NULL)
	{
	   kerror("design", "xvw_getimage", "Unable to get value data. \
Destroying value data.");
	   if (!kpds_query_value(image)) kpds_destroy_value(image);
	}
	else
	{
	   temp = data;
	   for (y = 0, temp = data; y < ximage->height; y++)
	   {
	       for (x = 0; x < ximage->width; x++)
		   *temp++ = (unsigned char) XGetPixel(ximage, x, y);
	   }
	   kpds_put_data(image, KPDS_VALUE_PLANE, data);
	   kfree(data);
	}

	/*
	 *  Clean up!!
	 */
	XDestroyImage(ximage); 
	return(TRUE);
}
