 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "copyright.h"          /* Khoros copyright */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros AnnotateMenu Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		ButtonCallback()
   >>>>   Public:
   >>>>			xvw_create_annotatemenu()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <X11/IntrinsicP.h>
#include <xvisual/AnnotateMenuP.h>

static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	ButtonCallback  PROTO((xvobject, kaddr, kaddr));


struct Annotations
{
	char *name;
	char *pixmapfile;
	xvobject (*create_routine)(xvobject, char *);
};

static struct Annotations annotation_list[] = 
{
  {"Marker",    "marker.xpm",    xvw_create_marker},
  {"Line",      "line.xpm",      xvw_create_line},
  {"Circle",    "circle.xpm",    xvw_create_circle},
  {"Oval",      "oval.xpm",      xvw_create_circle},
  {"Rectangle", "rectangle.xpm", xvw_create_rectangle},
  {"Text",      "text.xpm",      xvw_create_textstring},
};

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_ANNOTATEMENU_CREATE,    NULL,   XtRCallback, NULL},
{XVW_ANNOTATEMENU_WORKSPACE, NULL,   XtRPointer,  NULL},
{XVW_ANNOTATEMENU_ITEMS,     NULL,   XtRPointer,  NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwAnnotateMenuWidgetRec, annotatemenu.field)

static XtResource resources[] = { 
{XVW_ANNOTATEMENU_CREATE, NULL, XtRCallback, sizeof(XtPointer),
      offset(menu_callback), XtRCallback, (XtPointer) NULL},
{XVW_ANNOTATEMENU_WORKSPACE, NULL, XtRPointer, sizeof(XtPointer),
      offset(workspace), XtRImmediate, (XtPointer) NULL},
{XVW_ANNOTATEMENU_ITEMS, NULL, XtRPointer, sizeof(XtPointer),
      offset(workspace), XtRImmediate, (XtPointer) NULL},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for AnnotateMenu Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwRowColWidgetClassRec)

XvwAnnotateMenuWidgetClassRec xvwAnnotateMenuWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "AnnotateMenu",			/* class_name		  */
    sizeof(XvwAnnotateMenuWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    NULL,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwAnnotateMenuWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                    /* child layout routine  */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritResize,			/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwRowColWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwAnnotateMenuWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwAnnotateMenuWidgetClass = (WidgetClass) &xvwAnnotateMenuWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwAnnotateMenuWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwAnnotateMenuWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwAnnotateMenuWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/AnnotateMenu");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial annotatemenu widget
|		 instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	xvobject parent = xvw_object(new);

	int	 i;
	xvobject button;
	char     filename[KLENGTH];


	for (i = 0; i < knumber(annotation_list); i++)
        {
	   kfullpath(annotation_list[i].pixmapfile,
		     "$DESIGN/objects/library/xvisual/misc/pixmaps", filename);

	   button = xvw_create_button(parent, annotation_list[i].name);
	   xvw_set_attributes(button,
                XVW_BUTTON_TYPE,      KBUTTON_TYPE_PIXMAP,
                XVW_PIXMAP_FILENAME,  filename,
		NULL);

	   xvw_insert_callback(button, XVW_BUTTON_SELECT, FALSE,
			ButtonCallback, parent);
        }
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwAnnotateMenuWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the error.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwAnnotateMenuWidget cxwid = kwidget(current);
	XvwAnnotateMenuWidget nxwid = kwidget(new);


	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ButtonCallback
|
|       Purpose: This routine will be called when the menu callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ButtonCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject annotatemenu = (xvobject) client_data;
	Widget   widget = xvw_widget(annotatemenu);
	XvwAnnotateMenuWidget xwid = kwidget(widget);

	int      i;
	char     *name = xvw_name(object);
	xvobject (*create)(xvobject, char *);

	for (i = 0; i < knumber(annotation_list); i++)
	{
	   if (kstrcmp(name, annotation_list[i].name) == 0)
	   {
	      if (!(create = annotation_list[i].create_routine))
	         continue;

	      XtCallCallbacks(widget, XVW_ANNOTATEMENU_CREATE, name);
	      object = (xvobject) create(xwid->annotatemenu.workspace, name);
	      return;
	   }
	}
}


/************************************************************
*
*  Routine Name: xvw_create_annotatemenu - create a toolbox menu object
*
*       Purpose: An annotatemenu object consists of a backplane containing
*                a vertical display of pixmaps, where each pixmap represents
*                a type of annotation that can be created using the 
*                annotatemenu.  Items that can be represented & created
*		 using the annotatemenu include markers, lines, circles,
*                ovals, rectangles and text annotations.  
*
*                For example, the user could click on the pixmap of the 
*                annotatemenu object that shows a picture of a line in order 
*                to create a line annotation on a canvas.
*
*                The types of annotations that are supported by a particular 
*                annotatemenu object are controlled through the use of a mask; 
*                thus, the annotatemenu object may be used to offer creation of
*                all or only some of the supported annotation types.
*
*                An annotatemenu object only provides a mechanism with which
*                the user can indicate the desire to create a particular 
*                annotation;  it does not offer a backplane on which the
*                annotation can actually be created.  Because of this,
*                the annotatemenu object must be used in conjunction with a 
*                canvas object or workspace object on which the annotations
*                are created. In most cases, the same backplane is used to 
*                create both the annotatemenu object and the workspace.  
*
*                The actual creation of the annotations may be handled in one
*                of two ways.  After creation of both the annotatemenu object
*                and the object that is to serve as the workspace, the 
*                application may then associate the workspace with the 
*                annotatemenu object explicitly using an attribute created 
*                specifically for that purpose.  Once the canvas is associated 
*                with the annotatemenu object, all annotations specified by 
*                the user with the annotatemenu object are automatically on 
*                the associated canvas.  If the application needs to handle
*                annotation creation directly, a callback can be installed
*                on the annotatemenu object which will be fired when the user
*                employs the annotatemenu to request creation of a new 
*                annotation.  In this case, the application is expected to
*                handle creation of the annotation within the callback.
*    
*                
*         Input: parent - parent of the annotatemenu widget
*                name   - name to reference annotatemenu widget
*        Output:
*
*       Returns: the annotatemenu widget
*  Restrictions:
*    Written By: Mark Young
*          Date: Jul 02, 1994
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_annotatemenu(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, AnnotateMenuWidgetClass);
	return(object);
}
