/*
 * Khoros: $Id$
 */

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: All local #defines and structures for
   >>>>		       Khoros 3D Graphics Utilities --
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 15:12
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvgraphics_internals_h_
#define _xvgraphics_internals_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <design.h>
#include <xvinclude.h>
#include <xvgraphics/xvgraphics.h>
#include <xvisual/Plot3D.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define X2D_CENTER	(0)
#define X2D_LEFT	(1 << 0)
#define X2D_RIGHT	(1 << 1)
#define X2D_TOP		(1 << 2)
#define X2D_BOTTOM	(1 << 3)

#define X3D_CENTER	(0)
#define X3D_LEFT	(1 << 0)
#define X3D_RIGHT	(1 << 1)
#define X3D_TOP		(1 << 2)
#define X3D_BOTTOM	(1 << 3)
#define X3D_FRONT	(1 << 4)
#define X3D_BACK	(1 << 5)

#define BACKLEFT	1
#define BACKRIGHT	2
#define FRONTLEFT	3
#define FRONTRIGHT	4

#define NORM_NONE	0
#define NORM_ABSOLUTE	1
#define NORM_TRUNCATE	2


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

/*
 * The X3DGraphics structure contains all information needed to
 * map world coordinate values of an image or plot to the device 
 * coordinate values actually displayed on the graphics workstation.
 */
typedef  struct
{
   int   id,		/* Identifies this X3D graphics structure */
	 win_type,	/* Tells if the graphics window is 2D or 3D */
	 line_type,	/* Tells line type */
	 line_width,	/* Tells line width */
	 projection,	/* Type of projection */
	 clipping,	/* on or off for clipping */
	 depth_clipping, /* on or off for back or depth clipping */
	 device;	/* type of ouput device (X,postscr,news,...) */

   Coord camera;	/* camera representing the world coordinate
			   position or COP */
   Coord focus;		/* focus point representing the world coordinate
			   focus position or VPN */
   Coord up;		/* up point representing the world coordinate
			   Up refrence point or URP */
   Real  alpha,		/* Angle of the FOCUS-CAMERA vector from the x-axis */
	 theta,		/* Angle of the FOCUS-CAMERA vector from the y-axis */
	 gamma,		/* Angle of the FOCUS-CAMERA vector from the z-axis */
	 eye_dist,	/* Distance of the eye from the object in world
			   coordinates */
         view_dist;     /* Distance from the camera to the focus point
			   for the view plane */

   Matrix    matrix, 	/* Final 3D output matrix in DC values */
	     imatrix,   /* Inverse matrix from normalize to WC */
	     matrix1, matrix2;
   Matrix_2D matrix2D;	/* Final 2D output matrix in DC values */

   int   resize_view;
   Real  xv_min, xv_max, /* X viewport min and max */
	 yv_min, yv_max, /* Y viewport min and max */
	 zv_min, zv_max; /* Y viewport min and max */

   Coord wc_min, wc_max;   /* World Coordinate min and max vectors
			      according to the scale type, used to
			      clip against */
   Coord scale;		   /* Scale type wc space (ie LINEAR, LOG10,
			      LN, ...).				  */
   int   corner;


   int	    orientation,
	    justify;	  /* Text string justification */
   Real	    spacing,	  /* Character spacing */
	    aspect;

   /* lighting for normal shading */
   int ncode;		  /* should normals be ABS or TRUNCATED or */
			  /* alone.				   */
   int specular;	  /* specular reflection coefficent	   */
   int ambient;		  /* ambient lighting coefficent	   */

   /**  X11 Dependencies  **/
   Display   *display;
   Drawable  workspace;

   Widget    widget;
   unsigned  long fg, bg;

   GC	   gc_draw, gc_fill;  /* GC's to draw and fill with */
   short X11_xmin, X11_xmax,  /* X device coordinate min and max */
	 X11_ymin, X11_ymax;  /* Y device coordinate min and max */

}  X3DGraphics;


typedef struct _X3DList
{
   int          	id;
   X3DGraphics		*graphics;
   struct _X3DList      *next, *prev;
}  X3DList;


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

extern int   dash_len[];
extern char  *dash_type[];
extern float *line_widths[];

	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/*	
 *  Multiply the vector by the matrix for 2D & 3D.
 */
#define _X2D_vector_mult(coord, m, xout, yout, wout)			      \
{									      \
	xout = coord.x*m[0][0] + coord.y*m[1][0] + m[2][0];		      \
	yout = coord.x*m[0][1] + coord.y*m[1][1] + m[2][1];		      \
	wout = coord.x*m[0][2] + coord.y*m[1][2] + m[2][2];		      \
}

#define _X3D_vector_mult(coord, m, xout, yout, zout, wout)		      \
{									      \
	xout = coord.x*m[0][0] + coord.y*m[1][0] + coord.z*m[2][0] + m[3][0]; \
	yout = coord.x*m[0][1] + coord.y*m[1][1] + coord.z*m[2][1] + m[3][1]; \
	zout = coord.x*m[0][2] + coord.y*m[1][2] + coord.z*m[2][2] + m[3][2]; \
	wout = coord.x*m[0][3] + coord.y*m[1][3] + coord.z*m[2][3] + m[3][3]; \
}


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/
/* bezier.c */
void _X3D_draw_patch PROTO((X3DGraphics *, Coord, Coord, Coord, Coord, int));
void _X3D_fill_patch PROTO((X3DGraphics *, Coord *, int, Real *, XColor *, int, Coord, Coord));


/* check.c */
int X3D_check_graphics PROTO((int));

/* clip_2D.c */
int clip_segment_2D PROTO((X3DGraphics *, int, int, register Real, register Real, register Real, register Real, Coord *, Coord *));
Coord *_X2D_clip_points PROTO((X3DGraphics *, Coord *, int, int, int *));
Coord *_X2D_clip_segments PROTO((X3DGraphics *, Coord *, int, int *));
Coord *_X2D_clip_lines PROTO((X3DGraphics *, Coord *, int, int *));
Coord *_X2D_clip_polygon PROTO((X3DGraphics *, Coord *, int, int *));
Coord *_X2D_clip_rectangles PROTO((X3DGraphics *, Coord *, int, int *));

/* clip_3D.c */
Coord *_X3D_clip_points PROTO((X3DGraphics *, Coord *, int, int, Coord *, int *));
Coord *_X3D_clip_segments PROTO((X3DGraphics *, Coord *, int, Coord *, int *));
Coord *_X3D_clip_lines PROTO((X3DGraphics *, Coord *, int, Coord *, int *));
Coord *_X3D_clip_polygon PROTO((X3DGraphics *, Coord *, int, Coord *, int *));
Coord *_X3D_clip_rectangles PROTO((X3DGraphics *, Coord *, int, Coord *, int *));

/* convert_2D.c */
int _X2D_convert_wc_to_dc PROTO((X3DGraphics *, Coord *, XPoint *, int));
int _X2D_convert_wc_to_dc_seg PROTO((X3DGraphics *, Coord *, XSegment *, int));
int _X2D_convert_wc_coord_to_dc_seg PROTO((X3DGraphics *, Coord *, XSegment *, int));
int X2D_convert_point_wc_to_dc PROTO((int, Coord, Real *, Real *));
int X2D_convert_point_dc_to_wc PROTO((int, Real, Real, Coord *));

/* convert_3D.c */
int _X3D_convert_wc_to_dc PROTO((X3DGraphics *, Matrix, Coord *, XPoint *, int));
int _X3D_convert_wc_to_dc_seg PROTO((X3DGraphics *, Matrix, Coord *, XSegment *, int));
int X3D_convert_point_wc_to_dc PROTO((int, Coord, Real *, Real *));
int X3D_convert_point_wc_to_ndc PROTO((int, Coord, Coord *));

/* draw_util.c */
int _X3D_find_color PROTO((register int, register XColor *, int, int));
int _X3D_find_corner PROTO((X3DGraphics *, Coord *, Coord *, Coord *, Coord *));
int _X3D_find_level PROTO((Real, Real *, int));
void _X2D_draw_markers PROTO((int, XPoint *, int, int));

/* error.c */
void X3D_signal_handler PROTO((int));

/* graphics_2D.c */
void _X2D_update_graphics PROTO((X3DGraphics *));

/* graphics_3D.c */
X3DGraphics *_X3D_get_graphics PROTO((int));
void _X3D_update_graphics PROTO((X3DGraphics *));

/* matrix_2D.c */
void _X2D_clear_matrix PROTO((Matrix_2D));
void _X2D_matrix_set_identity PROTO((Matrix_2D));
void _X2D_matrix_mult PROTO((Matrix_2D, Matrix_2D, Matrix_2D));
void _X2D_matrix_set_ndc PROTO((Coord, Real, Real, Real, Real, Coord, Coord, Matrix_2D));
void _X2D_write_matrix PROTO((Matrix_2D));
void _X2D_matrix_set_dc PROTO((X3DGraphics *, Matrix_2D));

/* matrix_3D.c */
void _X3D_matrix_mult PROTO((Matrix, Matrix, Matrix));
void _X3D_clear_matrix PROTO((Matrix));
void _X3D_matrix_set_identity PROTO((Matrix));
void _X3D_matrix_set_viewing PROTO((Coord, Coord, Coord, Matrix));
void _X3D_matrix_set_viewing2 PROTO((Coord, Coord, Real, Matrix));
void _X3D_matrix_set_oldviewing PROTO((Real, Real, Real, Matrix));
void _X3D_matrix_set_inviewing PROTO((Coord, Coord, Coord, Matrix));
void _X3D_matrix_set_parallel PROTO((int, Matrix));
void _X3D_matrix_set_perspective PROTO((Real, Matrix));
void _X3D_matrix_set_ndc PROTO((Coord, Coord, Coord, Matrix));
void _X3D_matrix_set_invndc PROTO((Coord, Coord, Coord, Matrix));
void _X3D_write_matrix PROTO((Matrix));
void _X3D_matrix_set_dc PROTO((X3DGraphics *, Matrix));

/* scale_2D.c */
int _X2D_scale_wc_coords PROTO((Coord, Coord *, Coord **, int));
int _X2D_scale_wc_coord PROTO((Coord, Coord, Coord *));

/* scale_3D.c */
int _X3D_scale_wc_coords  PROTO((Coord, Coord *, Coord **, int));
int _X3D_scale_wc_coord   PROTO((Coord, Coord, Coord *));
Real _X3D_get_scale_value  PROTO((int, Real));

/* utils_3D.c */
void _X3D_compute_normal PROTO((X3DGraphics *, Coord *, Coord *, Coord *, Coord *));
Real _X3D_normal PROTO((X3DGraphics *, Coord *, Coord *, Coord *));
Real _X3D_vertex_normal PROTO((X3DGraphics *, Coord *, register int, register int, register int, register int));

#endif /* _xvgraphics_internals_h_ */
/* Don't add after this point */
