/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>            GUI Destruction Routines                   <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>              xvf_destroy_subform()                    <<<<
   >>>>              xvf_destroy_control()                    <<<<
   >>>>              xvf_destroy_selection()                  <<<<
   >>>>   Public:                                             <<<<
   >>>>              xvf_destroy_allforms()                    <<<<
   >>>>              xvf_destroy_form()                       <<<<
   >>>>              xvf_destroy_subform()                    <<<<
   >>>>   Static:                                             <<<<
   >>>>              xvf_destroy_sel_list()                   <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


static void xvf_destroy_sel_list           PROTO((kselection *));


/************************************************************
*
*  Routine Name: xvf_destroy_allforms - destroy all forms
*
*       Purpose: destroys all current forms
*         Input:
*        Output:
*       Returns:
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 18, 1993
*      Verified:
*  Side Effects:
* Modifications:
*************************************************************/

void xvf_destroy_allforms(void)
{
	int        i, num;
	kform_list *entry;
	xvobject   *children;


	entry = kvf_get_entry(NULL);
	while (entry != NULL)
	{
	   if (entry->type == KFORM)
	   {
	      xvf_destroy_form((kform *) entry->treeptr);
	      entry = kvf_get_entry(NULL);
	   }
	   else
	      entry = entry->next;

	}

	children = xvw_children(NULL, ApplicationShellClass, &num);
	for (i = 0; i < num; i++)
	   xvw_destroy(children[i]);
	kfree(children);

	children = xvw_children(NULL, TransientShellClass, &num);
	for (i = 0; i < num; i++)
	   xvw_destroy(children[i]);
	kfree(children);
}


/************************************************************
*
*  Routine Name: xvf_destroy_form - destroy GUI of xvroutine & free associated memory
*
*       Purpose: Destroys all GUI objects associated with a particular 
*                form tree and the form tree itself. 
*
*         Input: form - pointer to the form tree being destroyed
*        Output:
*       Returns:
*  Restrictions:
*    Written By: Danielle Argiro
*          Date: March 29, 1993
*      Verified:
*  Side Effects:
* Modifications:
*************************************************************/

void xvf_destroy_form(
    kform *form)
{
	ksubform *subform;

        if (form == NULL) return;
	if (form->master != NULL)
        {
            subform = form->master->subform_list;
            while (subform != NULL)
	    {
                xvf_destroy_subform(subform);
		subform = subform->next;
	    }
            if (xvw_activated_menu(form->master->back))
                xvw_inactivate_menu(form->master->back);
            xvf_destroy_control(form->master);
        }
        else if (form->subform != NULL)
	     xvf_destroy_subform(form->subform);

	if (form->toplevel != NULL)
              xvw_destroy(form->toplevel);

	kvf_destroy_form(form);
}

/*************************************************************
*
*  Routine Name: xvf_destroy_subform - destroy subform & free associated memory
*
*       Purpose: destroys all xvobjects associated with the subform tree 
*                and the subform tree itself.
*
*         Input: subform - the subform pointer
*        Output:
*       Returns:
*    Written By: Danielle Argiro and Mark Young
*          Date: May 6, 1992
*      Verified:
*  Side Effects:
* Modifications:
*
**************************************************************/

void xvf_destroy_subform(
   ksubform *subform)
{
        kguide *guide;

        if (subform == NULL) return;

        if (subform->guidepane != NULL)
        {
            guide = subform->guidepane->guide_list;
            while (guide != NULL)
	    {
		if (guide->pane != NULL)
                    xvf_destroy_control(guide->pane);
		guide = guide->next;
	    }
            xvf_destroy_control(subform->guidepane);

        }
	else if ((subform->guide != NULL) &&
                 (subform->guide->pane != NULL))
            xvf_destroy_control(subform->guide->pane);

        if (xvw_activated_menu(subform->back))
            xvw_inactivate_menu(subform->back);

        if (subform->toplevel != NULL)
              xvw_destroy(subform->toplevel);

}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_destroy_control
|
|       Purpose: destroys the structure associated with a master,
|                guidepane, or pane.
|         Input: control - the pointer to control panel structure
|        Output: none
|          Date: May 7, 1992
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/

void xvf_destroy_control(
   kcontrol *control)
{
        if (control->sel_list != NULL)
           xvf_destroy_sel_list(control->sel_list);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_destroy_sel_list
|
|       Purpose: destroys a selection list
|         Input: selection - the header of the selection list
|        Output: none
|          Date: May 7, 1992
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/

static void xvf_destroy_sel_list(
   kselection *sel_list)
{
	kselection *selection = sel_list;
        while (selection != NULL)
	{
            xvf_destroy_selection(selection);
	    selection = selection->next;
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_destroy_selection
|
|       Purpose: destroys a selection
|         Input: selection - the selection to be destroyed
|        Output: none
|          Date: May 7, 1992
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
void xvf_destroy_selection(
   kselection *selection)
{
        kselection   *toggle, *group;

        toggle = selection->toggle_next;
        while (toggle != NULL)
	{
            xvf_destroy_selection(toggle);
	    toggle = toggle->next;
	}

        group = selection->group_next;
        while (group != NULL)
	{
            xvf_destroy_selection(group);
	    group = group->next;
	}
	
        if (selection->back != NULL)
        {
	    /* submenu selection; destroy menubutton (label object) */ 
	    if (selection->type == KUIS_STARTSUBMENU) 
		xvw_destroy(selection->label_object);

	    /* 
	     * regular selection; just destroy backplane => as long as it's 
             * not _on_ a submenu, in which case it'll be destroyed above
	     */
	    else if (selection->back_submenu == NULL)
	    {
                if (xvw_activated_menu(selection->back))
                    xvw_inactivate_menu(selection->back);
		xvw_destroy(selection->back);
	    }
        }
	selection->back = NULL;
}

