/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	        Attribute Actions For Strings & Files         <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>	     		xvf_get_file_name()		      <<<<
   >>>>	     		xvf_set_file_name()		      <<<<
   >>>>	     		xvf_get_file_check()		      <<<<
   >>>>	     		xvf_set_file_check()		      <<<<
   >>>>	     		xvf_get_file_def()		      <<<<
   >>>>	     		xvf_set_file_def()		      <<<<
   >>>>	     		xvf_get_string_val()		      <<<<
   >>>>	     		xvf_set_string_val()		      <<<<
   >>>>	     		xvf_get_string_def()		      <<<<
   >>>>	     		xvf_set_string_def()		      <<<<
   >>>>	     		xvf_get_string_multiline()	      <<<<
   >>>>	     		xvf_set_string_multiline()	      <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"
#include "attributes.h"


/*-----------------------------------------------------------
|
|       Routine: xvf_get_file_name
|       Purpose: Gets the value of the "filename" field for a selection
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_FILE_NAME ("xvf_file_name")
|        Output: calldata    - passes back value of filename
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_file_name(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	return (kvf_get_file_name(kformstruct, KVF_FILE_NAME, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_file_name
|       Purpose: Sets the "filename" field of the selection
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_FILE_NAME ("xvf_file_name")
|                calldata    - provides string value of filename
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
-------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_file_name(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	char         **filename;

	if (!(kvf_set_file_name(kformstruct, KVF_FILE_NAME, calldata)))
	    return(FALSE);

	/* the value to which XVF_FILE_NAME is to be set */
        filename  = (char **) calldata;

        if (kformstruct->type == KSELECTION)
        {
	    if (kformstruct->Selptr->value_object != NULL)
                xvw_set_attribute(kformstruct->Selptr->value_object,
                                  XVW_TEXT_STRING, *filename);
        }

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_get_file_check
|
|        Purpos: Gets the value of the "filecheck" field for a selection.

|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_FILE_CHECK ("xvf_file_check")
|        Output: calldata    - passes back value of file check boolean
|
|          Date: November 29, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_file_check(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	return (kvf_get_file_check(kformstruct, KVF_FILE_CHECK, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_file_check
|       Purpose: Sets the "filecheck" field of the selection,
|                This routine was written specially for xvlang,
|                in cases where cantata is dealing with operators
|                that use basenames for files with predefined extensions,
|                and do their own file checking;  it can be used
|                to suppress file checking (set file_check = 0).
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_FILE_CHECK ("xvf_file_check")
|                calldata    - provides boolean value of file check
|        Output: none
|
|          Date: November 29, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
-------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_file_check(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_set_file_check(kformstruct, KVF_FILE_CHECK, calldata)))
	    return(FALSE);

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_get_file_def
|       Purpose: Gets the value of the "file_def" field for a 
|                file selection.
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_FILE_DEF ("xvf_file_def")
|        Output: calldata    - passes back default filename 
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_file_def(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	return (kvf_get_file_def(kformstruct, KVF_FILE_DEF, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_file_def
|       Purpose: Sets the "file_def" field of the selection
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_FILE_DEF ("xvf_file_def")
|                calldata    - provides default filename of file selection
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
-------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_file_def(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_set_file_def(kformstruct, KVF_FILE_DEF, calldata)))
	    return(FALSE);

	if (!(xvf_set_file_name(kformstruct, KVF_FILE_NAME, calldata)))
            return(FALSE);

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}
/*-----------------------------------------------------------
|
|       Routine: xvf_get_string_val
|       Purpose: Gets the value of the "string_val" field for a 
|                string selection.
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_STRING_VAL ("xvf_string_val")
|        Output: calldata    - passes back value of string selection
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_string_val(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	return (kvf_get_string_val(kformstruct, KVF_STRING_VAL, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_string_val
|       Purpose: Sets the "filename" field of the selection
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_STRING_VAL ("xvf_string_val")
|                calldata    - provides string value of string selection
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
-------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_string_val(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(xvf_set_literal(kformstruct, XVF_LITERAL, calldata)))
            return(FALSE);

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_get_string_def
|       Purpose: Gets the value of the "string_def" field for a 
|                string selection.
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_STRING_DEF ("xvf_string_def")
|        Output: calldata    - passes back default of string selection
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_string_def(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	return (kvf_get_string_def(kformstruct, KVF_STRING_DEF, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_string_def
|       Purpose: Sets the "string_def" field of the selection
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_STRING_DEF ("xvf_string_def")
|                calldata    - provides default string of string selection
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
-------------------------------------------------------------*/
/* ARGSUSED */
int xvf_set_string_def(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	if (!(kvf_set_string_def(kformstruct, KVF_STRING_DEF, calldata)))
	    return(FALSE);

	if (!(xvf_set_string_val(kformstruct, KVF_FILE_NAME, calldata)))
            return(FALSE);

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|       Routine: xvf_get_string_multiline
|       Purpose: Gets the implied value of the "multiline" attribute
|                as determined by the height of a string selection.
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_STRING_MULTILINE ("xvf_string_multiline")
|        Output: calldata    - passes back TRUE for multiline, FALSE otherwise.
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
int xvf_get_string_multiline(
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	return (kvf_get_string_multiline(kformstruct, KVF_STRING_MULTILINE, calldata));
}

/*-----------------------------------------------------------
|
|       Routine: xvf_set_string_multiline
|       Purpose: Sets the implied value of the "multiline" attribute
|                and sets the height of the string selection accordingly.
|
|         Input: kformstruct - generic kformstruct holding ptr to selection
|                attribute   - XVF_STRING_MULTILINE ("xvf_string_multiline")
|                calldata    - provides default string of string selection
|        Output: none
|
|          Date: March 22, 1994
|    Written By: Danielle Argiro 
| Modifications:
|
-------------------------------------------------------------*/ 
/* ARGSUSED */ 
int xvf_set_string_multiline( 
   kform_struct *kformstruct,
   char         *attribute,
   kaddr        calldata)
{
	int          *multiline;
 	kselection   *selection;
	float        height;

        /* the value to which KVF_MULTILINE is to be set */
        multiline = (int *) calldata;

	if (!(kvf_set_string_multiline(kformstruct, KVF_STRING_MULTILINE, calldata)))
	    return(FALSE);

	selection = kformstruct->Selptr;
        if (*multiline)
	{
	    xvw_set_attribute(selection->value_object, 
			      XVW_TEXT_MULTILINE, TRUE);
	    xvw_set_attribute(selection->back, 
			      XVW_CHAR_MAX_HEIGHT, 100.0);
	    xvf_get_attribute(kformstruct, XVF_HEIGHT, &height);
	    if (height < 2)
	    {
	        xvw_set_attribute(selection->back, 
		 	          XVW_CHAR_HEIGHT, 5.0);
	        xvf_set_attribute(kformstruct, XVF_HEIGHT, 5.0);
	    }
	}
        else 
	{
	    xvw_set_attribute(selection->value_object, 
			      XVW_TEXT_MULTILINE, FALSE);
	    xvw_set_attribute(selection->back, 
			      XVW_CHAR_HEIGHT, 1.0);
	    xvw_set_attribute(selection->back, 
			      XVW_CHAR_MAX_HEIGHT, 1.0);
	}

	if (kformstruct->callback_list != NULL)
	    xvf_call_gui_callbacks(kformstruct, attribute, calldata);

	return(TRUE);
}
