 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>       	       Olit xvobject Creation		      <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                xvw_create_menubutton()		      <<<<
   >>>>                xvw_create_button()		      <<<<
   >>>>                xvw_create_label()		      <<<<
   >>>>                xvw_create_scrollbar() 	              <<<<
   >>>>                xvw_create_list() 	              <<<<
   >>>>                xvw_create_text()	 	      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#include "internals.h"

#ifdef KOLIT_DEF

klist *xvw_menuwidget_list = NULL;

static void text_focus PROTO((xvobject, kaddr, XEvent *));

/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_menubutton
|
|       Purpose: Creates a compound menubutton object
|                using the OLIT Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference menubutton
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & Mark Young
|          Date: July 16, 1992
| Modifications:
|
------------------------------------------------------------*/

static xvattribute menu_attributes[] = {
{XVW_LABEL,           XtNlabel,    XtRString, NULL},
};

xvobject xvw_create_menubutton(
   xvobject parent,
   char   *name)
{
	int    i;
	Arg    arg[MAX_ARGS];
	Widget menubutton;
	Widget menu;
	klist  *menuwidget_list;

	static int initialized = FALSE;

	i = 0;
        XtSetArg(arg[i], XtNmappedWhenManaged, TRUE);   	 	  i++;
	XtSetArg(arg[i], XtNpushpin, OL_OUT);			 	  i++;
	XtSetArg(arg[i], XtNpushpinDefault, TRUE);		 	  i++;
	menubutton = XtCreateManagedWidget(name, menuButtonWidgetClass, 
			      		xvw_widget(parent), arg, i);

	i = 0;
	XtSetArg(arg[i], XtNmenuPane, &menu);		i++;
	XtGetValues(menubutton, arg, i);


	menuwidget_list = klist_locate(xvw_menuwidget_list, 
				       xvw_object(menubutton));
	if (menuwidget_list != NULL)
           menuwidget_list->client_data = (kaddr) (xvw_object(menu));
        else xvw_menuwidget_list = klist_add(xvw_menuwidget_list, 
					     xvw_object(menubutton), 
					     xvw_object(menu));

	if (!initialized)
	{
	   initialized = TRUE;
	   xvw_init_attributes(XtClass(menubutton), menu_attributes,
		            knumber(menu_attributes), NULL, 0, NULL);
           xvw_define_attributes(XtClass(menubutton),
             XVW_BUTTON_TYPE,  XtRInt, xvw_set_misc,        xvw_get_misc,
             NULL);

	   xvw_init_attributes(XtClass(menu), menu_attributes,
			    knumber(menu_attributes), NULL, 0, NULL);
	}
	return(xvw_object(menubutton));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_button
|
|       Purpose: Creates a button object using the OLIT Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference button
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & Mark Young
|          Date: July 16, 1992
| Modifications:
|
------------------------------------------------------------*/

static xvattribute button_attributes[] = {
{XVW_LABEL,           XtNlabel,        XtRString,   NULL},
{XVW_PIXMAP,          XtNlabelImage,   XtRPixmap,   XtRXImage},
{XVW_PIXMAP_FILENAME, XtNlabelImage,   XtRFilename, XtRXImage},
};

xvobject xvw_create_button(
   xvobject parent,
   char   *name)
{
	int i;
	Arg arg[MAX_ARGS];
	Widget button;

	static int initialized = FALSE;

	/*
	 *  Check to see if the parent is a menuPane.  If not then create
	 *  the button initially as a rectButtonWidgetClass.  If so then
	 *  create it as a oblongButtonWidgetClass since it will mostly
	 *  likely be recreated as such.
	 */
	if (kstrcmp(xvw_name(parent), "pane") != 0)
	{
	   i = 0;
           XtSetArg(arg[i], XtNmappedWhenManaged, TRUE);   		 i++;
	   XtSetArg(arg[i], XtNset, FALSE);				 i++; 
	   XtSetArg(arg[i], XtNlabelJustify,  OL_CENTER);		 i++; 
	   XtSetArg(arg[i], XtNlabel,  NULL);				 i++; 
	   button = XtCreateManagedWidget(name, rectButtonWidgetClass, 
				       xvw_widget(parent), arg, i);
	}
	else
	{
	   i = 0;
           XtSetArg(arg[i], XtNmappedWhenManaged, TRUE);   		 i++;
	   XtSetArg(arg[i], XtNset, FALSE);				 i++; 
	   XtSetArg(arg[i], XtNlabelJustify,  OL_LEFT);			 i++; 
	   XtSetArg(arg[i], XtNlabel,  NULL);				 i++; 
	   button = XtCreateManagedWidget(name, oblongButtonWidgetClass, 
				       xvw_widget(parent), arg, i);
	}

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(rectButtonWidgetClass, button_attributes,
	      knumber(button_attributes), NULL, 0, NULL);
	   xvw_init_attributes(oblongButtonWidgetClass, button_attributes,
	      knumber(button_attributes), NULL, 0, NULL);
	   xvw_define_callback(XVW_BUTTON_SELECT,XtNselect,xvw_update_button);
	   xvw_define_callback(XVW_BUTTON_SELECT,XtNunselect,xvw_update_button);

	   xvw_define_attributes(rectButtonWidgetClass,
	     XVW_BUTTON_SHAPE, XtRInt, xvw_set_buttonshape, xvw_get_buttonshape,
             XVW_BUTTON_TYPE,  XtRInt, xvw_set_misc,        xvw_get_misc,
             XVW_LABEL_JUSTIFY,   XtRInt, xvw_set_misc,        xvw_get_misc,
             XVW_PIXMAP_JUSTIFY,  XtRInt, xvw_set_misc,        xvw_get_misc,
	     NULL);
	   xvw_define_attributes(oblongButtonWidgetClass,
	     XVW_BUTTON_SHAPE, XtRInt, xvw_set_buttonshape, xvw_get_buttonshape,
             XVW_BUTTON_TYPE,  XtRInt, xvw_set_misc,        xvw_get_misc,
	     NULL);
	}
	return(xvw_object(button));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_label
|
|       Purpose: Creates a label object using the OLIT Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference label
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & Mark Young
|          Date: July 29, 1992
| Modifications:
|
------------------------------------------------------------*/

static xvattribute label_attributes[] = {
{XVW_LABEL,           XtNstring,  XtRString,   NULL},
{XVW_PIXMAP,          XtNpixmap,  XtRPixmap,   NULL},
{XVW_PIXMAP_FILENAME, XtNpixmap,  XtRFilename, XtRPixmap}, 
};

xvobject xvw_create_label(
   xvobject parent,
   char   *name)
{
	int     i;
	Arg     arg[MAX_ARGS];
	Widget  label;

	static int initialized = FALSE;

	i = 0;
	XtSetArg(arg[i], XtNstring, NULL); 	    			i++;
	XtSetArg(arg[i], XtNborderWidth, 0);                   	    	i++;
	XtSetArg(arg[i], XtNalignment, OL_LEFT);                    	i++;
	XtSetArg(arg[i], XtNstrip, FALSE);	                    	i++;
	label = XtCreateManagedWidget(name, staticTextWidgetClass,
				      xvw_widget(parent), arg, i);

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(staticTextWidgetClass, label_attributes,
		knumber(label_attributes), NULL, 0, NULL);
	   xvw_init_attributes(pixmapWidgetClass, label_attributes,
		knumber(label_attributes), NULL, 0, NULL);

	   xvw_define_attributes(staticTextWidgetClass, 
		XVW_LABEL_TYPE,    XtRInt, xvw_set_labeltype, xvw_get_labeltype,
	        XVW_LABEL_JUSTIFY, XtRInt, xvw_set_misc,      xvw_get_misc,
	        XVW_PIXMAP_JUSTIFY,XtRInt, xvw_set_misc,      xvw_get_misc,
		NULL);
	   xvw_define_attributes(pixmapWidgetClass, 
		XVW_LABEL_TYPE,    XtRInt, xvw_set_labeltype, xvw_get_labeltype,
	        XVW_LABEL_JUSTIFY, XtRInt, xvw_set_misc,      xvw_get_misc,
	        XVW_PIXMAP_JUSTIFY,XtRInt, xvw_set_misc,      xvw_get_misc,
		NULL);
	}
	return(xvw_object(label));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_scrollbar
|
|       Purpose: Creates a scrollbar using the OLIT Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference scrollbar
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & Mark Young
|          Date: July 30, 1992
| Modifications:
|
------------------------------------------------------------*/

xvobject xvw_create_scrollbar(
   xvobject parent,
   char   *name)
{
	int     i;
	Arg     arg[MAX_ARGS];
	Widget  scroll;

	static int initialized = FALSE;

	i = 0;
	XtSetArg(arg[i], XtNproportionLength, 1);		i++;
	XtSetArg(arg[i], XtNorientation, OL_HORIZONTAL);	i++;
	scroll = XtCreateManagedWidget(name, scrollbarWidgetClass,
			      xvw_widget(parent), arg, i);

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(XtClass(scroll), NULL, 0, NULL, 0, NULL);
	   xvw_define_callback(XVW_SCROLL_CONT_MOTION, XtNsliderMoved,
			       xvw_update_scroll_value);
	   xvw_define_callback(XVW_SCROLL_INCR_MOTION, NULL,
			       xvw_update_scroll_value);
	   xvw_define_attributes(XtClass(scroll),
	      XVW_SCROLL_MIN,   XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	      XVW_SCROLL_MAX,   XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	      XVW_SCROLL_VALUE, XtRDouble, xvw_set_scrollbar,xvw_get_scrollbar,
	      XVW_SCROLL_INCR,  XtRDouble, xvw_set_scrollbar, xvw_get_scrollbar,
	      XVW_ORIENTATION,  XtRInt,   xvw_set_orientation, NULL,
	      NULL);
	}
	return(xvw_object(scroll));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_list
|
|       Purpose: Creates a compound list object using the OLIT Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference list
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & Mark Young
|          Date: August 2, 1992
| Modifications:
|
------------------------------------------------------------*/

xvobject xvw_create_list(
   xvobject parent,
   char   *name)
{
	int i;
	Widget list;
	Arg arg[MAX_ARGS];

	static int initialized = FALSE;

	i = 0;
        XtSetArg(arg[i], XtNviewHeight, 6);			 	i++;
        XtSetArg(arg[i], XtNselectable, TRUE);			 	i++;
        XtSetArg(arg[i], XtNmappedWhenManaged, TRUE);   		i++;
        XtSetArg(arg[i], XtNuserData, NULL);		   		i++;
        XtSetArg(arg[i], XtNtraversalOn, FALSE);	   		i++;
	list = XtCreateManagedWidget(name, scrollingListWidgetClass,
				     xvw_widget(parent), arg, i);


	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(XtClass(list), NULL, 0, NULL, 0, NULL);
	   xvw_define_callback(XVW_LIST_ITEM_SELECT, XtNuserMakeCurrent,
		xvw_update_list_struct);
	   xvw_define_callback(XVW_LIST_ITEM_ACTION, XtNuserMakeCurrent,
		xvw_update_list_struct);
	   xvw_define_attributes(XtClass(list), 
	       XVW_LIST_SIZE, XtRInt, xvw_set_list_num, xvw_get_list_num,
	       XVW_LIST_HIGHLT_ELEM, XtRInt, xvw_set_list_highlight,   
					    xvw_get_list_highlight,
	       XVW_LIST_UNHIGHLT_ELEM, XtRInt, xvw_set_list_unhighlight, NULL,
	       NULL);
	}
	return(xvw_object(list));
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_create_text
|
|       Purpose: Creates a text object using the OLIT Widget set.
|
|         Input: parent - the parent xvobject
|                name   - name with which to reference text object
|        Output: none
|       Returns: none
|    Written By: Danielle Argiro & Mark Young
|          Date: August 12, 1992
| Modifications:
|
------------------------------------------------------------*/

static xvattribute text_attributes[] = {
{XVW_TEXT_INSERT_POS,   XtNcursorPosition, XtRInt,              NULL},
{XVW_TEXT_LENGTH,       XtNlength,         XtRInt,              NULL},
{XVW_TEXT_LEFT_MARGIN,  XtNleftMargin,     XtRDimension,        NULL},
};

xvobject xvw_create_text(
   xvobject parent,
   char   *name)
{
	int     i;
	Arg     arg[MAX_ARGS];
	Widget  text;

	static int initialized = FALSE;

        i = 0;
        XtSetArg(arg[i], XtNmappedWhenManaged, TRUE);   		i++;
      	XtSetArg(arg[i], XtNeditType, OL_TEXT_EDIT);			i++;
        XtSetArg(arg[i], XtNwidth, 10);					i++;
	text = XtCreateManagedWidget(name, textEditWidgetClass,
				     xvw_widget(parent), arg, i);

	if (!initialized)
	{
	   initialized = TRUE;

	   xvw_init_attributes(XtClass(text), text_attributes,
	     knumber(text_attributes), NULL, 0, NULL);
	   xvw_define_attributes(XtClass(text),
	     XVW_TEXT_STRING, XtRString, xvw_set_textstring, xvw_get_textstring,
             XVW_TEXT_EDIT_TYPE, XtRInt, xvw_set_misc,       xvw_get_misc,
             XVW_TEXT_TYPE,      XtRInt, xvw_set_misc,       xvw_get_misc,
             XVW_TEXT_WRAP,      XtRInt, xvw_set_misc,       xvw_get_misc,
             XVW_TEXT_SCROLL_VERT,XtRInt, xvw_set_misc,       xvw_get_misc,
             XVW_TEXT_SCROLL_HORIZ,XtRInt, xvw_set_misc,       xvw_get_misc,
	     XVW_TEXT_MULTILINE, XtRInt, xvw_set_textmulti, xvw_get_textmulti,
	     NULL);
	}
	xvw_set_attribute(xvw_object(text), XVW_TEXT_MULTILINE, FALSE);
	xvw_add_event(xvw_object(text), (EnterWindowMask | LeaveWindowMask),
			text_focus, NULL);
	return(xvw_object(text));
}

/*-----------------------------------------------------------
|
|  Routine Name: text_focus
|
|       Purpose: Sets and removes input focus for olit text widget.
|		 Since the olit text widget is being managed by a non-Olit
|		 widget, the Olit focus management stuff doesn't work.
|
|         Input: object      - the text xvobject
|                client_data - client data (unused)
|                event       - event responsible for firing event handler
|                              (EnterWindowMask | LeaveWindowMask)
|    Written By: Neil Bowers
|          Date: 24-mar-94
------------------------------------------------------------*/
/* ARGSUSED */
static void text_focus(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
        if (event->type == EnterNotify)
	    OlCallAcceptFocus(xvw_widget(object),event->xcrossing.time);
        else
	    XSetInputFocus(xvw_display(object),PointerRoot,RevertToNone,
				event->xcrossing.time);
}

#else
/*
 * These are dummy function calls so that if the widget set is not supported
 * on the machine a message is printed out.
 */

/* ARGSUSED */
xvobject xvw_create_menubutton(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Olit widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

/* ARGSUSED */
xvobject xvw_create_button(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Olit widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

/* ARGSUSED */
xvobject xvw_create_label(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Olit widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

/* ARGSUSED */
xvobject xvw_create_scrollbar(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Olit widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

/* ARGSUSED */
xvobject xvw_create_list(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Olit widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

/* ARGSUSED */
xvobject xvw_create_text(
   xvobject parent,
   char   *name)
{
   kfprintf(kstderr,"\nThe Olit widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}
#endif /* KOLIT_DEF */
/* Don't add after the endif */
