 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>       	       Motif xvobject Creation		      <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                xvw_initialize()		              <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#include "internals.h"

#ifdef KMOTIF_DEF


/*------------------------------------------------------------
|
|  Routine Name: xvw_initialize()
|
|       Purpose: initializes the xvwidget library to use the Motif widget
|		 set.
|
|         Input: menu_handler - the general menu handling routines one of:
|
|                ! XVW_MENUS_XVFORMS -  Enable the use of xvforms as internal
|                !                      menus
|                ! XVW_MENUS_NONE    -  Disable internal menus
|
|        Output: none
|       Returns: the newly initialize display structure or NULL upon failure
|    Written By: Mark Young and Danielle Argiro
|          Date: Jun 17, 1993
| Modifications:
|
------------------------------------------------------------------*/

Display *xvw_initialize(
   kfunc_void menu_handler)
{
	Display *display;
	char    *tbname, *program, path[KLENGTH], toolbox[KLENGTH];

	display = xvw_init_display(menu_handler);
	xvw_load_resources("$DESIGN/objects/library/Motif/app-defaults/Motif");
	if ((program = kprog_get_program()) && (tbname = kprog_get_toolbox()))
	{
	   kstring_upper(tbname, toolbox);
	   ksprintf(path, "$%s/objects/xvroutine/%s/app-defaults/%s",
			toolbox, program, program);
           xvw_load_resources(path);
	}

	/*
	 *  Disable the motif drag and drop...
	 */
#if XmVERSION == 1 && XmREVISION == 2
	if (display != NULL)
	{
	   Widget dw = XmGetXmDisplay(display);
	   XtVaSetValues(dw, XmNdragInitiatorProtocolStyle, XmDRAG_NONE, NULL);
	   XtVaSetValues(dw, XmNdragReceiverProtocolStyle, XmDRAG_NONE, NULL);
	}
#endif
	return(display);
}

#else
/*
 * These are dummy function calls so that if the widget set is not supported
 * on the machine a message is printed out.
 */

/* ARGSUSED */
Display *xvw_initialize(
   kfunc_void menu_handler)
{
   kfprintf(kstderr,"\nThe Motif widget set is either not supported for this \
machine or was not\ncompiled in by the installer of Khoros.  Please contact \
the installer.\n\n");
   return(NULL);
}

#endif /* KMOTIF_DEF */
/* Don't add after the endif */
