 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Conversion routines for Motif Widgets
   >>>>
   >>>>  Private:
   >>>>   Static:
   >>>>			cvtStringToCompoundString()
   >>>>			cvtCompounderStringToString()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

#ifdef KMOTIF_DEF

#define cvtDone(type, value, toVal) \
{                                                       \
    if (toVal->addr != NULL) {                          \
	if (toVal->size < sizeof(type)) {               \
	    toVal->size = sizeof(type);                 \
	    return(FALSE);                              \
	}                                               \
	*(type*)(toVal->addr) = (value);                \
    }                                                   \
    else {                                              \
	static type static_val;                         \
	static_val = (value);                           \
	toVal->addr = (XtPointer)&static_val;           \
    }                                                   \
    toVal->size = sizeof(type);                         \
}



/*-----------------------------------------------------------
|
|  Routine Name: cvtStringToCompoundString
|
|       Purpose: Convert a string to a compound string for Motif.
|
|         Input: display     -
|                args        -
|                num_args    -
|                fromVal     -
|                toVal       -
|
|        Output:
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Danielle Argiro & John Salas
|          Date: April 13, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
Boolean cvtStringToCompoundString(
   Display     *display,
   XrmValuePtr args,
   Cardinal    *num_args,
   XrmValuePtr fromVal,
   XrmValuePtr toVal,
   XtPointer   *closure_ret)
{
	XmString text;

	text = XmStringCreate(fromVal->addr, "charset1");
	cvtDone(XmString, text, toVal);
	return(TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: cvtCompoundStringToString
|
|       Purpose: Convert a Motif compound string to a regular string.
|
|         Input: display     -
|                args        -
|                num_args    -
|                fromVal     -
|                toVal       -
|
|        Output:
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Danielle Argiro & John Salas
|          Date: April 23, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
Boolean cvtCompoundStringToString(
   Display     *display,
   XrmValuePtr args,
   Cardinal    *num_args,
   XrmValuePtr fromVal,
   XrmValuePtr toVal,
   XtPointer   *closure_ret)
{
        char     *tmp;
	XmString compound;

	compound = *((XmString *) fromVal->addr);
	XmStringGetLtoR(compound, "charset1", &tmp);
        cvtDone(String, tmp, toVal);
        return(TRUE);
}

#endif /* KMOTIF_DEF */
/* Don't add after the endif */
