 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: attribute definitions for all
   >>>>		       miscellaneous xvobject attributes
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvwidgets_GenMisc_h_
#define _xvwidgets_GenMisc_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_NAME
|
| Description:	The name used to identify the object.  It is used for
|		specification of resources in the app-defaults file;
|		in addition, for backplanes it will appear as the name
|		on the window dressing.
|
| Type:		char *
| Default:	N/A
| Legal Values:	single string with no spaces
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_NAME		"name"

/*------------------------------------------------------------------------
| Attribute:	XVW_MAP_WHEN_MANAGED
|
| Description:	When an object is created, its initial state may be \fImapped\fP
|		(displayed to the screen immediately) or \fIunmapped\fP (not
|		displayed until explicitly told to be displayed, with a call
|		to \fIxvw_map()\fP.)  If TRUE, this attribute will cause the
|		object to be mapped initially on creation;  if FALSE, it will 
|		delay mapping of the object until so instructed.
|
| Type:		int
| Default:	TRUE
| Legal Values:	TRUE/FALSE
| Resource:	mappedWhenManaged
------------------------------------------------------------------------*/
#define XVW_MAP_WHEN_MANAGED	"mappedWhenManaged"

/*------------------------------------------------------------------------
| Attribute:	XVW_CURSOR
|
| Description:	This attribute specifies the cursor to be used when the 
|		pointer is inside the visual object.  The Cursor structure 
|		that must be passed for this attribute can be obtained with 
|		\fIXCreateGlyphCursor(), XCreatePixmapCursor(), 
|		XDefineCursor()\fP, or \fIXCreateFontCursor()\fP. See 
|		\fIThe Xlib Reference Manual\fP, by Adrian Nye for 
|		definitions of these XLib calls;  Appendix I on "The 
|		Cursor Font" may also be helpful.
| Type:		Cursor
| Default:	The cursor of the parent object
| Legal Values:	Valid Cursor structure (see description).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CURSOR		"cursor"

/*------------------------------------------------------------------------
| Attribute:	XVW_CURSORNAME
|
| Description:	A number of standard cursors are made available with X Windows.
|		The names of these predefined cursors are found in
|		<X11/cursorfont.h>.  The XVW_CURSOR_NAME attribute allows
|		you to specify a predefined cursor by its name.  Accepted 
|		cursor names include:
|               "X_cursor", "array", "based_arrow_down", "based_arrow_up",
|               "boat", "bogosity", "bottom_left_corner", "bottom_right_corner",
|               "bottom_side", "bottom_tee", "box_spiral", "center_ptr",
|               "circle", "clock", "coffee_mug", "cross", "cross_reverse",
|               "crosshair", "diamond_cross", "dot", "dotbox", "double_arrow",
|               "draft_large", "draft_small", "draped_box", "exchange",
|               "fleur", "gobbler", "gumby", "hand1", "hand2", "heart",
|               "icon", "iron_cross", "left_ptr", "left_side", "left_tee",
|               "left_button", "ll_angle", "lr_angle", "man", "middlebutton",
|               "mouse", "pencil", "pirate", "plus", "question_arrow",
|               "right_ptr", "right_side", "right_tee", "rightbutton",
|               "rtl_logo", "sailboat", "sb_down_arrow", "sb_h_double_arrow",
|               "sb_left_arrow", "sb_right_arrow", "sb_v_double_arrow",
|               "shuttle", "sizing", "spider", "spraycan", "star", "target",
|               "tcross", "top_left_arrow", "top_left_corner",
|               "top_right_corner", "top_side", "top_tee", "trek", "ul_angle",
|               "ul_umbrella", "ur_angle", "watch", "xterm", and "num_glyphs".
|		See Appendix I
|		of \fIThe Xlib Reference Manual\fP by O'Reilly & Associates
|		for illustrations depicting the available standard cursors.
|
| Type:		char *
| Default:	N/A
| Legal Values:	Valid cursorfont name (see description).
| Resource:	cursorName
------------------------------------------------------------------------*/
#define XVW_CURSORNAME		"cursorName"

/*------------------------------------------------------------------------
| Attribute:	XVW_BACKGROUND_COLOR
|
| Description:	Provide the string that specifies the name of the desired 
|		background color.  Will be over-ridden by
|		.symbol noindex XVW_BACKGROUND_PIXEL
|		if both are set.
|
| Type:		char *
| Default:	default bg color
| Legal Values:	any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	backgroundColorname
------------------------------------------------------------------------*/
#define XVW_BACKGROUND_COLOR	"backgroundColorname"

/*------------------------------------------------------------------------
| Attribute:	XVW_FOREGROUND_COLOR
|
| Description:	Provide the string that specifies the name of the desired 
|		foreground color.  Will be over-ridden by
|		.symbol noindex XVW_FOREGROUND_PIXEL
|		if both are set.
|
| Type:		char *
| Default:	default fg color
| Legal Values:	any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	foregroundColorname
------------------------------------------------------------------------*/
#define XVW_FOREGROUND_COLOR 	"foregroundColorname"

/*------------------------------------------------------------------------
| Attribute:	XVW_FONT
|
| Description:	The font to be used with any text associated with 
|		the visual object.  The XFontStruct that must be passed 
|		for this attribute can be obtained with \fIXLoadQueryFont()\fP;
|		see Section 6.2 of \fIThe Xlib Programming Manual\fP by
|		Adrian Nye.  Note that this attribute is mutually exclusive with
|		.symbol index XVW_FONTNAME ;
|		use one or the other, not both.
|		Available fonts for a particular workstation can be obtained
|		from the command line with \f(CW%xlsfonts\fP, or from an
|		application program with \fIXListFonts()\fP.
|
| Type:		XFontStruct
| Default:	default font
| Legal Values:	see description
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FONT		"font"

/*------------------------------------------------------------------------
| Attribute:	XVW_FONTNAME
| Description:	.include  $DESIGN/manual/shared/xvobjects/general/FontName.sec
| Type:		char *
| Default:	default font
| Legal Values:	see description
| Resource:	fontName
------------------------------------------------------------------------*/
#define XVW_FONTNAME		"fontName"

/*------------------------------------------------------------------------
| Attribute:	XVW_BACKGROUND
| Description:	The pixel value that defines the desired color for the 
|		background.
| Type:		unsigned long
| Default:	default bg pixel (XtDefaultBackground)
| Legal Values:	any valid pixel value: see Section 7.3 and 7.4
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	background
------------------------------------------------------------------------*/
#define XVW_BACKGROUND		"background"

/*------------------------------------------------------------------------
| Attribute:    XVW_FOREGROUND
| Description:  The pixel value that defines the desired color for the 
|               foreground.
| Type:         unsigned long
| Default:      default fg pixel (XtDefaultForeground)
| Legal Values: any valid pixel value: see Section 7.3 and 7.4
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     background
------------------------------------------------------------------------*/
#define XVW_FOREGROUND	 	"foreground"

/*------------------------------------------------------------------------
| Attribute:	XVW_BACKGROUND_PIXEL
| Description:	See 
|		.symbol noindex XVW_BACKGROUND
|		it is the same thing.
| Type:         unsigned long
| Default:	default bg pixel (XtDefaultBackground)
| Legal Values:	any valid pixel value: see Section 7.3 and 7.4
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	background
------------------------------------------------------------------------*/
#define XVW_BACKGROUND_PIXEL	XVW_BACKGROUND

/*------------------------------------------------------------------------
| Attribute:	XVW_FOREGROUND_PIXEL
| Description:	See 
|		.symbol noindex XVW_FOREGROUND ;
|		it is the same thing.
| Type:		unsigned long
| Default:	default fg pixel (XtDefaultForeground)
| Legal Values:	any valid pixel value: see Section 7.3 and 7.4
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	foreground
------------------------------------------------------------------------*/
#define XVW_FOREGROUND_PIXEL 	XVW_FOREGROUND

/*------------------------------------------------------------------------
| Attribute:	XVW_BORDER
| Description:	Provide the pixel value that specifies the desired border
|               color. 
| Type:		unsigned long
| Default:	None
| Legal Values:	any valid pixel value: see Section 7.3 and 7.4
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	border
------------------------------------------------------------------------*/
#define XVW_BORDER 		"border"

/*------------------------------------------------------------------------
| Attribute:	XVW_BORDER_PIXEL
| Description:	See
|               .symbol noindex XVW_BORDER ;
|               it is the same thing.
| Type:         unsigned long
| Default:      None
| Legal Values: any valid pixel value: see Section 7.3 and 7.4
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_BORDER_PIXEL 	XVW_BORDER

/*------------------------------------------------------------------------
| Attribute:	XVW_BORDER_COLOR
| Description:	The string that specifies the name of the desired border 
|		color.  Will be overridden by
|		.symbol noindex XVW_BORDER_PIXEL
|		if both are set.
| Type:		char *
| Default:	N/A
| Legal Values:	any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	borderColorname
------------------------------------------------------------------------*/
#define XVW_BORDER_COLOR 	"borderColorname"

/*------------------------------------------------------------------------
| Attribute:	XVW_VISUAL
|
| Description:	This is the X11 \fIvisual\fP being used to display the visual 
|		object on a particular screen.  Visuals are discussed in detail |		in \fIThe Xlib Programming Manual\fP by Adrian 
|		Nye. Note that the application should generally \fInot\fP 
|		attempt to set the visual; it should instead allow the visual 
|		object to choose the most appropriate visual.
|
| Type:		Visual
| Default:	XDefaultVisual(), or may be determined according to the 
|		visual object being used
|		and the screen on which it is being displayed	
| Legal Values:	a valid Visual structure
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_VISUAL		"visual"

/*------------------------------------------------------------------------
| Attribute:    XVW_DEPTH
|
| Description:  This is the number of planes that are to be used
|		to represent grey scales or color within a visual object.
|		It determined by the visual being used (see
|		.symbol index XVW_VISUAL )
|		.
|
| Type:         int
| Default:	computed according to 
|		.symbol index XVW_VISUAL
| Legal Values: the number of planes supported by the visual.
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_DEPTH               "depth"

/*------------------------------------------------------------------------
| Attribute:	XVW_COLORMAP
|
| Description:	This is the X11 \fIcolormap\fP that is used to display the 
|		visual object.  Colormaps are discussed in detail in 
|               in \fIThe Xlib Programming Manual\fP by Adrian
|               Nye. Note that the application should generally \fInot\fP 
|               attempt to set the colormap;  it should instead allow the visual
|               object to choose the most appropriate colormap.
|
| Type:		Colormap
| Default:	XDefaultColormap()
| Legal Values:	a valid Colormap structure.
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_COLORMAP		"colormap"

/*------------------------------------------------------------------------
| Attribute:	XVW_BACKGROUND_PIXMAPFILE
|
| Description:	This is the file defining an (optional) pixmap that appears
|		as the background of an object, instead of the background
|		color.
|
| Type:		char *
| Default:	NULL
| Legal Values:	The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX.
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BACKGROUND_PIXMAPFILE "backgroundPixmapfile"

/*------------------------------------------------------------------------
| Attribute:	XVW_BACKGROUND_PIXMAP
|
| Description:  This is an (optional) pixmap that appears as the background
|		of an object, instead of the background color.  Candidates 
|		for the value of this attribute may be created with the use
|               of \fIXCreatePixmap()\fP;  see \fIThe Xlib Reference Manual\fP
|               by O'Reilly and Associates.  Note that this attribute is
|               mutually exclusive with
|               .symbol index XVW_BACKGROUND_PIXMAPFILE ;
|               specify one or the other, not both.
|
| Type:		Pixmap
| Default:	NULL
| Legal Values:	Valid Pixmap structure
| Resource:	backgroundPixmap
------------------------------------------------------------------------*/
#define XVW_BACKGROUND_PIXMAP	"backgroundPixmap"

/*------------------------------------------------------------------------
| Attribute:    XVW_CHAR_XSNAP
|
| Description:	This attribute only applies to \fIconstraint\fP objects,
|		such as manager objects, canvas objects, rowcol objects,
|		and so on, that support layout and direct manipulation of
|		children. With interactive movement of selected child objects,
|		the child objects can be made to "snap" to the new position,
|		aiding the user in more precise interactive layout of objects.
|		This attribute specifies, in characters, the horizontal 
|		increments of the implied grid (visible or not) to which 
|		children will "snap".  For example, if 
|		.symbol index XVW_CHAR_XSNAP
|		is set to 0.5, then objects will "snap" to positions in
|		half-character-width increments.
| Type:         float
| Default:      1
| Legal Values: values > 0.0
| Resource:     charXsnap
------------------------------------------------------------------------*/
#define XVW_CHAR_XSNAP          "charXsnap"

/*------------------------------------------------------------------------
| Attribute:    XVW_CHAR_YSNAP
|
| Description:  This attribute only applies to \fIconstraint\fP objects,
|               such as manager objects, canvas objects, rowcol objects,
|               and so on, that support layout and direct manipulation of
|               children. With interactive movement of selected child objects,
|               the child objects can be made to "snap" to the new position,
|               aiding the user in more precise interactive layout of objects.
|               This attribute specifies, in characters, the vertical 
|               increments of the implied grid (visible or not) to which 
|               children will "snap".  For example, if 
|               .symbol index XVW_CHAR_YSNAP
|               is set to 1.0, then objects will "snap" to positions in
|               one-character-height increments.
|
| Type:         float
| Default:      1
| Legal Values: values > 0.0
| Resource:     charYsnap
------------------------------------------------------------------------*/
#define XVW_CHAR_YSNAP          "charYsnap"

/*------------------------------------------------------------------------
| Attribute:    XVW_DESTROY
|
| Description:  If necessary, \fIxvw_add_callback()\fP may be used to install
|               a callback on any GUI or visual object which will be
|               fired when the object is destroyed.  When calling 
|		\fIxvw_add_callback()\fP, pass this attribute directly, as in
|               .begin code
|               xvw_add_callback(object, XVW_DESTROY, 
|				 destroy_cb, client_data);
|               .end code
| Type:		kfunc_void
| Default:	NULL
| Legal Values:	callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_DESTROY             "destroyCallback"

#endif /* _xvwidgets_GenMisc_h_ */
/* Don't add after this point */
