 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes for Text Display Object
   >>>>
   >>>>    Written By: Mark Young & Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_TextDisplay_h_
#define _xvobjects_TextDisplay_h_


	/*-------------------------------------*
	|       #defines
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ASCII
|
| Description:  The XFontStruct structure defining the Ascii font to be 
|		used with "normal" text appearing in the text display object.  
|		The XFontStruct value for setting this attribute can be 
|		obtained with \fIXLoadQueryFont()\fP; a list of XFontStruct 
|		candidates may be obtained with \fIXListFontsWithInfo()\fP. 
|		For more information on these Xlib routines, see Section 6.2 
|		of \fIThe Xlib Programming Manual\fP by Adrian Nye.  Note that 
|		this attribute is mutually exclusive with
|		.symbol index XVW_TEXTDISPLAY_ASCII_FONTNAME ;
|		use one or the other, not both.
|
| Type:         XFontStruct
| Default:      see description
| Legal Values: see description
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ASCII		    "textdisplayAscii"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ASCII_FONTNAME
|
| Description:  This attribute specifies the name of the Ascii font to be used
|		with "normal" text appearing in the text display object.  
|		The default font used for roman is:
|		.br
|		6x13
|		.br
|		Available fonts for a particular workstation can be obtained
|               from the command line with \f(CW%xlsfonts\fP, or from an
|               application program with the \fIXListFonts()\fP XLib routine.  
|
| Type:         char *
| Default:      see description 
| Legal Values: see description 
| Resource:	textdisplayAsciiFontname
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ASCII_FONTNAME	    "textdisplayAsciiFontname"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ROMAN
|
| Description:  The XFontStruct structure defining the Roman font to be 
|		used with "normal" text appearing in the text display object.  
|		The XFontStruct value for setting this attribute can be 
|		obtained with \fIXLoadQueryFont()\fP; a list of XFontStruct 
|		candidates may be obtained with \fIXListFontsWithInfo()\fP. 
|		For more information on these Xlib routines, see Section 6.2 
|		of \fIThe Xlib Programming Manual\fP by Adrian Nye.  Note that 
|		this attribute is mutually exclusive with
|		.symbol index XVW_TEXTDISPLAY_ROMAN_FONTNAME ;
|		use one or the other, not both.
|
| Type:         XFontStruct
| Default:      see description
| Legal Values: see description
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ROMAN		    "textdisplayRoman"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ROMAN_FONTNAME
|
| Description:  This attribute specifies the name of the Roman font to be used
|		with "normal" text appearing in the text display object.  
|		The default font used for roman is:
|		.br
|		*-new century schoolbook-medium-r-normal--12-120-*
|		.br
|		Available fonts for a particular workstation can be obtained
|               from the command line with \f(CW%xlsfonts\fP, or from an
|               application program with the \fIXListFonts()\fP XLib routine.  
|
| Type:         char *
| Default:      see description 
| Legal Values: see description 
| Resource:	textdisplayRomanFontname
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ROMAN_FONTNAME	    "textdisplayRomanFontname"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_BOLD
|
| Description:  The XFontStruct structure defining the Bold font to be 
|               used with text delineated by \\fB and \\fP.  See 
|		.symbol index XVW_TEXTDISPLAY_ROMAN
|		for additional information on font structures. 
|
| Type:         XFontStruct
| Default:      see description
| Legal Values: see description
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_BOLD		    "textdisplayBold"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_BOLD_FONTNAME
|
| Description:  This attribute specifies the name of the Bold font to be 
|               used with text delineated by \\fB and \\fP.  The default font
|		used for bold is:
|		.br
|		*-new century schoolbook-bold-r-normal--12-120-*
|		.br
|		See
|               .symbol index XVW_TEXTDISPLAY_ROMAN_FONTNAME
|		for additional information on font names.
|		Note that this attribute is only used when 
|		.symbol index XVW_TEXTDISPLAY_ROFF
|		is set to TRUE.
| Type:         char *
| Default:      see description 
| Legal Values: see description 
| Resource:	textdisplayBoldFontname
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_BOLD_FONTNAME	    "textdisplayBoldFontname"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ITALIC
|
| Description:  The XFontStruct structure defining the Italic font to be 
|               used with text delineated by \\fI and \\fP.  See  
|               .symbol index XVW_TEXTDISPLAY_ROMAN
|               for additional information on font structures.
|
| Type:         XFontStruct
| Default:      see description
| Legal Values: see description 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ITALIC		    "textdisplayItalic"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ITALIC_FONTNAME
|
| Description:  This attribute specifies the name of the Italic font to be 
|               used with text delineated by \\fI and \\fP.  The default font
|               used for italic is:
|               .br
|		*-new century schoolbook-bold-i-normal--12-120-*
|               .br
|               See
|               .symbol index XVW_TEXTDISPLAY_ROMAN_FONTNAME
|               for additional information on font names.
|               Note that this attribute is only used when
|               .symbol index XVW_TEXTDISPLAY_ROFF
|               is set to TRUE.
|
| Type:         char *
| Default:      see description 
| Legal Values: see description 
| Resource:	textdisplayItalicFontname
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ITALIC_FONTNAME	    "textdisplayItalicFontname"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_HELVETICA
|
| Description:  The XFontStruct structure defining the Helvetica font to be 
|               used with text delineated by \\fH and \\fP.  See  
|               .symbol index XVW_TEXTDISPLAY_ROMAN
|               for additional information on font structures.
|
| Type:         XFontStruct 
| Default:      see description
| Legal Values: see description 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_HELVETICA	    "textdisplayHelvetica"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_HELVETICA_FONTNAME
|
| Description:  This attribute specifies the name of the Helvetica font to be 
|               used with text delineated by \\fH and \\fP.  The default font
|               used for helvetica is:
|               .br
|		*-adobe-helvetica-medium-r-normal--12-120-*
|               .br
|               See
|               .symbol index XVW_TEXTDISPLAY_ROMAN_FONTNAME
|               for additional information on font names.
|               Note that this attribute is only used when
|               .symbol index XVW_TEXTDISPLAY_ROFF
|               is set to TRUE.
|
| Type:         char *
| Default:      see description 
| Legal Values: see description 
| Resource:	textdisplayHelveticaFontname
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_HELVETICA_FONTNAME  "textdisplayHelveticaFontname"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_SYMBOL
|
| Description:  The XFontStruct structure defining the Symbol font to be
|               used with text delineated by \\fS and \\fP.  See
|               .symbol index XVW_TEXTDISPLAY_ROMAN
|               for additional information on font structures.
|
| Type:         XFontStruct
| Default:      see description
| Legal Values: see description 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_SYMBOL		    "textdisplaySymbol"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_SYMBOL_FONTNAME
|
| Description:  This attribute specifies the name of the Symbol font to be
|               used with text delineated by \\fS and \\fP.  The default font
|               used for symbol is:
|               .br
|		*-symbol-medium-r-normal--*-120-*
|               .br
|               See
|               .symbol index XVW_TEXTDISPLAY_ROMAN_FONTNAME
|               for additional information on font names.
|               Note that this attribute is only used when
|               .symbol index XVW_TEXTDISPLAY_ROFF
|               is set to TRUE.
|
| Type:         char *
| Default:      see description 
| Legal Values: see description 
| Resource:	textdisplaySymbolFontname
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_SYMBOL_FONTNAME	    "textdisplaySymbolFontname"


/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ROFF
|
| Description:  If the file to appear in the text display object has \fIroff\fP
|		formatting commands, setting this attribute to TRUE will cause
|		those formatting commands to be interpreted and the text
|		formatted as specified.  If FALSE, the file to be displayed
|		is considered to be a plain ascii text file, and the text is
|		displayed exactly as it appears in the file.
|
| Type:         int
| Default:      TRUE 
| Legal Values: TRUE/FALSE 
| Resource:	textdisplayRoff
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ROFF		"textdisplayRoff"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_INDENT
|
| Description:  The number of pixels to indent into the text display object
|		before printing text. 
|
| Type:         int
| Default:      10 
| Legal Values: values > 0 
| Resource:	textdisplayIndent
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_INDENT		"textdisplayIndent"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_FILE
|
| Description:  This is the open stream to the file to be displayed
|		in the text display object. Note that this attribute
|		is mutually exclusive with
|		.symbol index XVW_TEXTDISPLAY_FILENAME ;
|		use one or the other, not both.
|
| Type:         kfile
| Default:      NULL 
| Legal Values: A \fIkfile\fP pointer returned by \fIkfopen()\fP or 
|		another Khoros open data transport routine 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_FILE		"textdisplayFile"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_FILENAME
|
| Description:  This is the name of the file to be displayed in the 
|		display object. 
|
| Type:         char * 
| Default:      NULL 
| Legal Values: valid name of input file 
| Resource:	textdisplayFilename
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_FILENAME	"textdisplayFilename"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_CALLBACK
|
| Description:  If desired,  \fIxvw_add_callback()\fP may be used to install
|               a callback on the text display object that will be fired when 
|		the user clicks on a particular word that appears in the text 
|		being displayed.  
|		.br
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(textdisplayobj, XVW_TEXTDISPLAY_CALLBACK,
|                                textdisplay_cb, client_data);
|               .end code
|		.br
|		When this callback attribute is used, either the 
|		.symbol index XVW_TEXTDISPLAY_WORDCOLOR 
|		or the
|		.symbol index XVW_TEXTDISPLAY_WORDPIXEL
|		attribute should be used to set the color of the word to
|		something other than the rest of the text.  This will
|		indicate to the user that they can click on the word to
|		make something happen (what will happen is, of course, 
|		determined by the callback).
|		.br
|		In addition, it is also good to set either the
|		.symbol index XVW_TEXTDISPLAY_HIGHLIGHTCOLOR 
|               or the
|               .symbol index XVW_TEXTDISPLAY_HIGHLIGHTPIXEL
|		attribute to specify the color in which the word will
|		appear when it is actually clicked on.
|		.br
|		Note that the word that the user clicked on will be
|		passed as a string in the \fIcall_data\fP;  to access the
|		string inside the callback, it must first cast to a string,
|		as in:
|		\f(CWchar *word = (char *) calldata\fP
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_CALLBACK	"textdisplayCallback"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ADDWORD
|
| Description:  This \fIaction attribute\fP allows you to add a word to
|		the text display list of words that will fire the callback
|		specified by
|		.symbol index XVW_TEXTDISPLAY_CALLBACK . 
|		Any time the specified word appears in the text being
|		displayed, it will appear in the color specified by either
|		.symbol index XVW_TEXTDISPLAY_WORDCOLOR
|		or
|               .symbol index XVW_TEXTDISPLAY_WORDPIXEL .
|		This alerts the user that they can click on the word
|		to initiate the action defined by the callback installed
|		with
|               .symbol index XVW_TEXTDISPLAY_CALLBACK .
|		When they click on the word, it will change to the color
|		specified by either
|               .symbol index XVW_TEXTDISPLAY_HIGHLIGHTCOLOR
|               or
|               .symbol index XVW_TEXTDISPLAY_HIGHTLIGHTPIXEL .
|
| Type:         char * 
| Default:      NULL 
| Legal Values: Single words only; phrases are not yet supported 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ADDWORD		"textdisplayAddword"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_DELETEWORD
|
| Description:  This \fIaction attribute\fP allows you to delete a word
|		from the text display list of words that fire the callback
|		specified by
|               .symbol index XVW_TEXTDISPLAY_CALLBACK .
|		The word will revert to the same foreground color as "normal"
|		text to indicate that no action will be initiated if the
|		user clicks on it.
|
| Type:         char * 
| Default:      NULL 
| Legal Values: Single words previously added to the text display list
|		with
|		.symbol index XVW_TEXTDISPLAY_DELETEWORD . 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_DELETEWORD	"textdisplayDeleteword"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_CLEARWORD
|
| Description:  This \fIaction attribute\fP deletes all words from the
|		text display list  of words that fire the callback
|               specified by
|               .symbol index XVW_TEXTDISPLAY_CALLBACK .
|		All words will  revert to the same foreground color as "normal"
|               text to indicate that no action will be initiated if the
|               user clicks on them.
|
| Type:         int 
| Default:      N/A 
| Legal Values: TRUE 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_CLEARWORD	"textdisplayClearword"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_ADDTEXT
|
| Description:  This \fIaction attribute\fP adds text to the
|		text display.  The text is appended to the existing
|		list of text and is appropriately displayed after
|		being compiled.  The text passed via the \fIaction attribute\fP
|		is duplicated.
|
| Type:         char * 
| Default:      N/A 
| Legal Values: Any multiline text which is displayable
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_ADDTEXT		"textdisplayAddtext"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_CLEARTEXT
|
| Description:  This \fIaction attribute\fP deletes all text from the
|		text display.
|		All text will be deleted from the text display list,
|		which will result in the text display defaulting to it's
|		initial state.
|
| Type:         int 
| Default:      N/A 
| Legal Values: TRUE 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_CLEARTEXT	"textdisplayCleartext"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_WORDPIXEL
|
| Description:  This is the pixel value associated with the color
|		of a particular word that the user can click on to
|		make something happen.  It is only applicable if
|		.symbol index XVW_TEXTDISPLAY_CALLBACK
|		has been used to install a callback that will be
|		fired when the user clicks on the word.
|		 
| Type:         unsigned long
| Default:      pixel associated with "blue" 
| Legal Values: any valid pixel value: see Section 7.3 and 7.4
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_WORDPIXEL	"textdisplayWordpixel"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_WORDCOLOR
|
| Description:  This is the name of the color of a particular word that the
|		user can click on to make something happen;
|		it is only applicable if
|               .symbol index XVW_TEXTDISPLAY_CALLBACK
|               has been used to install a callback that will be
|               fired when the user clicks on the word.
|
| Type:         char *
| Default:      "blue" 
| Legal Values: any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	textdisplayWordcolor
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_WORDCOLOR	"textdisplayWordcolor"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_HIGHLIGHTPIXEL
|
| Description:  This is the pixel value associated with the color
|               of a particular word when the user clicks on it to
|               make something happen.  It is only applicable if
|               .symbol index XVW_TEXTDISPLAY_CALLBACK
|               has been used to install a callback that will be
|               fired when the user clicks on the word.
|               
| Type:         unsigned long
| Default:      pixel associated with "red" 
| Legal Values: any valid pixel value: see Section 7.3 and 7.4
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_HIGHLIGHTPIXEL	"textdisplayHightlightpixel"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTDISPLAY_HIGHLIGHTCOLOR
|
| Description:  This is the name of the color of a particular when the
|               user clicks on it to make something happen;
|               it is only applicable if
|               .symbol index XVW_TEXTDISPLAY_CALLBACK
|               has been used to install a callback that will be
|               fired when the user clicks on the word.
|
| Type:         char *
| Default:      "red"
| Legal Values: any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	textdisplayHightlightcolor
------------------------------------------------------------------------*/
#define XVW_TEXTDISPLAY_HIGHLIGHTCOLOR	"textdisplayHightlightcolor"


/*
 *  Define the Class name, by which people should be externally referencing
 *  the TextDisplay Object by.
 */
#define TextDisplayWidgetClass	xvwTextDisplayWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration TextDisplayWidgetClass
 */
extern   WidgetClass     TextDisplayWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for TextDisplay Object
 */
xvobject xvw_create_textdisplay PROTO((xvobject, char *));


#endif /* _xvobjects_TextDisplay_h_ */
/* Don't add after this point */
