 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical label.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Labelstr_h_
#define _xvobjects_Labelstr_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Khoros Option Defines for XvwLabelObject
 */

/*------------------------------------------------------------------------
| Attribute:	XVW_LABEL_FILLED
| Description:  Set to TRUE, this attribute causes the background of the 
|		labelstring to filled with the background color.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	labelFilled
------------------------------------------------------------------------*/
#define XVW_LABEL_FILLED		"labelFilled"

/*------------------------------------------------------------------------
| Attribute:	XVW_LABEL_EMPHASIZE
| Description:  This attribute causes the label to be drawn twice, giving 
|		it a 3D, emphasized effect.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	labelEmphasize
------------------------------------------------------------------------*/
#define XVW_LABEL_EMPHASIZE		"labelEmphasize"

/*------------------------------------------------------------------------
| Attribute:	XVW_FORCE_REDISPLAY
| Description:  This attribute of the manager gadget is inherited by the
|		labelstring object;  it is emphasized here because it 
|		can be used by the labelstring object to achieve smoother, 
|		faster update of the label.  It is especially useful when
|		the labelstring is updated very rapidly, as for example 
|		in an event handler installed on button motion. 
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	forceRedisplay
------------------------------------------------------------------------*/

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Label Object by.
 */
#define LabelGadgetClass	xvwLabelGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration LabelGadgetClass
 */
extern   WidgetClass     LabelGadgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Khoros Function Definition for Label Object
 */
xvobject xvw_create_labelstr PROTO((xvobject, char *));


#endif /* _xvobjects_Labelstr_h_ */
/* Don't add after this point */
