 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  Double Widget
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Double_h_
#define _xvobjects_Double_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_DOUBLE_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|		label object component of the the double object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_LABEL_OBJECT		"doubleLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_DOUBLE_CRLABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               pixmap object component of the the double object that
|		indicates a "live" selection.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The pixmap object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_CRLABEL_OBJECT	"doubleCrlabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_DOUBLE_SCROLLBAR_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               scrollbar object component of the the double object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The scrollbar object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_SCROLLBAR_OBJECT	"doubleScrollbarObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_DOUBLE_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               text object component of the the double object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_TEXT_OBJECT		"doubleTextObject"


/*------------------------------------------------------------------------
| Attribute:    XVW_DOUBLE_LABEL
|
| Description:  This is the text that will appear in the label object
|		component of the double object.  Provide text appropriate
|		as a title of the double object.
|
| Type:         char *
| Default:      NULL
| Legal Values: any printable text
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_LABEL		"doubleLabelObject.label"

/*------------------------------------------------------------------------
| Attribute:	XVW_DOUBLE_VALUE
|
| Description:  The double precision value which is currently displayed in
|		the text object.  This attribute can be used to initialize
|		the double value to be displayed in the text object, or to
|		acquire a double value that has been entered by the user in
|		the text object.
|
| Type:         double
| Default:      0.0
| Legal Values: any double value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_VALUE		"doubleValue"

/*------------------------------------------------------------------------
| Attribute:	XVW_DOUBLE_MINVALUE
|
| Description:  The minimum double value allowed. If both
|		.symbol noindex XVW_DOUBLE_MINVALUE
|		and
|		.symbol noindex XVW_DOUBLE_MAXVALUE
|		are 0.0, the double value is unbounded.
|
| Type:         double
| Default:      0.0
| Legal Values: any double value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_MINVALUE		"doubleMinvalue"

/*------------------------------------------------------------------------
| Attribute:	XVW_DOUBLE_MAXVALUE
|
| Description:  The maximum double value allowed. If both
|		.symbol noindex XVW_DOUBLE_MINVALUE
|		and
|		.symbol noindex XVW_DOUBLE_MAXVALUE
|		are 0.0, the double value is unbounded.
|
| Type:         double
| Default:      1.0
| Legal Values: any double value
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_MAXVALUE		"doubleMaxvalue"

/*------------------------------------------------------------------------
| Attribute:	XVW_DOUBLE_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the double object which will be fired when user 
|		enters a new double value, either by typing it in and pressing 
|		<cr>, or by using the scrollbar. When calling 
|		\fIxvw_add_callback()\fP, pass this attribute directly, as in
|               .begin code
|               xvw_add_callback(doubleobj, XVW_DOUBLE_CALLBACK,
|                                doubleobj_cb, client_data);
|               .end code
|		Note that the current double
|               precision value of the double object will be passed to the
|               callback in the \fIcall_data\fP.  The value must be cast
|               to a double pointer before use, as in:
|               .br
|               \f(CWdouble *value = (double *) call_data;\fP
|               .br
|               Alternatively, the double value may be obtained with
|               .symbol index XVW_DOUBLE_VALUE .
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_DOUBLE_CALLBACK		"doubleCallback"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Double Object by.
 */
#define DoubleWidgetClass	xvwDoubleWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration DoubleWidgetClass
 */
extern   WidgetClass     DoubleWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Double Object
 */
xvobject xvw_create_double PROTO((xvobject, char *));


#endif /* _xvobjects_Double_h_ */
/* Do not add after this line */
