 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical line annotation.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Connection_h_
#define _xvobjects_Connection_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Khoros Option Defines for XvwConnectionObject
 */

/*------------------------------------------------------------------------
| Attribute:	XVW_CONNECTION_BEGIN
| Description:  This specifies the first of the two visual or GUI objects to
|		be connected.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid visual or GUI object
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CONNECTION_BEGIN	 "connectionBegin"

/*------------------------------------------------------------------------
| Attribute:	XVW_CONNECTION_END
| Description:  This specifies the second of the two visual or GUI objects
|		to be connected.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid visual or GUI object
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CONNECTION_END	 "connectionEnd"

/*------------------------------------------------------------------------
| Attribute:	XVW_CONNECTION_TYPE
| Description:  This specifies the type of connection.  May be one of:
|		.symbol index KCONNECTION_TYPE_LINEAR:
|		connects the objects with straight lines, acute and obtuse
|		angles if necessary.
|		.br
|		.symbol index KCONNECTION_TYPE_MANHATTAN:
|		connects the objects with straight lines, squares
|		with right angles when necessary.
|		.br
|		.symbol index KCONNECTION_TYPE_SPLINE:
|		connects the objects with a curved line.
|		.br
|		.symbol index KCONNECTION_TYPE_HEXAGON:
|		finishes angles with a hexagon.
|		.br
|		.symbol index KCONNECTION_TYPE_DIAMOND:
|		finishes angles with a diamond.
| Type:         int
| Default:      .symbol index KCONNECTION_TYPE_MANHATTAN
| Legal Values: .symbol index KCONNECTION_TYPE_LINEAR
|		.symbol index KCONNECTION_TYPE_MANHATTAN
|		.symbol index KCONNECTION_TYPE_SPLINE
|		.symbol index KCONNECTION_TYPE_HEXAGON
|		.symbol index KCONNECTION_TYPE_DIAMOND
| Resource:	connectionType
------------------------------------------------------------------------*/
#define XVW_CONNECTION_TYPE	 "connectionType"

/*------------------------------------------------------------------------
| Attribute:	XVW_CONNECTION_LINEWIDTH
| Description:  Specifies the width of the connection.
| Type:         int
| Default:      .symbol index KCONNECTION_LINE_EXTRA_FINE
| Legal Values: .symbol index KCONNECTION_LINE_EXTRA_FINE
|		.symbol index KCONNECTION_LINE_FINE
|		.symbol index KCONNECTION_LINE_MEDIUM_FINE
|		.symbol index KCONNECTION_LINE_MEDIUM
|		.symbol index KCONNECTION_LINE_MEDIUM_WIDE
|		.symbol index KCONNECTION_LINE_WIDE
|		.symbol index KCONNECTION_LINE_EXTRA_WIDE
| Resource:	connectionLinewidth
------------------------------------------------------------------------*/
#define XVW_CONNECTION_LINEWIDTH "connectionLinewidth"

/*------------------------------------------------------------------------
| Attribute:	XVW_CONNECTION_UPDATETIME
| Description:  This double value attribute specifies the speed at which the
|		connection is animated when using the 
|		.symbol noindex XVW_CONNECTION_START 
|		attribute.  The number given specifies
|		how often the line type used to draw the connection is updated.
|	        The default, 0.2, specifies that the connection is to be
|		redrawn with a new line type every 0.2 seconds, or 5 times a
|		second.  The smaller the number, the faster the "data flow"
|		down the connection appears.  Numbers smaller than 0.1 are
|		not recommended, as they will cause the animation procedure
|		to require more cpu time than it is worth; furthermore, at
|		high speeds, the "flowing" illusion is lost.
| Type:         double
| Default:      0.2
| Legal Values: value >= 0.0
| Resource:	connectionUpdatetime
------------------------------------------------------------------------*/
#define XVW_CONNECTION_UPDATETIME   "connectionUpdatetime"


/*------------------------------------------------------------------------
| Attribute:	XVW_CONNECTION_START
| Description:  This action attribute will "animate" the connection, so that
|		it appears as if data is "flowing" down the connection.  This
|		is done by rapidly changing the line type that is used to
|		draw the connection, to create the illusion of a flowing
|		movement.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CONNECTION_START	 "connectionStart"

/*------------------------------------------------------------------------
| Attribute:	XVW_CONNECTION_STOP
| Description:  This action attribute  will discontinue "animation" of the
|		connection, begun previously with
|		.symbol noindex XVW_CONNECTION_START .
|		The connection will again appear solid.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CONNECTION_STOP	 "connectionStop"

/*------------------------------------------------------------------------
| Attribute:	XVW_CONNECTION_CALLBACK
|
| Description:	If desired, \fIxvw_add_callback()\fP may be used to install
|		a callback may be installed on the connection
|		object that will be fired when the user clicks on the
|		connection object.  When calling \fIxvw_add_callback()\fP,
|		pass this #define directly, as in
|		.begin code
|		xvw_add_callback(connection, XVW_CONNECTION_CALLBACK, 
|				 connection_cb, client_data);
|		.end code
|
|		In \fHcantata\fP, such a callback is
|		used to pop up a list offering selections such as "delete
|		connection", "connection options", and so on.
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CONNECTION_CALLBACK  "connectionCallback"


/*
 *  Connection type for the controlling how the connection should be
 *  displayed.  The choices are linear, rectangular, spline...
 */
#define KCONNECTION_TYPE_LINEAR		1
#define KCONNECTION_TYPE_MANHATTAN	2
#define KCONNECTION_TYPE_SPLINE		3
#define KCONNECTION_TYPE_HEXAGON	4
#define KCONNECTION_TYPE_DIAMOND	5

/*
 *  Line widths for connections
 */
#define KCONNECTION_LINE_EXTRA_FINE  0    
#define KCONNECTION_LINE_FINE        1          
#define KCONNECTION_LINE_MEDIUM_FINE 2   
#define KCONNECTION_LINE_MEDIUM      3        
#define KCONNECTION_LINE_MEDIUM_WIDE 4   
#define KCONNECTION_LINE_WIDE        5          
#define KCONNECTION_LINE_EXTRA_WIDE  6    

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Connection Object by.
 */
#define ConnectionGadgetClass	xvwConnectionGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration ConnectionGadgetClass
 */
extern   WidgetClass     ConnectionGadgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Khoros Function Definition for Connection Object
 */
xvobject xvw_create_connection PROTO((xvobject, char *));


#endif /* _xvobjects_Connection_h_ */
/* Don't add after this point */
