 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  Canvas Widget
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Canvas_h_
#define _xvobjects_Canvas_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*
 * Still unimplemented, when a child of the canvas is interactively moved 
 * by the user, this attribute will specify whether the actual object is to 
 * be moved, or whether only its outline is moved (until it is placed).
 */
#define XVW_CANVAS_RUBBERBAND	"canvasRubberband"

/*------------------------------------------------------------------------
| Attribute:	XVW_CANVAS_DUPLICATE
| Description:  This action attribute duplicates the currently selected
|		objects in the canvas.  Any selected object duplicated; the
|		duplicated objects are then selected and positioned 10 pixels
|		below and to the right of the originals.  If no object on the
|		canvas has been selected, a warning message will be issued.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_DUPLICATE	"canvasDuplicate"

/*------------------------------------------------------------------------
| Attribute:	XVW_CANVAS_UNDO
| Description:	This action attribute restores the object(s) that were 
|		most recently deleted using the
|		.symbol index XVW_CANVAS_DELETE
|		action attribute.  If no object on the canvas has been
|		selected, a warning message will be issued.
| Type:		int
| Default:	N/A
| Legal Values:	TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_UNDO		"canvasUndo"

/*------------------------------------------------------------------------
| Attribute:	XVW_CANVAS_COPY
| Description:  This action attribute \fIcopies\fP the currently selected
|		objects in the cavas into the global clipboard.  The clipboard
|		is global to all displayed canvas objects, regardless of
|		whether or not the different canvas objects have different
|		parents.  If no object on the canvas has been selected, a
|		warning message will be issued.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_COPY		"canvasCopy"

/*------------------------------------------------------------------------
| Attribute:	XVW_CANVAS_PASTE
| Description:  This action attribute pastes the contents of the currently
|		selected objects in the global clipboard into the canvas
|		object.  The clipboard is global to all displayed canvas
|		objects, regardless of whether or not the different canvas
|		objects have different parents.  If no object on the clipboard
|		has been selected, a warning message will be issued.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_PASTE	"canvasPaste"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_CUT
| Description:  This action attribute \fImoves\fP the currently selected
|		objects in the canvas into the global clipboard.  The
|		clipboard is global to all displayed canvas objects,
|		regardless of whether or not the different canvas objects
|		have different parents.  If no object on the canvas has
|		been selected, a warning message will be issued.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_CUT		"canvasCut"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_RAISE
| Description:  This action attribute raises the currently selected objects
|		in the canvas beneath any other objects that may overlap the
|		same space.  If no object on the canvas has been selected, a
|		warning message will be issued.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_RAISE	"canvasRaise"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_LOWER
| Description:  This action attribute lowers the currently selected objects
|		in the canvas beneath any other objects that may overlap the
|		same space.  If no object on the canvas has been selected, a
|		warning message will be issued.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_LOWER	"canvasLower"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_DELETE
| Description:  This action attribute deletes all currently selected objects
|		from the canvas.  The objects are temporarily saved (until
|		the next time the
|		.symbol definitive XVW_CANVAS_DELETE
|		action attribute is used), so that the delete operation can
|		be undone by setting the
|		.symbol noindex XVW_CANVAS_UNDO
|		action attribute.  If no object on the canvas has been
|		selected, a warning message will be issued.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_DELETE	"canvasDelete"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_SELECTALL
| Description:  This action attribute automatically selects all objects in the
|		canvas, unless the objects have been designated as
|		"unselectable".  An object is made "unselectable" if its
|		.symbol noindex XVW_SELECTABLE
|		attribute has been set to FALSE.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_SELECTALL	"vpPlaneObject.selectAddAll"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_UNSELECTALL
| Description:  This action attribute automatically unselects all currently
|		selected objects.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_UNSELECTALL	"vpPlaneObject.selectDeleteAll"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_WIDTH
| Description:  The canvas width of the canvas workspace plane.
| Type:         int
| Default:      3000
| Legal Values: value > 0
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_WIDTH	"vpPlaneObject.preferredWidth"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_HEIGHT
| Description:  The canvas height of the canvas workspace plane.
| Type:         int
| Default:      3000
| Legal Values: value > 0
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_CANVAS_HEIGHT	"vpPlaneObject.preferredHeight"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_GRID
|
| Description:  This attribute indicates when a grid should be displayed on
|               the canvas.
|               .symbol index KMANAGER_GRID_OFF
|               specifies that the grid is always off.
|               .symbol index KMANAGER_GRID_ON
|               specifies that the grid is always on.
|               .symbol index KMANAGER_GRID_EDIT
|               specifies that the grid is only on when the canvas is in
|               "edit mode".  The canvas can be put in edit mode by the user,
|               or through the application by setting the manager object
|               attribute
|               .symbol index XVW_EDIT_MODE_ON
|               to TRUE.
|               .symbol index KMANAGER_GRID_SELECT
|               specifies that the grid is only displayed when a child of the
|               canvas has been selected by the user, or through the
|               application by setting the manager object attribute
|               .symbol index XVW_SELECT_ADD
|               to TRUE.
|
| Type:         int
| Default:      .symbol index KMANAGER_GRID_ON
| Legal Values: .symbol index KMANAGER_GRID_OFF
|               .symbol index KMANAGER_GRID_ON
|               .symbol index KMANAGER_GRID_EDIT
|               .symbol index KMANAGER_GRID_SELECT
| Resource:     canvasGrid
------------------------------------------------------------------------*/
/* XVW_CANVAS_GRID is really defined in ManagerManip.h */

/*------------------------------------------------------------------------
| Attribute:     XVW_CANVAS_GRIDSIZE
| Description:   The dimensions of the grid, given in pixels.
| Type:          int
| Default:       15
| Legal Values:  value > 0
| Resource:      canvasGridsize
------------------------------------------------------------------------*/
/* XVW_CANVAS_GRIDSIZE is really defined in ManagerManip.h */



/*
 *  Define the Class name, by which people should be externally referencing
 *  the Canvas Object by.
 */
#define CanvasWidgetClass	xvwCanvasWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration CanvasWidgetClass
 */
extern   WidgetClass     CanvasWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Canvas Object
 */
xvobject xvw_create_canvas PROTO((xvobject, char *));


#endif /* _xvobjects_Canvas_h_ */
/* Do not add after this line */
