 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  Browser Widget
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Browser_h_
#define _xvobjects_Browser_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_LIST_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               list object component of the the browser object that
|               indicates a "list" of directory selections.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The list object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BROWSER_LIST_OBJECT	"browserListObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_CANCEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               cancel button component of the the browser object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The cancel button (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BROWSER_CANCEL_OBJECT	"browserCancelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_FILENAME_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               input/output file object component of the the browser object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The input/output file object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BROWSER_FILENAME_OBJECT	"browserFilenameObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_FILTER_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               filter object component of the the browser object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The filter object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BROWSER_FILTER_OBJECT	"browserFilterObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               label object component of the the browser object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BROWSER_LABEL_OBJECT	"browserLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_DIRECTORY
|
| Description:  This attribute allows you to set or get the
|               directory currently selected within the browser.
|
| Type:         char *
| Default:      NULL
| Legal Values: any legal directory path
| Resource:	browserDirectory
------------------------------------------------------------------------*/
#define XVW_BROWSER_DIRECTORY  "browserDirectory"

/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_FILTER
|
| Description:  If desired, a filter may be specified to control which
|               files appear in the file list displayed to the user by
|               the browser.  Using the filter, the browser can be used to
|               display only files with a particular postfix, or only
|               files beginning with a special prefix, or only files whose
|               names contain a certain character or a specified string.
|               This attribute allows you to set or get the filter currently
|               being used with in the browser list.
|
|               For example, ".*\.c" would specify all files in the
|               directory ending in the ".c" postfix.  For more details
|               on expressions that may be provided to the regular expression
|               parser used to implement the browser filter feature, see
|               the man page on kre_comp, or the chapter on Basic Services
|               in the Programming Services Manual Volume I, Foundation
|               Services.
|
| Type:         char *
| Default:      NULL
| Legal Values: any legal regular expression string
| Resource:	browserFilter
------------------------------------------------------------------------*/
#define XVW_BROWSER_FILTER  "browserFilter"

/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the browser object which will be fired when
|               the user enters new text and presses <cr>.
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(browserobj, XVW_BROWSER_CALLBACK,
|                                browser_cb, client_data);
|               .end code
|               Note that the current text appearing in the browser object 
|		will be passed to the callback in the \fIcall_data\fP.  The 
|		value must be cast to a string before use, as in:
|               .br
|               \f(CWchar *string = *((char **) call_data);\fP
|               .br
|               Alternatively, the filename may be obtained with
|               .symbol index XVW_BROWSER_TEXT .
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_BROWSER_CALLBACK		"browserCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_BROWSER_DIRECTORY_PIXMAPFILE
|
| Description:  This is the file defining the pixmap that appears at the 
|               upper left of the browser object when the browser is in
|		directory mode. 
|
| Type:         char *
| Default:      The browser.xpm file in the \fIxvobjects/misc/pixmaps\fP 
|               directory, which defines the "directory browser" pixmap.
| Legal Values: The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX. 
| Resource:     browserDirectoryPixmapfile
------------------------------------------------------------------------*/
#define XVW_BROWSER_DIRECTORY_PIXMAPFILE    "browserDirectoryPixmapfile"
 
/*------------------------------------------------------------------------
| Attribute:    XVW_BROWSER_DIRECTORY_PIXMAP
|
| Description:  This is the pixmap that appears to the upper 
|               left of the browser object when the browser is in directory
|		mode.  Candidates for the value
|               of this attribute may be created with the use
|               of \fIXCreatePixmap()\fP;  see \fIThe Xlib Reference Manual\fP
|               by O'Reilly and Associates.  Note that this attribute is
|               mutually exclusive with
|               .symbol index XVW_BROWSER_PIXMAPFILE ;
|               specify one or the other, not both.
|
| Type:         Pixmap
| Default:      The "directory browser" pixmap.
| Legal Values: Valid Pixmap structure
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_BROWSER_DIRECTORY_PIXMAP        "browserDirectoryPixmap"

/*------------------------------------------------------------------------
| Attribute:    XVW_BROWSER_ALIASES_PIXMAPFILE
|
| Description:  This is the file defining the pixmap that appears at the 
|               upper left of the browser object when the browser is in
|		aliases mode. 
|
| Type:         char *
| Default:      The browser.xpm file in the \fIxvobjects/misc/pixmaps\fP 
|               directory, which defines the "aliases browser" pixmap.
| Legal Values: The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX. 
| Resource:     browserAliasesPixmapfile
------------------------------------------------------------------------*/
#define XVW_BROWSER_ALIASES_PIXMAPFILE    "browserAliasesPixmapfile"
 
/*------------------------------------------------------------------------
| Attribute:    XVW_BROWSER_ALIASES_PIXMAP
|
| Description:  This is the pixmap that appears to the upper 
|               left of the browser object when the browser is in aliases
|		mode.  Candidates for the value
|               of this attribute may be created with the use
|               of \fIXCreatePixmap()\fP;  see \fIThe Xlib Reference Manual\fP
|               by O'Reilly and Associates.  Note that this attribute is
|               mutually exclusive with
|               .symbol index XVW_BROWSER_PIXMAPFILE ;
|               specify one or the other, not both.
|
| Type:         Pixmap
| Default:      The "aliases browser" pixmap.
| Legal Values: Valid Pixmap structure
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_BROWSER_ALIASES_PIXMAP        "browserAliasesPixmap"

/*------------------------------------------------------------------------
| Attribute:	XVW_BROWSER_DESTROY_ON_QUIT
| Description:  If FALSE, the browser object will not be destroyed when the 
|		user clicks on the "Cancel" button or selects a file, but
|		will simply be unmapped so that it can be used again.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	browserDestroyOnQuit
------------------------------------------------------------------------*/
#define XVW_BROWSER_DESTROY_ON_QUIT "browserDestroyOnQuit"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Browser Object by.
 */
#define BrowserWidgetClass	xvwBrowserWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration BrowserWidgetClass
 */
extern   WidgetClass     BrowserWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Browser Object
 */
xvobject xvw_create_browser PROTO((xvobject, char *));


#endif /* _xvobjects_Browser_h_ */
/* Do not add after this line */
