 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Procedure object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Jul 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_ProcedureP_h_
#define _xvlang_ProcedureP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvlang/Procedure.h>
#include <xvlang/GlyphP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

#define XtInheritRunCallback     ((void (*)())_XtInherit)

typedef struct _XvwProcedureWidgetClassPart
{
   kfunc_void run_callback;
   XtPointer  extension;
} XvwProcedureWidgetClassPart;

typedef struct _XvwProcedureWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwNodeWidgetClassPart	node_class;
   XvwGlyphWidgetClassPart	glyph_class;
   XvwProcedureWidgetClassPart	procedure_class;
} XvwProcedureWidgetClassRec;

extern  XvwProcedureWidgetClassRec xvwProcedureWidgetClassRec;

typedef struct
{
   xvobject workspace;		/* the workspace object */
   xvobject open;		/* the open workspace object */

   Pixmap procedure_pixmap;  /* the pixmap to be displayed in the procedure */
   Pixmap open_pixmap;       /* the pixmap to open a workspace */

} XvwProcedurePart;


typedef struct _XvwProcedureWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwNodePart		node;
  XvwGlyphPart		glyph;
  XvwProcedurePart	procedure;

} XvwProcedureWidgetRec;

typedef struct {int empty;} XvwProcedureConstraintsPart;

typedef struct _XvwProcedureWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwNodeConstraintsPart	node;
    XvwGlyphConstraintsPart	glyph;
    XvwProcedureConstraintsPart	procedure;
} XvwProcedureWidgetConstraintsRec, *XvwProcedureWidgetConstraints;

typedef struct  _XvwProcedureWidgetClassRec  *XvwProcedureWidgetClass;
typedef struct  _XvwProcedureWidgetRec       *XvwProcedureWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwProcedureWidget
 */
extern XvwProcedureWidgetClassRec xvwProcedureWidgetClassRec;


#endif /* _xvlang_ProcedureP_h_ */
/* Do not add after this line */
