 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for Node object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_NodeP_h_
#define _xvlang_NodeP_h_

        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <xvlang/Node.h>
#include <xvobjects/ManagerP.h>


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

#define XtInheritCheckNode     ((int (*)())_XtInherit)
#define XtInheritExecNode      ((void (*)())_XtInherit)

typedef struct _XvwNodeWidgetClassPart
{
   kfunc_int  check_node;
   kfunc_void exec_node;
   XtPointer  extension;

} XvwNodeWidgetClassPart;

typedef struct _XvwNodeWidgetClassRec
{
   CoreClassPart		core_class;
   CompositeClassPart		composite_class;
   ConstraintClassPart		constraint_class;
   XvwManagerWidgetClassPart	manager_class;
   XvwNodeWidgetClassPart	node_class;
} XvwNodeWidgetClassRec;

extern  XvwNodeWidgetClassRec xvwNodeWidgetClassRec;

typedef struct
{
   int     type;
   Boolean placement;
   Boolean leave;
   Boolean modified;
   Boolean show_dav;
   Boolean show_modified;
   Boolean remote_enable;
   XtCallbackList run_callback;
   XtCallbackList modified_callback;

   String   name;
   Pixmap   pixmap;
   xvobject label;
   xvobject icon;
   Boolean  runnable;
   Boolean  testing;
   Boolean  running;

} XvwNodePart;


typedef struct _XvwNodeWidgetRec
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  XvwManagerPart	manager;
  XvwNodePart		node;

} XvwNodeWidgetRec;

typedef struct {int empty;} XvwNodeConstraintsPart;

typedef struct _XvwNodeWidgetConstraintsRec {
    XvwManagerConstraintsPart	manager;
    XvwNodeConstraintsPart	node;
} XvwNodeWidgetConstraintsRec, *XvwNodeWidgetConstraints;

typedef struct  _XvwNodeWidgetClassRec  *XvwNodeWidgetClass;
typedef struct  _XvwNodeWidgetRec       *XvwNodeWidget;


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwNodeWidget
 */
extern XvwNodeWidgetClassRec xvwNodeWidgetClassRec;


#endif /* _xvlang_NodeP_h_ */
/* Do not add after this line */
