 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions for Khoros FinderList Object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Jul 02, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_FinderList_h_
#define _xvlang_FinderList_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:    XVW_FINDERLIST_EXPRESSION
| Description:  The regular expression used within the finder list.  The
|		regular expression which uses the following syntax.
|
|		 .             Match any single character except newline
|
|		*             Match the preceding character or range
|		              of characters 0 or more times.  The
|		              matching includes items within a [...].
|		
|		[...] or [^..]  Matches any one character contained within
|		                the brackets. If the first character after
|		                the '[' is the ']', then it is included in
|		                the characters to match.  If the first
|		                character after the '[' is a '^', then it
|		                will match all characters NOT included in
|		                the [].  The '-' will indicate a range of
|		                characters.  For example, [a-z] specifies
|		                all characters between and including the
|		                ascii values 'a' and 'z'.  If the '-'
|		                follows the '[' or is right before the ']'
|		                then it is interpreted literally.
|		
|		^             If this is the first character of the
|		              regular expression, it matches the beginning
|		              of the line.
|		
|		$             If this is the last character of the
|		              regular expression, it matches the end of
|		              the line.
|		
|		\\            This escapes the meaning of a special character.
|
| Type:         char *
| Default:      NULL
| Legal Values: any regular expression
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FINDERLIST_EXPRESSION  "finderlistExpression"

/*------------------------------------------------------------------------
| Attribute:    XVW_FINDERLIST_SELECT
| Description:  If desired, a callback may be installed on the finderlist
|		object that will be fired each time an entry is selected
|		within the finderlist.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: N/A
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FINDERLIST_SELECT	   "finderlistSelect"

/*------------------------------------------------------------------------
| Attribute:    XVW_FINDERLIST_CREATE
| Description:  If desired, a callback may be installed on the finderlist
|               object that will be fired each time an entry is desired
|               to be created by the user.  This currently specified by
|		either the user "double" clicking on an entry, or the
|		programmer using the
|		.symbol index XVW_FINDERLIST_OPEN
|		\fIaction attribute\fP.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: N/A
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FINDERLIST_CREATE	   "finderlistCreate"

/*------------------------------------------------------------------------
| Attribute:    XVW_FINDERLIST_OPEN
| Description:  This \fIaction attribute\fP causes the
|		.symbol index XVW_FINDERLIST_CREATE
|		to be fired with the currently selected finder entry.
| Type:         int
| Default:      N/A
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_FINDERLIST_OPEN	   "finderlistOpen"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the FinderList Object by.
 */
#define FinderListWidgetClass	xvwFinderListWidgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration FinderListWidgetClass
 */
extern   WidgetClass     FinderListWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for FinderList Object
 */
xvobject xvw_create_finderlist PROTO((xvobject, char *));


#endif /* _xvlang_FinderList_h_ */
/* Do not add after this line */
