 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       Zoom widget.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 15:01
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Zoom_h_
#define _xvisual_Zoom_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Zoom Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_ZOOM_FACTOR
| Description:  .include  $DESIGN/manual/shared/xvisual/zoom/ZoomFactor.sec
| Type:         double
| Default:      1.0
| Legal Values: value > 0.0
| Resource:     zoomFactor
------------------------------------------------------------------------*/
#define  XVW_ZOOM_FACTOR	 "zoomFactor"

/*------------------------------------------------------------------------
| Attribute:    XVW_ZOOM_LOCATIONMARKER
|
| Description:  This attributes specifies the marker (cursor) which will be 
|               used to mark the center of the zoom window.  Typically the 
|               zoom position should always be in the center of the zoom 
|               window, but if center image is FALSE, then the zoom object 
|               will reposition the position.  In this case it is helpful to 
|               have an indicator that shows this position.  The available
|               marker types include a cross, a box, and a dot (or none).
|
| Type:         int
| Default:      .symbol index KZOOM_LM_CROSS
| Legal Values: .symbol index KZOOM_LM_NONE
|               .symbol index KZOOM_LM_CROSS
|               .symbol index KZOOM_LM_BOX
|               .symbol index KZOOM_LM_DOT
| Resource:     zoomLocationmarker
------------------------------------------------------------------------*/
#define  XVW_ZOOM_LOCATIONMARKER "zoomLocationmarker"

/*------------------------------------------------------------------------
| Attribute:    XVW_ZOOM_UPDATEMODE
| Description:  .include $DESIGN/manual/shared/xvisual/zoom/UpdateMode.sec
| Type:         int
| Default:      .symbol index KZOOM_UM_CONTINUOUS
| Legal Values: .symbol index KZOOM_UM_CONTINUOUS
|               .symbol index KZOOM_UM_BUTTON_PRESS
| Resource:     zoomUpdatemode
------------------------------------------------------------------------*/
#define  XVW_ZOOM_UPDATEMODE	 "zoomUpdatemode"

/*------------------------------------------------------------------------
| Attribute:    XVW_ZOOM_INTERPOLATE
| Description:  Sets the type of interpolation.  Currently, this can only be 
|               KZERO_ORDER, which is pixel replication.
| Type:         int
| Default:      .symbol index KZERO_ORDER
| Legal Values: .symbol index KZERO_ORDER
| Resource:     zoomInterpolate
------------------------------------------------------------------------*/
#define  XVW_ZOOM_INTERPOLATE	 "zoomInterpolate"


/*
 *  Value definitions for Zoom Visual Object
 */
/*
 *  The following series of includes, defines, and declaration are used
 *  by the user with the Zoom utilities to create, delete, retrieve, and
 *  change attributes.  These calls aren't used by the X Toolkit but by
 *  the display library.  The section belows shows how these two sections
 *  are internally tied together.
 */
/* location marker types */
#define KZOOM_LM_NONE		0
#define KZOOM_LM_CROSS		1
#define KZOOM_LM_BOX		2
#define KZOOM_LM_DOT		3

/* update mode types */
#define KZOOM_UM_CONTINUOUS	0
#define KZOOM_UM_BUTTON_PRESS	1
#define KZOOM_UM_RUBBER_BAND	2
#define KZOOM_UM_APP_DEPENDANT	3

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Zoom Object by.
 */
#define ZoomWidgetClass	xvwZoomWidgetClass

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for ZoomWidgetClass
 */
extern   WidgetClass     ZoomWidgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Zoom Visual Object
 */
xvobject xvw_create_zoom  PROTO((xvobject, char *));

#endif /* _xvisual_Zoom_h_ */
/* Don't add after this point */
