 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical timer annotation.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Oct 23, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Timer_h_
#define _xvisual_Timer_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Timer Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_TIMER_UPDATETIME
|
| Description:  This attribute indicates how often the timer is updated,
|		given in fractions of a second. If, for example,
|		.symbol index XVW_TIMER_UPDATETIME
|		is set to 0.25, this indicates that the timer will update
|		every 0.25 seconds, or 4 times a second.  Note that the
|		timer can only be as accurate as your computer system clock.
|		 
| Type:         double
| Default:      0.1
| Legal Values: values > 0.0
| Resource:     timerUpdatetime
------------------------------------------------------------------------*/
#define XVW_TIMER_UPDATETIME   "timerUpdatetime"

/*------------------------------------------------------------------------
| Attribute:   	XVW_TIMER_COUNTER
|
| Description: 	This attribute specifies the time (in seconds) at which
|		the timer is started.  Usually,  this value is left at
|		the default, 0.0, as (like a stopwatch) the timer is 
|		considered to be "turned on" at time = 0.0.  However, 
|		there may are occasions when the "turn on" time is 
|		at some time later than 0.
|
| Type:         double 
| Default:      0.0 
| Legal Values: values >= 0.0 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_TIMER_COUNTER      "timerCounter"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Timer Object by.
 */
#define TimerGadgetClass	xvwTimerGadgetClass

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for TimerGadgetClass
 */
extern   WidgetClass     TimerGadgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Timer Visual Object
 */
xvobject xvw_create_timer PROTO((xvobject, char *));


#endif /* _xvisual_Timer_h_ */
/* Don't add after this point */
