 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       Palette widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 16, 1992 16:20
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Palette_h_
#define _xvisual_Palette_h_

    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for Palette Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_PALETTE_CALLBACK
|
| Description:  If desired, a callback may be installed on the palette visual
|               object, which will be fired when a color cell on the palette
|               has been selected by the user.
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                   xvobject object,
|                   kaddr client_data,
|                   kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PALETTE_CALLBACK	"paletteCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_PALETTE_TYPE
| Description:  .include $DESIGN/manual/shared/xvisual/palette/Type.sec
| Type:         int
| Default:      .symbol index KPALETTE_TYPE_COLORBAR
| Legal Values: .symbol index KPALETTE_TYPE_COLORBAR
|               .symbol index KPALETTE_TYPE_COLORCELL
|               .symbol index KPALETTE_TYPE_COLORWHEEL
| Resource:     paletteType
------------------------------------------------------------------------*/
#define XVW_PALETTE_TYPE	"paletteType"

/*
 *  Palette type for the controlling how the palette should be displayed.
 *  The choices are rectangular, gridded, spherical...
 */
#define KPALETTE_TYPE_COLORBAR	 1
#define KPALETTE_TYPE_COLORCELL	 2
#define KPALETTE_TYPE_COLORWHEEL 3

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Palette Object by.
 */
#define PaletteWidgetClass	xvwPaletteWidgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration for PaletteWidgetClass
 */
extern   WidgetClass     PaletteWidgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for Palette Visual Object
 */
xvobject xvw_create_palette  PROTO((xvobject, char *));


#endif /* _xvisual_Palette_h_ */
/* Don't add after this point */
