 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       marker annotation.
   >>>>
   >>>>    Written By: Steven Kubica, John Salas, & Mark Young
   >>>>
   >>>>          Date: Aug 12, 1992 10:52
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Marker_h_
#define _xvisual_Marker_h_

    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for Marker Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_MARKER_XPLACEMENT
| Description:  .include $DESIGN/manual/shared/xvisual/marker/MarkerXPlacement.sec
| Type:         double
| Default:      0.0
| Legal Values: any double world coordinate value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_MARKER_XPLACEMENT     "markerXplacement"

/*------------------------------------------------------------------------
| Attribute:    XVW_MARKER_YPLACEMENT
| Description:  .include $DESIGN/manual/shared/xvisual/marker/MarkerYPlacement.sec
| Type:         double
| Default:      0.0
| Legal Values: any double world coordinate value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_MARKER_YPLACEMENT     "markerYplacement"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_MARKERTYPE
| Description:  The marker type.
| Type:         int
| Default:      .symbol index KMARKER_SQUARE
| Legal Values: .symbol index KMARKER_NONE
|               .symbol index KMARKER_ARC
|               .symbol index KMARKER_BOW_TIE
|               .symbol index KMARKER_BOX
|               .symbol index KMARKER_CARET
|               .symbol index KMARKER_CIRCLE
|               .symbol index KMARKER_CROSS
|               .symbol index KMARKER_DAGGER
|               .symbol index KMARKER_DIAMOND
|               .symbol index KMARKER_DOT
|               .symbol index KMARKER_HEXAGON
|               .symbol index KMARKER_POINT
|               .symbol index KMARKER_SQUARE
|               .symbol index KMARKER_TRIANGLE
|               .symbol index KMARKER_X
|               .symbol index KMARKER_V
| Resource:     graphicsMarkertype
------------------------------------------------------------------------*/

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Animate Object by.
 */
#define MarkerGadgetClass	xvwMarkerGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration for MarkerGadgetClass
 */
extern   WidgetClass     MarkerGadgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for Marker Visual Object
 */
xvobject xvw_create_marker PROTO((xvobject, char *));


#endif /* _xvisual_Marker_h_ */
/* Don't add after this point */
