 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for graphics attributes that
   >>>>                control the world coordinate system.
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_GraphicsWC_h_
#define _xvisual_GraphicsWC_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_RESET_WORLD
|
| Description:  This action attribute will cause the object to search all 
|               its children for the overall maximum and minimum, and will 
|               adjust the global maximum and minimum accordingly, so that all 
|               visual objects within the object are shown.  Note that
|               it is used \fIonly\fP with the \fIarea\fP object.
|
| Type:         int
| Default:      N/A (action attribute)
| Legal Values: TRUE/FALSE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_RESET_WORLD	"graphicsResetWorld"


/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_WCMIN_X
|
| Description:  This is the minimum world coordinate value for X.
|
| Type:         double
| Default:      0.0
| Legal Values: value <
|               .symbol index XVW_GRAPHICS_WCMAX_X
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_WCMIN_X		"graphicsWcminX"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_WCMIN_Y
|
| Description:  This is the minimum world coordinate value for Y.
|
| Type:         double
| Default:      0.0
| Legal Values: value <
|               .symbol index XVW_GRAPHICS_WCMAX_Y
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_WCMIN_Y		"graphicsWcminY"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_WCMIN_Z
|
| Description:  This is the minimum world coordinate value for Z.
|               Note that this attribute only applies to 3D objects.
|
| Type:         double
| Default:      0.0
| Legal Values: value <
|               .symbol index XVW_GRAPHICS_WCMAX_X
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_WCMIN_Z		"graphicsWcminZ"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_WCMAX_X
|
| Description:  This is the maximum world coordinate value for X.
|
| Type:         double
| Default:      1.0
| Legal Values: value > 
|               .symbol index XVW_GRAPHICS_WCMIN_X
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_WCMAX_X		"graphicsWcmaxX"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_WCMAX_Y
|
| Description:  This is the maximum world coordinate value for Y.
|
| Type:         double
| Default:      1.0
| Legal Values: value > 
|               .symbol index XVW_GRAPHICS_WCMIN_Y
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_WCMAX_Y		"graphicsWcmaxY"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_WCMAX_Z
|
| Description:  This is the maximum world coordinate value for Z.
|               Note that this attribute only applies to 3D objects.
|
| Type:         double
| Default:      1.0
| Legal Values: value > 
|               .symbol index XVW_GRAPHICS_WCMIN_Z
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_WCMAX_Z		"graphicsWcmaxZ"

#endif /* _xvisual_GraphicsWC_h_ */
/* Don't add after this point */
