 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       circle annotation.
   >>>>
   >>>>    Written By: John Salas & Mark Young & Steve Kubica
   >>>>
   >>>>          Date: Aug 05, 1992 13:03
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Circle_h_
#define _xvisual_Circle_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attributes for Circle Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:     XVW_CIRCLE_XCENTER
| Description:   .include $DESIGN/manual/shared/xvisual/circle/XCenter.sec
| Type:          double
| Default:       0.0
| Legal Values:  +/- double
| Resource:      N/A
------------------------------------------------------------------------*/
#define XVW_CIRCLE_XCENTER	"circleXcenter"

/*------------------------------------------------------------------------
| Attribute:     XVW_CIRCLE_YCENTER
| Description:   .include $DESIGN/manual/shared/xvisual/circle/YCenter.sec
| Type:          double
| Default:       0.0
| Legal Values:  +/- double
| Resource:      N/A
------------------------------------------------------------------------*/
#define XVW_CIRCLE_YCENTER	"circleYcenter"

/*------------------------------------------------------------------------
| Attribute:     XVW_CIRCLE_RADIUS
| Description:   .include $DESIGN/manual/shared/xvisual/circle/Radius.sec
| Type:          double
| Default:       1.0
| Legal Values:  +/- double
| Resource:      N/A
------------------------------------------------------------------------*/
#define XVW_CIRCLE_RADIUS	"circleRadius"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Circle Object by.
 */
#define CircleGadgetClass	xvwCircleGadgetClass

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Circle Visual Object
 */
xvobject xvw_create_circle PROTO((xvobject, char *));


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration CircleGadgetClass
 */
extern   WidgetClass     CircleGadgetClass;


#endif /* _xvisual_Circle_h_ */
/* Don't add after this point */
