#include <xvinclude.h>

/*
 *   This program illustrates the use of the menubutton object; it 
 *   emphasizes the compound nature of the menubutton object, which consists 
 *   of the menu button itself, plus the submenu which contains the buttons
 *   and/or labels which are displayed when the user clicks on the menubutton.
 */

#define PAIR_NUM 5

void button_cb PROTO((xvobject, kaddr, kaddr));
void quit_cb   PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int      i;
	char     temp[KLENGTH];
	xvobject manager;
	xvobject menubutton;
	xvobject submenu;
	xvobject button;
	xvobject label;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidget library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
		           XVW_WIDTH,  100,   /* 100 pixels wide */
		           XVW_HEIGHT, 100,   /* 100 pixels high */
		           NULL);

	/*
	 *  create the menubutton, which is actually a compound object
         *  consisting of two xvobjects: 
         *    1) the menubutton, which is always displayed, and on which the
         *                       user may click to display the submenu
         *    2) the submenu,    which will be the parent to the buttons 
         *                       & labels on the menu.
	 */
	menubutton = xvw_create_menubutton(manager, "menubutton");

	/*
    	 *  set the label of the menubutton, and center it in the middle
         *  of the manager backplane.
	 */
	xvw_set_attributes(menubutton, 
		   XVW_LABEL,   "Menu Button", /* Set label.               */
		   XVW_ABOVE,    NULL,      /* By setting all the          */
		   XVW_BELOW,    NULL,      /* relative positioning        */
		   XVW_LEFT_OF,  NULL,      /* attributes to NULL, put the */
		   XVW_RIGHT_OF, NULL,      /* button in middle of manager */
		   NULL);

	/*
	 *  once the menubutton is created, you can obtain the submenu
         *  with the function named appropriately.
	 */
	submenu = xvw_retrieve_menu(menubutton);

	/*
	 *  want to have 5 pairs of buttons & labels appear on the submenu.
         *  create the buttons and labels, using submenu as the parent.
	 */
	for (i = 0; i < PAIR_NUM; i++)
	{
	   /* 
            *  Alternate buttons with labels on the menu.  Both the labels and
	    *  buttons are labelled incrementally;  on a menu, each item will
            *  automatically be placed beneath the last, there is no need to
            *  use positioning attributes (in fact, they are ignored).
            *  Install the "button_cb" callback on the buttons.
            */
	   sprintf(temp, "button%d", i+1); 
	   button = xvw_create_button(submenu, "button");
	   xvw_set_attribute(button, XVW_LABEL,  temp);
	   xvw_add_callback(button, XVW_BUTTON_SELECT,
			    button_cb, NULL);

	   sprintf(temp, "label%d", i+1);
	   label  = xvw_create_label(submenu, "label");
	   xvw_set_attribute(label, XVW_LABEL,  temp);
	}

	/*
 	 *  last, put in a button with a callback that will allow
         *  the user to quit the program.
	 */
	button = xvw_create_button(submenu, "button");
        xvw_set_attribute(button, XVW_LABEL,  "Quit");
        xvw_add_callback(button, XVW_BUTTON_SELECT,
                         quit_cb, NULL);

	/* display and run the program */
	xvf_run_form();
}

void button_cb (
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	char *label;

        xvw_get_attribute(object, XVW_LABEL, &label);
        fprintf(stderr, "Selection of '%s'\n", label);
}

void quit_cb (
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	exit(0);
}
