#include <xvinclude.h>


/*
 *   This program puts up two list objects; it emphasizes the compound nature
 *   of the list object which consists of a scrolled backplane and the actual
 *   list object.
 *
 *   The xvw_change_list() routine is used to set the lists' contents; 
 *   passing different values for the last argument to xvw_change_list 
 *   determine whether a scrollbar will appear.  
 *
 *   A very simple callback is added to the list items, which prints out the 
 *   index and string associated with a list item when the user selects it.
 *
 *   This example also serves to illustrate the use of call_data.
 *
 */
void list_item_cb PROTO((xvobject, kaddr, kaddr));
void quit_cb      PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject manager;
        xvobject button;
	int      num1,  num2;
        xvobject list1, list2, actual_list;

        static char *geographical_strings[] = {
                "mountains", "rivers", "oceans", "plains",
                "forests", "deserts", "marshes", "reefs",
                "glaciers", "jungles"
        };

        static char *animal_strings[] = {
		"bears", "cats", "fish", "cockroaches", "birds",
		"spiders", "dogs", "lizards", "frogs",
		"tigers", "dolphins", "rabbits", "mooses",
		"monkeys", "antelopes"
        };

	/* 
	 * "knumber" is a convenient routine that counts the number of items
         *  in a static array of strings
         */
        num1 = knumber(geographical_strings);
        num2 = knumber(animal_strings);

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidget library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror("example", "main", "Cannot open display");
           kexit(KEXIT_FAILURE);
        }

	/* create a manager backplane */
        manager = xvw_create_manager(NULL, "back");
        xvw_set_attributes(manager,
                           XVW_RESIZABLE,       TRUE,
                           XVW_MAP_WHEN_MANAGED,TRUE,
                           NULL);

	/*
	 * create the first list. the list object is a compound object,
         * consisting of:
         *		1 - a scrolled backplane
         *	        2 - the actual list
	 */
        list1 = xvw_create_list(manager, "list1");
        xvw_set_attributes(list1,
                     XVW_RESIZABLE,     TRUE,   /* resizable         */
                     XVW_CHAR_WIDTH,    20.0,   /* width of 20 chars */
                     XVW_CHAR_HEIGHT,   5.0,    /* height of 5 chars */
                     XVW_BELOW,         NULL,   /* at the top        */
                     XVW_RIGHT_OF,      NULL,   /* at the left edge  */
                     NULL);

	/*
	 * retrieve the list component of the list object, so that
         * we can set the contents of it, set attributes on it,
         * and install the callback.
	 */
	actual_list = xvw_retrieve_list(list1);

        /*
	 * Use xvw_change_list() to set the contents of the list.
         * Since the last parameter on xvw_change_list() is TRUE, 
         * XVW_CHAR_WIDTH and XVW_CHAR_HEIGHT will be => over-ridden
         * by the actual width & height of the list.   So, xvw_change_list() 
         * is being allowed to resize the list widget to fit the given list; 
	 * thus, there will NOT be a scroll bar on the first list.
         */
        xvw_change_list(actual_list, geographical_strings, num1, TRUE);
	xvw_set_attribute(actual_list, XVW_LIST_HIGHLT_ELEM, 3);
	xvw_set_attribute(actual_list, XVW_LIST_UNHIGHLT_ELEM, 3);

	/*
	 * add the list_item_cb() callback on the list.
	 */
        xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT, 
			 list_item_cb, "list1");

	/*
         * Since the last parameter on xvw_change_list() is FALSE, the second
         * list is constrained to the width and height indicated by the
         * values of the XVW_CHAR_WIDTH and XVW_CHAR_HEIGHT attributes.  
         * Since the list is too big to fit in the space specified, a 
         * scrollbar will appear.
         */
        list2 = xvw_create_list(manager, "list2");
        xvw_set_attributes(list2,
                     XVW_RESIZABLE,     TRUE,   /* resizable         */
                     XVW_RIGHT_OF,      list1,  /* R of the 1st list */
                     XVW_CHAR_WIDTH,    20.0,   /* width of 20 chars */
                     XVW_CHAR_HEIGHT,   5.0,    /* height of 5 chars */
                     XVW_BELOW,         NULL,   /* at the top        */
                     NULL);
	actual_list = xvw_retrieve_list(list2);

        xvw_change_list(actual_list, animal_strings, num2, FALSE);
        xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT, 
		         list_item_cb, "list2");

	/* Add a button to quit the program */
        button = xvw_create_button(manager, "button");
        xvw_set_attributes(button, 
			   XVW_LABEL,  "Quit",
			   XVW_BELOW,  list2,
			   XVW_LEFT_OF, NULL,
			   NULL);
        xvw_add_callback(button, XVW_BUTTON_SELECT, quit_cb, NULL);

	/* display and run */
        xvf_run_form();
}

void list_item_cb (
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	xvw_list_struct *list_return;
	char  *title = (char *) client_data;

	/*
	 * a list object is one of the few objects that uses a call_data
         * structure.  it needs to => return information to the caller,
         * so that information is returned via the call_data.  The data type
         * of the call_data is determined by the object itself;  a list
         * object uses a call_data of type "xvw_list_struct".  The 
         * xvw_list_struct data structure has two fields: a char *string,
         * and an int list_index.  
	 */
	list_return = (xvw_list_struct *) call_data;

	/*
	 * use contents of call_data structure to display index & string
	 */
	kfprintf(kstderr, "Chosen was item %d of %s, %s\n",
		 list_return->list_index, title, list_return->string);

}

void quit_cb (
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        exit(0);
}


