#include <xvinclude.h>

/*
 *  This example creates a simple labelstring object 
 *  that prints out those Famous Words, "Hello World".
 */

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
	xvobject object;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane to be a parent for the labelstr object */
	manager = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(manager,
			   XVW_CHAR_WIDTH,  20.0,
		           XVW_CHAR_HEIGHT, 3.0,
			   NULL);

	/*
         *  Create the labelstring object.  give it a label.
         *  tack it horizontally to the parent so that it spans the
         *  width of the manager backplane.  center it in the middle of
         *  the parent.
	 */
	object = xvw_create_labelstr(manager, "label");
	xvw_set_attributes(object,
		XVW_LABEL,     "Hello World",
		XVW_LEFT_OF,   NULL,
		XVW_RIGHT_OF,  NULL,
		XVW_ABOVE,     NULL,
		XVW_BELOW,     NULL,
		NULL);

	/* display & run the program */
	xvf_run_form();
}
