#include <xvinclude.h>

/*
 *  This program demonstrates the use of the viewport object.  A viewport
 *  with both horizontal and vertical scrollbars is created.  Then, a 
 *  line of labels is created along the left side (too many to fit in 
 *  visible space of viewport), and a line of labels is created in a row
 *  (too many to fit in visible space of viewport).  The viewport scrollbars
 *  can be used in order to see all the labels.
 */

#define LABEL_NUM 25
void main(
   int  argc,
   char **argv,
   char **envp)
{
	int    i;
	xvobject viewport;
	xvobject label;
	char     temp[KLENGTH];

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the viewport;  width & height of 512 (pixels) */
	viewport = xvw_create_viewport(NULL, "viewport");
	xvw_set_attributes(viewport,
		      XVW_WIDTH,	    512,
		      XVW_HEIGHT,	    512,
		      XVW_VP_ALLOW_HORIZ,   TRUE,  /* horiz. scrollbar */
		      XVW_VP_FORCE_HORIZ,   TRUE,  /* force scrollbar */
		      XVW_VP_ALLOW_VERT,    TRUE,  /* vert. scrollbar */
		      XVW_VP_FORCE_VERT,    TRUE,  /* force scrollbar */
		      XVW_RESIZABLE,	    TRUE,
		      XVW_SELECTABLE,	    TRUE,
		      XVW_MENUABLE,	    TRUE,
	              NULL);

	/* create a set of labels laid out vertically */
	for (i = 0; i < LABEL_NUM; i++)
	{
	   label = xvw_create_label(viewport, "label");
	   ksprintf(temp, "vert label %d", i+1);
	   xvw_set_attributes(label,
		      XVW_LABEL,	temp,  /* set the label         */
	              XVW_CHAR_XPOS,    0.0,   /* x placement of label  */
	              XVW_CHAR_YPOS,    i*5.0, /* y placement of label  */
		      XVW_CHAR_WIDTH,   12.0,  /* set width		*/
		      XVW_BORDER_WIDTH, 2,     /* border width 2	*/
	              NULL);
	}

	/* create a set of labels laid out horizontally */
	for (i = 0; i < LABEL_NUM; i++)
	{
	   label = xvw_create_label(viewport, "label");
	   ksprintf(temp, "horiz label %d", i+1);
	   xvw_set_attributes(label,
		      XVW_LABEL,	temp,  /* set the label         */
	              XVW_CHAR_XPOS,    i*20.0,   /* x placement of label  */
	              XVW_CHAR_YPOS,    10.0, /* y placement of label  */
		      XVW_CHAR_WIDTH,   12.0,  /* set width		*/
		      XVW_BORDER_WIDTH, 2,     /* border width 2	*/
	              NULL);
	}

	/* display & run program */
	xvf_run_form();
}
