#include <xvinclude.h>

/*
 *  The program demonstrates the help object.  The help object displays
 *  a help file which is formatted with "roff" commands.  The commands  
 *  are interpreted, and the formatted output displayed.  
 *
 *  % example
 *             displays the default help files in the "guise" help directory
 *
 *  % example {directory}
 *             displays the help files in the directory specified
 *
 *  IMPORTANT NOTE: this example will not work properly if you do not have
 *                  groff, gtbl, and geqn installed on your system.
 *
 *  ALSO NOTE: the help object takes a while to display. be patient.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject help;
        char     *filename = "./Capture.doc";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

        if (argc > 1)
           filename = argv[1];

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
        }

        /*
         *  Create the help object. Note that since the parent is NULL, a
         *  toplevel window will be created and the text displayed
         *  inside.  The XVW_HELP_FILENAME attribute is used to specify 
         *  the directory in which the help file(s) exist.  Note that help
         *  file(s) should be formatted with "roff" commands, which will be
         *  interpreted.
         */
        help = xvw_create_help(NULL, "Online Help");
        xvw_set_attributes(help,
                XVW_HELP_TITLE,     "Boy!  You sure do need help",
                XVW_HELP_FILENAME,   filename,
                XVW_HELP_QUITLABEL, "Quit!",
                NULL);
	xvw_set_attribute(help, XVW_MAXIMUM_HEIGHT, 350);

	/* display & run the program.  */
        xvf_run_form();
}
