#include <xvinclude.h>

/*
 *  This example creates a simple integer GUI object, which may
 *  be used for allowing the user to enter a integer.  
 *
 *  A callback is installed on the integer object so that when the 
 *  user changes the value of the integer either by entering a number
 *  in the text parameter box and hitting <cr> or by using the scrollbar,
 *  the current value is printed to the tty.
 *
 *  Note that the integer object should *not* be created directly in an 
 *  xvroutine, as use of the Integer (-i) UIS line in the *.form file is 
 *  both easier to use and a more standard use of the Khoros system.  
 *  However, the integer object is provided for use with hybrid xvroutines, 
 *  (such as this example) which do not use a "formalized" GUI as defined 
 *  in a *.form file.
 */
static void integer_cb PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
	xvobject object;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane to be a parent for the integer object */
	manager = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(manager,
			   XVW_WIDTH,       300,
		           XVW_HEIGHT,      100,
			   NULL);

	/*
         *  Create the integer object.  give it a label, a default value,
         *  and bound it with a minimum value of 0 and a maximum value of
         *  255.  tack it horizontally to the parent so that it spans the
         *  width of the manager backplane.  center it in the middle of
         *  the parent.
	 */
	object = xvw_create_integer(manager, "integer");
	xvw_set_attributes(object,
		XVW_INTEGER_LABEL,    "Integer",
		XVW_INTEGER_VALUE,     12,
		XVW_INTEGER_MINVALUE,  0,
		XVW_INTEGER_MAXVALUE,  100,
		XVW_TACK_EDGE,         KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	       NULL,
		XVW_BELOW,	       NULL,
		NULL);
	xvw_add_callback(object, XVW_INTEGER_CALLBACK, integer_cb, NULL);

	/* display & run the program */
	xvf_run_form();
}

/*
 *  the callback for the integer will be fired when the user changes the
 *  value of the integer, either by using the scrollbar or by entering
 *  a value in the text parameter box & hitting <cr>.  this callback simply
 *  prints the current value of the int.
 */
static void integer_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	int value;

	xvw_get_attribute(object, XVW_INTEGER_VALUE, &value);
	kfprintf(kstderr, "Value = %d\n", value);
}

