#include <xvinclude.h>

/*
 *  This example creates two buttons, a "start" and a "stop", and
 *  connects them with a connection object.  a callback is installed 
 *  that starts the connection "flowing" when the user clicks on "start",
 *  and stops it from "flowing" when the user clicks on "stop".
 */

void ConnectionCallback PROTO((xvobject, kaddr, kaddr));
xvobject connection, stop, start;

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* Initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "unable to open display");
	   kexit(1);
	}

	/* create the manager backplane, (200x200) pixels */
	manager = xvw_create_manager(NULL, "manager");
	xvw_set_attributes(manager,
		XVW_WIDTH,  200,
		XVW_HEIGHT, 200,
		NULL);

	/* create start button in the middle of the left side */
	start = xvw_create_button(manager, "start");
	xvw_set_attributes(start,
		XVW_LABEL,    "Start",
	        XVW_RIGHT_OF,  NULL,
	        XVW_BELOW,     NULL,
	        XVW_ABOVE,     NULL,
		NULL);

	/* create stop button in the middle of the right side */
	stop = xvw_create_button(manager, "stop");
	xvw_set_attributes(stop,
		XVW_LABEL,   "Stop",
	        XVW_LEFT_OF,  NULL,
	        XVW_BELOW,    start,
	        XVW_ABOVE,    NULL,
		NULL);

	/* create a connection between the two buttons.  */
	connection = xvw_create_connection(manager, "connection");
	xvw_set_attributes(connection,
		XVW_CONNECTION_BEGIN, start,
		XVW_CONNECTION_END,   stop,
		NULL);

	/* add callback on start button to start connection "flowing" */
	xvw_add_callback(start, XVW_BUTTON_SELECT, ConnectionCallback, NULL);

	/* add callback on stop button to stop connection from "flowing" */
	xvw_add_callback(stop,  XVW_BUTTON_SELECT, ConnectionCallback, NULL);

	/* display & run program */
	xvf_run_form();
}

/*
 *  here's the connection callback.  if the object passed in is the start
 *  button, it starts the connection flowing;  if the object passed in is
 *  the stop button, it stops the connection from flowing.
 */
void ConnectionCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	if (object == start)
	   xvw_set_attribute(connection, XVW_CONNECTION_START, TRUE);
	else
	   xvw_set_attribute(connection, XVW_CONNECTION_STOP, TRUE);
}
