#include <xvinclude.h>

/*
 *   This program serves as a more complicated example of using the
 *   XVW_ABOVE, XVW_BELOW, XVW_LEFT_OF, and XVW_RIGHT_OF attributes
 *   in order to lay out visual & GUI objects in different positions  
 *   with respect to their parent.  This particular example uses the four
 *   relative layout attributes XVW_ABOVE, (etc) to create 13 objects
 *   positioned at the FarLeftTop, CenterLowerMiddle, FarRightBottom, etc.
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	/* 
	 * note that widgets should be displayed in the same configuration
	 * as they are declared below
	 */
	xvobject manager;
	xvobject fl_top,       l_top, 	  c_top,      r_top,     fr_top, 
	         fl_umiddle,   l_umiddle, c_umiddle,  r_umiddle, fr_umiddle, 
	         fl_middle,    l_middle,  center,     r_middle,  fr_middle,
	         fl_lmiddle,   l_lmiddle, c_lmiddle,  r_lmiddle, fr_lmiddle, 
	         fl_bottom,    l_bottom,  c_bottom,   r_bottom,  fr_bottom;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the manager backplane: 512x512 pixels */
	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
		           XVW_WIDTH,   512, 
		           XVW_HEIGHT,  512,
		           NULL);

	/* lay out at center top */
	c_top = xvw_create_button(manager, "c top");
	xvw_set_attributes(c_top,
		XVW_BUTTON_SHAPE,  KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	  "CenterTop",
		XVW_BELOW,         NULL,
		XVW_LEFT_OF,       NULL,
		XVW_RIGHT_OF,      NULL,
		NULL);

	/* lay out at center bottom */
	c_bottom = xvw_create_button(manager, "c bottom");
	xvw_set_attributes(c_bottom,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "CenterBottom",
		XVW_ABOVE,          NULL,
		XVW_LEFT_OF,        NULL,
		XVW_RIGHT_OF,       NULL,
		NULL);

	/* lay out at far left middle */
	fl_middle = xvw_create_button(manager, "fl middle");
	xvw_set_attributes(fl_middle,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "FarLeftMiddle",
		XVW_ABOVE,          NULL,
		XVW_BELOW,          NULL,
		XVW_RIGHT_OF,       NULL,
		NULL);

	/* lay out at far right middle */
	fr_middle= xvw_create_button(manager, "fr middle");
	xvw_set_attributes(fr_middle,
		XVW_BUTTON_SHAPE,  KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	  "FarRightMiddle",
		XVW_ABOVE,         NULL,
		XVW_BELOW,         NULL,
		XVW_LEFT_OF,       NULL,
		NULL);

	/* lay out at far left top */
	fl_top = xvw_create_button(manager, "fl top");
	xvw_set_attributes(fl_top,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "FarLeftTop",
		XVW_BELOW,          NULL,
		XVW_RIGHT_OF,       NULL,
		NULL);

	/* lay out at far right top */
	fr_top = xvw_create_button(manager, "fr top");
	xvw_set_attributes(fr_top,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "FarRightTop",
		XVW_BELOW,          NULL,
		XVW_LEFT_OF,        NULL,
		NULL);

	/* lay out at far left bottom */
	fl_bottom = xvw_create_button(manager,"fl bottom");
	xvw_set_attributes(fl_bottom,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "FarLeftBottom",
		XVW_ABOVE,          NULL,
		XVW_RIGHT_OF,       NULL,
		NULL);

	/* lay out at far right bottom */
	fr_bottom = xvw_create_button(manager, "fr bottom");
	xvw_set_attributes(fr_bottom,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "FarRightBottom",
		XVW_ABOVE,          NULL,
		XVW_LEFT_OF,        NULL,
		NULL);

	/* lay out at exact center */
	center = xvw_create_button(manager, "center");
	xvw_set_attributes(center,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "Center",
		XVW_ABOVE,          NULL,
		XVW_BELOW,          NULL,
		XVW_RIGHT_OF,       NULL,
		XVW_LEFT_OF,        NULL,
		NULL);

	/* lay out at center upper middle */
	c_umiddle = xvw_create_button(manager, "cu mid");
	xvw_set_attributes(c_umiddle,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "CenterUpperMiddle",
		XVW_ABOVE,          center,
		XVW_BELOW,          c_top,
		XVW_RIGHT_OF,       NULL,
		XVW_LEFT_OF,        NULL,
		NULL);

	/* lay out at center lower middle */
	c_lmiddle = xvw_create_button(manager, "c lmid");
	xvw_set_attributes(c_lmiddle,
		XVW_BUTTON_SHAPE,  KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	  "CenterLowerMiddle",
		XVW_ABOVE,         c_bottom,
		XVW_BELOW,         center,
		XVW_RIGHT_OF,      NULL,
		XVW_LEFT_OF,       NULL,
		NULL);

	/* lay out at right middle */
	r_middle = xvw_create_button(manager, "r middle");
	xvw_set_attributes(r_middle,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "RightMiddle",
		XVW_ABOVE,          NULL,
		XVW_BELOW,          NULL,
		XVW_RIGHT_OF,       center,
		XVW_LEFT_OF,        fr_middle,
		NULL);

	/* lay out at left middle */
	l_middle = xvw_create_button(manager, "l middle");
	xvw_set_attributes(l_middle,
		XVW_BUTTON_SHAPE,   KBUTTON_SHAPE_OVAL,
		XVW_LABEL,	   "LeftMiddle",
		XVW_ABOVE,          NULL,
		XVW_BELOW,          NULL,
		XVW_RIGHT_OF,       fl_middle,
		XVW_LEFT_OF,        center,
		NULL);

	/* display & run the program */
	xvf_run_form();
}
