#include "xvinclude.h"


/*
 *   This example program puts up 5 buttons in a diagonal pattern.
 *   It adds very simple callbacks to the buttons. The callback uses 
 *   the integer button ID number (passed in as client_data) in the 
 *   information that is popped up.
 */
static void button_cb PROTO((xvobject, kaddr, kaddr));

#define BUTTON_NUM 5

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int         i;
	int         *button_id;
	xvobject    manager;
	xvobject    button;
	xvobject    offset;
	static char *names[] = {"AAA", "BBB", "CCC", "DDD", "EEE"};

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidget library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "Cannot open display");
           kexit(KEXIT_FAILURE);
	}

	/* create the manager backplane */
	manager = xvw_create_manager(NULL, "back");

	/* offset will be used to position set of buttons */
	offset = NULL;

	/* create set of buttons */
	for (i = 0; i < BUTTON_NUM; i++)
	{
	   /* create the button, set attributes */
	   button = xvw_create_button(manager, "button");
	   xvw_set_attributes(button,
		      XVW_LABEL,        names[i],      /* set label         */
		      XVW_RIGHT_OF,     offset,        /* R of last button  */
		      XVW_BELOW,        offset,        /* Below last button */
		      XVW_CHAR_WIDTH,   10.0,          /* 10 chars wide     */
		      XVW_CHAR_HEIGHT,  2.0,           /* 2 char high       */
		      XVW_BORDER_WIDTH, 1,             /* thin border       */
		      NULL);

	   /* allocate the client data - here, we'll need to pass an int */
	   button_id = (int *) kmalloc(sizeof(int));

	   /* initialize the integer value */
	   *button_id = i+100;
	
	   /* add the callback, passing the integer pointer as client data */
	   xvw_add_callback(button, XVW_BUTTON_SELECT, button_cb, button_id);

	   /* update offset, to achieve diagonal layout effect */
	   offset = button;
	}

	/* display and run */
	xvf_run_form();
}


/*
 *  this is the button callback, which expects an integer pointer
 *  as its client_data so it can print out the button ID number.
 */
static void button_cb (
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	char *label;
	int  *button_id;  /* client data will be an integer pointer */
	
	button_id = (int *) client_data; /* cast client_data to int pointer */

	/* to add interest to popup info message, get the button label */
	xvw_get_attribute(object, XVW_LABEL, &label);

	/* use the int pointer as desired, after cast */
	kinfo(KSTANDARD, "Button click on %s, ID number %d\n", 
	      label, *button_id);
}
